/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.util;

public class Coordinate {
    public double x;
    public double y;
    public double z;

    public Coordinate() {
        this(0.0, 0.0, 0.0);
    }

    public Coordinate(double d, double d2) {
        this(d, d2, 0.0);
    }

    public Coordinate(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Coordinate(Coordinate coordinate) {
        this.x = coordinate.x;
        this.y = coordinate.y;
        this.z = coordinate.z;
    }

    public void setCoordinate(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public double getIndex(int n) {
        if (n == 0) {
            return this.x;
        }
        if (n == 1) {
            return this.y;
        }
        return this.z;
    }

    public static Coordinate max(Coordinate coordinate, Coordinate coordinate2) {
        if (coordinate == null) {
            return coordinate2;
        }
        if (coordinate2 == null) {
            return coordinate;
        }
        return new Coordinate(Math.max(coordinate.x, coordinate2.x), Math.max(coordinate.y, coordinate2.y), Math.max(coordinate.z, coordinate2.z));
    }

    public static Coordinate min(Coordinate coordinate, Coordinate coordinate2) {
        if (coordinate == null) {
            return coordinate2;
        }
        if (coordinate2 == null) {
            return coordinate;
        }
        return new Coordinate(Math.min(coordinate.x, coordinate2.x), Math.min(coordinate.y, coordinate2.y), Math.min(coordinate.z, coordinate2.z));
    }

    public static Coordinate add(Coordinate coordinate, Coordinate coordinate2) {
        if (coordinate == null) {
            return coordinate2;
        }
        if (coordinate2 == null) {
            return coordinate;
        }
        return new Coordinate(coordinate.x + coordinate2.x, coordinate.y + coordinate2.y, coordinate.z + coordinate2.z);
    }

    public static Coordinate sub(Coordinate coordinate, Coordinate coordinate2) {
        if (coordinate == null) {
            return coordinate2;
        }
        if (coordinate2 == null) {
            return coordinate;
        }
        return new Coordinate(coordinate.x - coordinate2.x, coordinate.y - coordinate2.y, coordinate.z - coordinate2.z);
    }

    public boolean isValid() {
        return !Double.isNaN(this.x) && !Double.isInfinite(this.x) && !Double.isNaN(this.y) && !Double.isInfinite(this.y) && !Double.isNaN(this.z) && !Double.isInfinite(this.z);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")";
    }
}

