/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.util;

import java.util.StringTokenizer;
import jugglinglab.util.JuggleException;

public class Permutation {
    protected int size;
    protected int[] mapping;
    protected boolean reverses;

    public Permutation(int n, boolean bl) {
        this.size = n;
        this.reverses = bl;
        if (bl) {
            this.mapping = new int[this.size * 2 + 1];
            for (int i = 0; i < this.size * 2 + 1; ++i) {
                this.mapping[i] = i - this.size;
            }
        } else {
            this.mapping = new int[this.size];
            for (int i = 0; i < n; ++i) {
                this.mapping[i] = i + 1;
            }
        }
    }

    public Permutation(int n, int[] nArray, boolean bl) {
        this.size = n;
        this.reverses = bl;
        this.mapping = nArray;
    }

    public Permutation(int n, String string, boolean bl) throws JuggleException {
        Object object;
        int n2;
        boolean[] blArray;
        this.size = n;
        this.reverses = bl;
        if (bl) {
            this.mapping = new int[this.size * 2 + 1];
            blArray = new boolean[this.size * 2 + 1];
            for (n2 = 0; n2 < this.size * 2 + 1; ++n2) {
                this.mapping[n2] = 0;
                blArray[n2] = false;
            }
        } else {
            this.mapping = new int[this.size];
            blArray = new boolean[this.size];
            for (n2 = 0; n2 < n; ++n2) {
                this.mapping[n2] = 0;
                blArray[n2] = false;
            }
        }
        if (string.indexOf(40) == -1) {
            object = new StringTokenizer(string, ",");
            if (((StringTokenizer)object).countTokens() != this.size) {
                throw new JuggleException("Permutation init error: must have " + n + " elements in mapping");
            }
            for (n2 = 0; n2 < this.size; ++n2) {
                int n3;
                String string2 = ((StringTokenizer)object).nextToken().trim();
                try {
                    n3 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new JuggleException("Permutation init error: number format");
                }
                if (n3 < 1 || n3 > this.size) {
                    throw new JuggleException("Permutation init error: out of range");
                }
                if (blArray[n3 - 1]) {
                    throw new JuggleException("Permutation init error: not one-to-one");
                }
                blArray[n3 - 1] = true;
                this.mapping[n2] = n3;
            }
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ")");
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken().trim();
                if (((String)object).charAt(0) != '(') {
                    throw new JuggleException("Permutation init error: parenthesis not grouped");
                }
                object = ((String)object).substring(1);
                int n4 = 0;
                int n5 = -(this.size + 1);
                StringTokenizer stringTokenizer2 = new StringTokenizer((String)object, ",");
                while (stringTokenizer2.hasMoreTokens()) {
                    String string3 = stringTokenizer2.nextToken().trim();
                    try {
                        if (bl) {
                            boolean bl2 = false;
                            if (string3.endsWith("*")) {
                                bl2 = true;
                                string3 = string3.replace('*', ' ').trim();
                            }
                            n4 = Integer.parseInt(string3);
                            if (bl2) {
                                n4 = -n4;
                            }
                        } else {
                            n4 = Integer.parseInt(string3);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new JuggleException("Permutation init error: number format");
                    }
                    if (bl) {
                        if (n4 < -this.size || n4 > this.size || n4 == 0) {
                            throw new JuggleException("Permutation init error: out of range");
                        }
                        if (blArray[n4 + this.size]) {
                            throw new JuggleException("Permutation init error: not one-to-one");
                        }
                        blArray[n4 + this.size] = true;
                        if (n5 == -(this.size + 1)) {
                            this.mapping[n4 + this.size] = n4;
                        } else {
                            this.mapping[n4 + this.size] = this.mapping[n5 + this.size];
                            this.mapping[n5 + this.size] = n4;
                            if (blArray[-n5 + this.size] && this.mapping[-n5 + this.size] != -n4) {
                                throw new JuggleException("Permutation init error: input not reversible");
                            }
                        }
                    } else {
                        if (n4 < 1 || n4 > this.size) {
                            throw new JuggleException("Permutation init error: out of range");
                        }
                        if (blArray[n4 - 1]) {
                            throw new JuggleException("Permutation init error: not one-to-one");
                        }
                        blArray[n4 - 1] = true;
                        if (n5 == -(this.size + 1)) {
                            this.mapping[n4 - 1] = n4;
                        } else {
                            this.mapping[n4 - 1] = this.mapping[n5 - 1];
                            this.mapping[n5 - 1] = n4;
                        }
                    }
                    n5 = n4;
                }
            }
        }
        if (bl) {
            for (n2 = 1; n2 <= this.size; ++n2) {
                if (blArray[n2 + this.size] && !blArray[-n2 + this.size]) {
                    this.mapping[-n2 + this.size] = -this.mapping[n2 + this.size];
                    continue;
                }
                if (!blArray[n2 + this.size] && blArray[-n2 + this.size]) {
                    this.mapping[n2 + this.size] = -this.mapping[-n2 + this.size];
                    continue;
                }
                if (blArray[n2 + this.size] || blArray[-n2 + this.size]) continue;
                this.mapping[-n2 + this.size] = 0;
                this.mapping[n2 + this.size] = 0;
            }
        } else {
            for (n2 = 0; n2 < this.size; ++n2) {
                if (blArray[n2]) continue;
                this.mapping[n2] = n2 + 1;
            }
        }
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        String string;
        if (bl) {
            if (this.reverses) {
                int n;
                boolean[] blArray = new boolean[this.size];
                for (n = 0; n < this.size; ++n) {
                    blArray[n] = false;
                }
                string = "";
                for (n = 0; n < this.size; ++n) {
                    if (blArray[n]) continue;
                    int n2 = n + 1;
                    blArray[n] = true;
                    int n3 = this.mapping[n2 + this.size];
                    if (n3 == 0) continue;
                    string = string + "(" + this.convertReverse(n2);
                    while (n3 != n2) {
                        if (n3 > 0) {
                            blArray[n3 - 1] = true;
                        } else if (n3 < 0) {
                            blArray[-n3 - 1] = true;
                        }
                        string = string + "," + this.convertReverse(n3);
                        n3 = this.mapping[n3 + this.size];
                    }
                    string = string + ")";
                }
            } else {
                int n;
                int n4 = this.size;
                boolean[] blArray = new boolean[this.size];
                for (n = 0; n < this.size; ++n) {
                    blArray[n] = false;
                }
                string = "";
                while (n4 > 0) {
                    for (n = 0; n < this.size && blArray[n]; ++n) {
                    }
                    int n5 = n + 1;
                    blArray[n] = true;
                    string = string + "(" + n5;
                    --n4;
                    int n6 = this.mapping[n];
                    while (n6 != n5) {
                        string = string + "," + n6;
                        blArray[n6 - 1] = true;
                        --n4;
                        n6 = this.mapping[n6 - 1];
                    }
                    string = string + ")";
                }
            }
        } else if (this.reverses) {
            string = this.convertReverse(this.mapping[this.size + 1]);
            for (int i = 1; i < this.size; ++i) {
                string = string + "," + this.convertReverse(this.mapping[this.size + 1 + i]);
            }
        } else {
            string = "" + this.mapping[0];
            for (int i = 1; i < this.size; ++i) {
                string = string + "," + this.mapping[i];
            }
        }
        return string;
    }

    protected String convertReverse(int n) {
        if (n >= 0) {
            return "" + n;
        }
        return -n + "*";
    }

    public int getSize() {
        return this.size;
    }

    public boolean hasReverses() {
        return this.reverses;
    }

    public boolean equals(Permutation permutation) {
        if (permutation == null) {
            return false;
        }
        if (this.reverses != permutation.hasReverses()) {
            return false;
        }
        if (this.getSize() != permutation.getSize()) {
            return false;
        }
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.getMapping(i + 1) == permutation.getMapping(i + 1)) continue;
            return false;
        }
        return true;
    }

    public int getMapping(int n) {
        if (this.reverses) {
            return this.mapping[n + this.size];
        }
        return this.mapping[n - 1];
    }

    public int getMapping(int n, int n2) {
        block3: {
            block2: {
                if (n2 <= 0) break block2;
                for (int i = 0; i < n2; ++i) {
                    n = this.getMapping(n);
                }
                break block3;
            }
            if (n2 >= 0) break block3;
            for (int i = n2; i < 0; ++i) {
                n = this.getInverseMapping(n);
            }
        }
        return n;
    }

    public Permutation apply(Permutation permutation) {
        if (this.getSize() != permutation.getSize()) {
            return null;
        }
        if (this.hasReverses() || permutation.hasReverses()) {
            return null;
        }
        int[] nArray = new int[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            nArray[i] = this.getMapping(permutation.getMapping(i + 1));
        }
        return new Permutation(this.getSize(), nArray, false);
    }

    public int getInverseMapping(int n) {
        if (this.reverses) {
            for (int i = 0; i < 2 * this.size + 1; ++i) {
                if (this.mapping[i] != n) continue;
                return i - this.size;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (this.mapping[i] != n) continue;
                return i + 1;
            }
        }
        return 0;
    }

    public Permutation getInverse() {
        int[] nArray = null;
        if (this.reverses) {
            nArray = new int[this.size * 2 + 1];
            for (int i = 0; i < this.size * 2 + 1; ++i) {
                nArray[this.mapping[i] + this.size] = i - this.size;
            }
        } else {
            nArray = new int[this.size];
            for (int i = 0; i < this.size; ++i) {
                nArray[this.mapping[i] - 1] = i + 1;
            }
        }
        return new Permutation(this.size, nArray, this.reverses);
    }

    public static int lcm(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = n2;
        while (n > 0) {
            n5 = n;
            n = n2 % n;
            n2 = n5;
        }
        return n3 * n4 / n5;
    }

    public int getOrder() {
        int n = 1;
        for (int i = 1; i <= this.size; ++i) {
            if (this.getMapping(i) == 0) continue;
            n = Permutation.lcm(n, this.getOrder(i));
        }
        return n;
    }

    public int getOrder(int n) {
        int n2;
        int n3 = 1;
        int n4 = n2 = this.reverses ? n + this.size : n - 1;
        while (this.mapping[n2] != n) {
            ++n3;
            n2 = this.mapping[n2] + (this.reverses ? this.size : -1);
        }
        return n3;
    }

    public int[] getCycle(int n) {
        int n2 = this.getOrder(n);
        int[] nArray = new int[n2];
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n3;
            n3 = this.mapping[this.reverses ? n3 + this.size : n3 - 1];
        }
        return nArray;
    }
}

