
/*
 * mixer.h -- written for Juice
 *	Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef MIXER_MIXER_H
#define MIXER_MIXER_H

#include <sys/soundcard.h>

/*
 * Boolean definitions
 */

//#ifndef bool
#undef bool
#define bool int
//#endif

//#ifndef TRUE
#undef TRUE
#define TRUE 1
//#endif

//#ifndef FALSE
#undef FALSE
#define FALSE 0
//#endif

/*
 * Mixer feature definitions
 */

#define MIXER_VOLUME	SOUND_MIXER_VOLUME
#define MIXER_BASS		SOUND_MIXER_BASS
#define MIXER_TREBLE	SOUND_MIXER_TREBLE
#define MIXER_SYNTH		SOUND_MIXER_SYNTH
#define MIXER_PCM		SOUND_MIXER_PCM
#define MIXER_SPEAKER	SOUND_MIXER_SPEAKER
#define MIXER_LINE		SOUND_MIXER_LINE
#define MIXER_MIC		SOUND_MIXER_MIC
#define MIXER_CD		SOUND_MIXER_CD
#define MIXER_IGAIN		SOUND_MIXER_IGAIN
#define MIXER_OGAIN		SOUND_MIXER_OGAIN

/*
 * Mixer device
 */

#define MIXER_DEVICE	"/dev/mixer"

/*
 * Mixer class header
 */

class Mixer
{
 public:
   /* Open mixer - Return TRUE if successful, FALSE otherwise */
   bool Open ();
   /* Close mixer */
   void Close ();
   /* Check if mixer has specified channel */
   bool HasChannel (int channel);
   /* Check if channel is stereo */
   bool IsStereo (int channel);
   /* Get volume of sepcified channel */
   int GetVolume (int channel);
   /* Set volume of specified channel */
   void SetVolume (int channel,int volume);
 private:
   /* Mixer file descriptor */
   int mixer_fd;
};

#endif
