package main

import (
	. "launchpad.net/gocheck"
	"launchpad.net/juju-core/charm"
	"launchpad.net/juju-core/testing"
)

type UnexposeSuite struct {
	repoSuite
}

var _ = Suite(&UnexposeSuite{})

func runUnexpose(c *C, args ...string) error {
	_, err := testing.RunCommand(c, &UnexposeCommand{}, args)
	return err
}

func (s *UnexposeSuite) assertExposed(c *C, service string, expected bool) {
	svc, err := s.State.Service(service)
	c.Assert(err, IsNil)
	actual := svc.IsExposed()
	c.Assert(actual, Equals, expected)
}

func (s *UnexposeSuite) TestUnexpose(c *C) {
	testing.Charms.BundlePath(s.seriesPath, "dummy")
	err := runDeploy(c, "local:dummy", "some-service-name")
	c.Assert(err, IsNil)
	curl := charm.MustParseURL("local:precise/dummy-1")
	s.assertService(c, "some-service-name", curl, 1, 0)

	err = runExpose(c, "some-service-name")
	c.Assert(err, IsNil)
	s.assertExposed(c, "some-service-name", true)

	err = runUnexpose(c, "some-service-name")
	c.Assert(err, IsNil)
	s.assertExposed(c, "some-service-name", false)

	err = runUnexpose(c, "nonexistent-service")
	c.Assert(err, ErrorMatches, `service "nonexistent-service" not found`)
}
