from yaml import dump

from juju.environment.errors import EnvironmentsConfigError
from juju.environment.config import EnvironmentsConfig
from juju.control.utils import get_environment
from juju.control.tests.common import ControlToolTest


class FakeOptions(object):
    pass


class GetEnvironmentTest(ControlToolTest):

    def test_get_environment(self):
        config = {
            "environments": {"firstenv": {"type": "dummy"}}}
        self.write_config(dump(config))

        env_config = EnvironmentsConfig()
        env_config.load_or_write_sample()
        options = FakeOptions()
        options.environment = None
        options.environments = env_config

        environment = get_environment(options)
        self.assertEqual(environment.name, "firstenv")

    def test_get_environment_default_with_multiple(self):
        config = {
            "environments": {"firstenv": {"type": "dummy"},
                             "secondenv": {"type": "dummy"}}}
        self.write_config(dump(config))

        env_config = EnvironmentsConfig()
        env_config.load_or_write_sample()
        options = FakeOptions()
        options.environment = None
        options.environments = env_config

        error = self.assertRaises(
            EnvironmentsConfigError,
            get_environment,
            options)

        self.assertIn(
            "There are multiple environments and no explicit default",
            str(error))

    def test_get_nonexistant_environment(self):
        config = {
            "environments": {"firstenv": {"type": "dummy"},
                             "secondenv": {"type": "dummy"}}}
        self.write_config(dump(config))

        env_config = EnvironmentsConfig()
        env_config.load_or_write_sample()
        options = FakeOptions()
        options.environment = "volcano"
        options.environments = env_config

        error = self.assertRaises(
            EnvironmentsConfigError,
            get_environment,
            options)

        self.assertIn("Invalid environment 'volcano'", str(error))
