; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mcpu=corei7 | FileCheck %s --check-prefix=ALL --check-prefix=X64
; RUN: llc < %s -mtriple=x86_64-- -mcpu=corei7-avx | FileCheck %s --check-prefix=ALL --check-prefix=SHLD
; RUN: llc < %s -mtriple=x86_64-- -mcpu=core-avx2 | FileCheck %s --check-prefix=ALL --check-prefix=BMI2

define i64 @foo(i64 %x, i64 %y, i64 %z) nounwind readnone {
; ALL-LABEL: foo:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    movl %edx, %ecx
; ALL-NEXT:    rolq %cl, %rdi
; ALL-NEXT:    movq %rdi, %rax
; ALL-NEXT:    retq
entry:
	%0 = shl i64 %x, %z
	%1 = sub i64 64, %z
	%2 = lshr i64 %x, %1
	%3 = or i64 %2, %0
	ret i64 %3
}

define i64 @bar(i64 %x, i64 %y, i64 %z) nounwind readnone {
; ALL-LABEL: bar:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    movl %edx, %ecx
; ALL-NEXT:    shldq %cl, %rdi, %rsi
; ALL-NEXT:    movq %rsi, %rax
; ALL-NEXT:    retq
entry:
	%0 = shl i64 %y, %z
	%1 = sub i64 64, %z
	%2 = lshr i64 %x, %1
	%3 = or i64 %2, %0
	ret i64 %3
}

define i64 @un(i64 %x, i64 %y, i64 %z) nounwind readnone {
; ALL-LABEL: un:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    movl %edx, %ecx
; ALL-NEXT:    rorq %cl, %rdi
; ALL-NEXT:    movq %rdi, %rax
; ALL-NEXT:    retq
entry:
	%0 = lshr i64 %x, %z
	%1 = sub i64 64, %z
	%2 = shl i64 %x, %1
	%3 = or i64 %2, %0
	ret i64 %3
}

define i64 @bu(i64 %x, i64 %y, i64 %z) nounwind readnone {
; ALL-LABEL: bu:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    movl %edx, %ecx
; ALL-NEXT:    shrdq %cl, %rdi, %rsi
; ALL-NEXT:    movq %rsi, %rax
; ALL-NEXT:    retq
entry:
	%0 = lshr i64 %y, %z
	%1 = sub i64 64, %z
	%2 = shl i64 %x, %1
	%3 = or i64 %2, %0
	ret i64 %3
}

define i64 @xfoo(i64 %x, i64 %y, i64 %z) nounwind readnone {
; X64-LABEL: xfoo:
; X64:       # %bb.0: # %entry
; X64-NEXT:    rolq $7, %rdi
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    retq
;
; SHLD-LABEL: xfoo:
; SHLD:       # %bb.0: # %entry
; SHLD-NEXT:    shldq $7, %rdi, %rdi
; SHLD-NEXT:    movq %rdi, %rax
; SHLD-NEXT:    retq
;
; BMI2-LABEL: xfoo:
; BMI2:       # %bb.0: # %entry
; BMI2-NEXT:    rorxq $57, %rdi, %rax
; BMI2-NEXT:    retq
entry:
	%0 = lshr i64 %x, 57
	%1 = shl i64 %x, 7
	%2 = or i64 %0, %1
	ret i64 %2
}

define i64 @xfoop(i64* %p) nounwind readnone {
; X64-LABEL: xfoop:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movq (%rdi), %rax
; X64-NEXT:    rolq $7, %rax
; X64-NEXT:    retq
;
; SHLD-LABEL: xfoop:
; SHLD:       # %bb.0: # %entry
; SHLD-NEXT:    movq (%rdi), %rax
; SHLD-NEXT:    shldq $7, %rax, %rax
; SHLD-NEXT:    retq
;
; BMI2-LABEL: xfoop:
; BMI2:       # %bb.0: # %entry
; BMI2-NEXT:    rorxq $57, (%rdi), %rax
; BMI2-NEXT:    retq
entry:
	%x = load i64, i64* %p
	%a = lshr i64 %x, 57
	%b = shl i64 %x, 7
	%c = or i64 %a, %b
	ret i64 %c
}

define i64 @xbar(i64 %x, i64 %y, i64 %z) nounwind readnone {
; ALL-LABEL: xbar:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    shrdq $57, %rsi, %rdi
; ALL-NEXT:    movq %rdi, %rax
; ALL-NEXT:    retq
entry:
	%0 = shl i64 %y, 7
	%1 = lshr i64 %x, 57
	%2 = or i64 %0, %1
	ret i64 %2
}

define i64 @xun(i64 %x, i64 %y, i64 %z) nounwind readnone {
; X64-LABEL: xun:
; X64:       # %bb.0: # %entry
; X64-NEXT:    rolq $57, %rdi
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    retq
;
; SHLD-LABEL: xun:
; SHLD:       # %bb.0: # %entry
; SHLD-NEXT:    shldq $57, %rdi, %rdi
; SHLD-NEXT:    movq %rdi, %rax
; SHLD-NEXT:    retq
;
; BMI2-LABEL: xun:
; BMI2:       # %bb.0: # %entry
; BMI2-NEXT:    rorxq $7, %rdi, %rax
; BMI2-NEXT:    retq
entry:
	%0 = lshr i64 %x, 7
	%1 = shl i64 %x, 57
	%2 = or i64 %0, %1
	ret i64 %2
}

define i64 @xunp(i64* %p) nounwind readnone {
; X64-LABEL: xunp:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movq (%rdi), %rax
; X64-NEXT:    rolq $57, %rax
; X64-NEXT:    retq
;
; SHLD-LABEL: xunp:
; SHLD:       # %bb.0: # %entry
; SHLD-NEXT:    movq (%rdi), %rax
; SHLD-NEXT:    shldq $57, %rax, %rax
; SHLD-NEXT:    retq
;
; BMI2-LABEL: xunp:
; BMI2:       # %bb.0: # %entry
; BMI2-NEXT:    rorxq $7, (%rdi), %rax
; BMI2-NEXT:    retq
entry:
	%x = load i64, i64* %p
	%a = lshr i64 %x, 7
	%b = shl i64 %x, 57
	%c = or i64 %a, %b
	ret i64 %c
}

define i64 @xbu(i64 %x, i64 %y, i64 %z) nounwind readnone {
; ALL-LABEL: xbu:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    shldq $57, %rsi, %rdi
; ALL-NEXT:    movq %rdi, %rax
; ALL-NEXT:    retq
entry:
	%0 = lshr i64 %y, 7
	%1 = shl i64 %x, 57
	%2 = or i64 %0, %1
	ret i64 %2
}
