/**
 * Copyright 2009 Daniel Naber
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.abelssoft;

import java.io.IOException;
import java.util.Collection;

import de.abelssoft.wordtools.jWordSplitter.AbstractWordSplitter;
import de.abelssoft.wordtools.jWordSplitter.impl.GermanWordSplitter;

/**
 * A very simple example of how to use jWordSplitter.
 * 
 * @author Daniel Naber
 */
public class Example {

  public static void main(String[] args) throws IOException {
    AbstractWordSplitter splitter = new GermanWordSplitter(true);
    Collection<String> parts = splitter.splitWord("Bahnhofsuhr");
    System.out.println(parts);
  }
  
}
