#####################################################
# K3D_WITH_EXTERNAL_BOOST

AC_DEFUN([K3D_WITH_EXTERNAL_BOOST], [
AC_SUBST(K3D_BOOST_SUBDIR)
AC_SUBST(K3D_BOOST_CPPFLAGS)
AC_SUBST(K3D_BOOST_LIBS)

AC_ARG_WITH(external-boost, [  --with-external-boost   use an external boost library instead of the version included with the K-3D source [[no]]],[],[withval=no])
if test x$withval != xno; then
	AC_CHECK_HEADER([boost/version.hpp],
	[
		K3D_BOOST_SUBDIR=""
		K3D_BOOST_CPPFLAGS=""
		K3D_BOOST_LIBS="-lboost_regex -lboost_date_time -lboost_filesystem"
		AC_MSG_RESULT([Using external boost library])
	],
	[
		AC_MSG_ERROR([couldn't find boost library ... either install boost or re-run configure using the --without-external-boost option])
	])
	AC_CHECK_LIB(boost_regex, main, [],
	[
		AC_MSG_ERROR([couldn't find boost_regex library])
	])
	AC_CHECK_LIB(boost_date_time, main, [],
	[
		AC_MSG_ERROR([couldn't find boost_date_time library])
	])
	AC_CHECK_LIB(boost_filesystem, main, [],
	[
		AC_MSG_ERROR([couldn't find boost_filesystem library])
	])
else
	K3D_BOOST_SUBDIR="boost"
	K3D_BOOST_CPPFLAGS="-I\$(top_srcdir)/boost"
	K3D_BOOST_LIBS='$(top_builddir)/boost/libs/regex/src/libregexpp.la $(top_builddir)/boost/libs/date_time/src/gregorian/libgregorian.la $(top_builddir)/boost/libs/date_time/src/posix_time/libposixtime.la $(top_builddir)/boost/libs/filesystem/src/libfilesystempp.la'
	AC_MSG_RESULT([Using internal boost library])
fi
])

