#ifndef NGUI_BLACK_BOX_RECORDER_H
#define NGUI_BLACK_BOX_RECORDER_H

// K-3D
// Copyright (c) 1995-2005, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares functions for displaying a "Tutorial Message" dialog that prompts the user and provides feedback during interactive tutorial playback
		\author Tim Shead (tshead@k-3d.com)
*/

#include <k3dsdk/data.h>
#include <k3dsdk/iuser_interface.h>
#include <k3dsdk/signal_system.h>

namespace boost { namespace filesystem { class path; } }

namespace libk3dngui
{

/** \todo Figure out whether to keep this or toss it */
/// Singleton object that manages the global black box recorder
class black_box_recorder
{
public:
	/// Returns a singleton instance
	static black_box_recorder& instance();

	/// Starts recording user input (may display K-3D bug buddy)
	void start();
	/// Returns true while recording is in progress
	const bool recording();
	/// Connects a slot to a signal that will be emitted whenever the recording state changes
	sigc::connection connect_recording_changed_signal(const sigc::slot<void>& Slot);
	/// Logs the beginning of a file operation
	void start_file(const boost::filesystem::path& File);
	/// Logs the end of a file operation
	void complete_file(const boost::filesystem::path& File);
	/// Embeds an arbitrary message into the log
	void record_message(const std::string& Message);
	/// Prompts the user to stop recording user input
	void prompt_stop();
	/// Unconditionally stops recording user input
	void stop();

	/// RAII class that calls start_file() and complete_file()
	class process_file
	{
	public:
		process_file(const boost::filesystem::path& File);
		~process_file();

	private:
		const boost::filesystem::path file;
	};
	
private:
	black_box_recorder();
	black_box_recorder(const black_box_recorder&);
	black_box_recorder& operator=(const black_box_recorder&);
	~black_box_recorder();

	class implementation;
	implementation* const m_implementation;
};

} // namespace libk3dngui

#endif // NGUI_BLACK_BOX_RECORDER_H

