/***************************************************************************
*   Copyright (C) 2005 by Jean-Michel Petit                               *
*   jm_petit@laposte.net                                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include "k9cellcopylist.h"
#include "k9dvdtitle.h"
#include <kmessagebox.h>
#include <dvdread/ifo_read.h>
#include <dvdread/ifo_types.h>
#include <qptrlist.h>

int k9CellVTSList::compareItems ( QPtrCollection::Item item1, QPtrCollection::Item item2 ) {
	k9CellCopyVTS * it1,*it2;
	it1=(k9CellCopyVTS *) item1;
	it2=(k9CellCopyVTS *)item2;
	if (it1->getsize() >it2->getsize())
		return 1;
	else if (it1->getsize() <it2->getsize())
		return -1;
	else {
		if (it1->getnum()>it2->getnum())
			return 1;
		else
			return -1;
	}
}

uint k9CellCopyVTS::getnum() {
	return num;
}
void k9CellCopyVTS::addsize(uint32_t _size) {
	size+=_size;
}
uint64_t k9CellCopyVTS::getsize() {
	return size;
}

k9CellCopyList::k9CellCopyList(dvd_reader_t * _dvdHandle,k9DVD *_DVD)
        : QObjectList() {
    setAutoDelete(true);
    DVD=_DVD;
    dvdHandle=_dvdHandle;
    fill();


}

k9CellCopyList::~k9CellCopyList() {}

/*!
    \fn k9CellCopyList::fill()
 */
void k9CellCopyList::fill() {
    ifo_handle_t *hifo,*hifoZero;
    hifoZero = ifoOpen (dvdHandle, 0);
    int nrTS= hifoZero->vmgi_mat->vmg_nr_of_title_sets;

    for (int iTS=1 ; iTS<=nrTS;iTS++) {
        hifo=ifoOpen(dvdHandle,iTS);
        for(uint32_t i = 0; i < hifo->vts_pgcit->nr_of_pgci_srp; i++) {
            pgc_t *pgc=hifo->vts_pgcit->pgci_srp[i].pgc;
            cell_playback_t *cell_playback =pgc->cell_playback;
            int nr= pgc->nr_of_cells;

	   uchar angleBlock=angleNone;	
	    k9Cell *cell=NULL;
            for( int j = 0; j < nr; j++) {		
		if ( (cell_playback[j].block_type == BLOCK_TYPE_ANGLE_BLOCK) &&   (cell_playback[j].block_mode==BLOCK_MODE_FIRST_CELL)) 
			angleBlock=angleStart;		
		else if ((cell_playback[j].block_type == BLOCK_TYPE_ANGLE_BLOCK ) && (cell_playback[j].block_mode==BLOCK_MODE_IN_BLOCK)) 
			angleBlock=angleInside;
		else if (cell_playback[j].block_type ==BLOCK_MODE_NOT_IN_BLOCK)
			angleBlock=angleNone;
		else if ((cell_playback[j].block_type == BLOCK_TYPE_ANGLE_BLOCK ) && (cell_playback[j].block_mode==BLOCK_MODE_LAST_CELL))
			angleBlock=angleEnd;
/*		if (cell !=NULL) 
		    if ((angleBlock == angleNone) && (cell->angleBlock != angleNone) && (cell->angleBlock!=angleEnd))
			cell->angleBlock |=angleEnd;
*/
                cell=addCell(iTS,i+1,j+1,cell_playback[j].first_sector,cell_playback[j].last_sector,angleBlock);
            }
        }
        ifoClose(hifo);
    }
    ifoClose(hifoZero);
    sortVTSList();
}


k9Cell *k9CellCopyList::addCell(int _VTS,int _pgc,int _id,uint32_t startSector,uint32_t lastSector,uchar _angleBlock) {
    bool bInsert=false;
    bool bFound=false;
    uint position=0;
    k9Cell *cell =NULL;

    for (uint i=0;i< count() && !bFound && !bInsert;i++) {
        cell=(k9Cell*) at(i);
        if (cell->startSector ==startSector && cell->vts==_VTS) {
            bFound=true;
            if (cell->lastSector!=lastSector  )
                KMessageBox::error(0,"last sector doesn't match","DVD Backup");

        }
        if (!bFound && (_VTS <cell->vts  || (startSector<cell->startSector  && cell->vts ==_VTS ) )) {
            bInsert=true;
            position=i;
        }

    }

    if (!bFound) {
        cell = new k9Cell();
        cell->vts=_VTS;
        cell->startSector=startSector;
        cell->lastSector=lastSector;
        cell->pgc=_pgc;
        cell->id=_id;
	cell->angleBlock=_angleBlock;
        cell->selected=checkSelected(cell);

        if (bInsert)
            insert(position,cell);
        else
            append(cell);

	uint32_t isize;
	isize= cell->selected ? ((lastSector-startSector)*2048):2;
 	setVTS(_VTS,isize);
    }
    return(cell);
}
void k9CellCopyList::setVTS(uint _numVTS,uint32_t _size){
  bool bfound=false;
  for (uint iVTS=0; iVTS<VTSList.count();iVTS++) {
	k9CellCopyVTS *VTS=VTSList.at(iVTS);
	if (VTS->getnum()==_numVTS) {
		VTS->addsize(_size);
		bfound=true;
	}
    }
    if (!bfound) {
	k9CellCopyVTS * VTS= new k9CellCopyVTS(_numVTS);
	VTS->addsize(_size);
	VTSList.append(VTS);
   }
}

void k9CellCopyList::sortVTSList() {
	VTSList.sort();
}

void k9CellCopyList::addStreams(k9DVDTitle *_title,k9Cell *_cell) {
    k9DVDSubtitle *l_sub;
    k9DVDAudioStream *l_auds;
    for (int i=0;i<_title->getaudioStreamCount();i++) {
        l_auds=_title->getaudioStream(i);
        if (l_auds->getselected()) {
            QValueList<int>::iterator it;
            bool found=false;
            for ( it = _cell->audio.begin(); it != _cell->audio.end(); ++it ) {
                if (*it == l_auds->getID())
                    found=true;
            }
            if (!found)
                _cell->audio.append(l_auds->getID());
        }
    }

    for (int i=0;i<_title->getsubPictureCount();i++) {
        QString c;
        l_sub=_title->getsubtitle(i);
        if (l_sub->getselected()) {
            QValueList<int>::iterator it;
            bool found=false;
            for ( it = _cell->subpicture.begin(); it != _cell->subpicture.end(); ++it ) {
                if (*it == l_sub->getID())
                    found=true;
            }
            if (!found)
                _cell->subpicture.append(l_sub->getID());
        }
    }
}

/*!
    \fn k9CellCopyList::checkSelected(k9Cell *_cell)
 */
bool k9CellCopyList::checkSelected(k9Cell *_cell) {
    for (int i=0; i< DVD->gettitleCount();i++) {
        k9DVDTitle *title=DVD->gettitle(i);
        if ( title->getVTS()==_cell->vts  && title ->isSelected()) {
            for (int j=0; j <title->getchapterCount();j++) {
                k9DVDChapter * chapter= title->getChapter(j);
                QValueList<uint32_t>::iterator it;
                for ( it = chapter->startSectors.begin(); it != chapter->startSectors.end(); ++it ) {
                    if (_cell->startSector == (*it)) {
                        addStreams (title,_cell);
                        return true;
                    }
                }
            }
        }
    }
    return false;
}

double k9CellCopyList::getcopiedSize() {
  double copiedSize=0;
  for (uint iCell=0;iCell<count();iCell++) {
        k9Cell *cell=(k9Cell*)at(iCell);
        if (cell->copied)
            copiedSize += cell->newSize;
    }
   return  (copiedSize*2048);;
}

double  k9CellCopyList::gettotalSize() {
  double  totalSize=0;
  for (uint iCell=0;iCell<count();iCell++) {
        k9Cell *cell=(k9Cell*)at(iCell);
	if (!cell->copied) {
		if (cell->selected) {
			if (cell->angleBlock==angleNone)
				totalSize += cell->lastSector-cell->startSector;
			else if (cell->angleBlock=angleStart) {
				uint32_t start=0,end=0;
				start=cell->startSector;
				while (((k9Cell*)at(iCell))->angleBlock !=angleNone) {
					end=((k9Cell*)at(iCell))->lastSector;
					iCell++;
				}
				iCell--;
				totalSize += end-start;
			}
		} else
		totalSize += 2;
	}
    }
   return  (totalSize*2048);;

}


double k9CellCopyList::getfactor(bool _withMenus,bool _streams) {
   
   double totalSize=gettotalSize();

    if (_streams) {
        double unsel=0;
        for (int i=0;i<DVD->gettitleCount();i++) {
            k9DVDTitle *track=DVD->gettitle(i);
            for (int j=0; j<track->getaudioStreamCount();j++) {
                k9DVDAudioStream *audio=track->getaudioStream(j);
                if (! audio->getselected())
                    unsel+=audio->getsize_mb();
            }
            for (int j=0; j<track->getsubPictureCount();j++) {
                k9DVDSubtitle *sub=track->getsubtitle(j);
                if (! sub->getselected())
                    unsel+=sub->getsize_mb();
            }
        }
        unsel*=1024*1024;
        totalSize-=unsel;
    }

    double menuSize=0;

    if (_withMenus)
        menuSize=DVD->getmenuSize();

    menuSize= menuSize*2048;

    double dvdSize=4400 ;
    dvdSize*=1024*1024;

    double factor;
//    if (totalSize <dvdSize)
//	factor=1;
//    else {
        double dvdSize2=dvdSize;
        dvdSize2 -=menuSize;
	factor=totalSize/ (dvdSize2-getcopiedSize());
	
	factor = (int)(factor*100);
	factor /=100;
	factor+=0.01;
//    }
    if (factor<=1)
        factor=1;
    return (factor);
}
