/***************************************************************************
*   Copyright (C) 2005 by Jean-Michel Petit                               *
*   k9copy@free.fr                                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

#include "k9main.h"
#include "k9common.h"
#include "k9dvdauthor.h"
#include "k9burndvd.h"
#include "k9dvd.h"
#include "k9dvdtitle.h"
#include "k9dvdtitleset.h"
#include "k9dvdbackup.h"
#include "k9mp4enc.h"
#include "k9settings.h"
#include "k9langselect.h"
#include "k9config.h"
#include "k9updatefactor.h"
#include "k9titleencopt.h"
#include "k9tools.h"
#include <kcombobox.h>
#include <qtextbrowser.h>
#include <qapplication.h>
#include <qlistview.h>
#include <kurlrequester.h>
#include <kurl.h>
#include <qdir.h>
#include <kstandarddirs.h>
#include <qspinbox.h>
#include <qstatusbar.h>
#include <kpushbutton.h>
#include <qcheckbox.h>
#include <qmenubar.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qspinbox.h>
#include <qpainter.h>
#include <kdirselectdialog.h>
#include <kio/global.h>
#include <kio/job.h>
#include <kio/netaccess.h>
#include <kdeversion.h>
#include <qbitmap.h>
#include "images.h"
#include <KDiskFreeSpace>
#include <kmountpoint.h>
#include <kiconloader.h>
#include "k9process.h"
#include "k9execcopy.h"

#include "k9dialogs.h"

ckLvItem::ckLvItem ( QTreeWidgetItem *parent,k9Main *dlg,eObjectType _objectType )
        : QTreeWidgetItem ( parent,1001 ) {
    m_checked=false;
    mainDlg=dlg;
    obj=NULL;
    stream=NULL;
    streamType=NONE;
    language="";
    objectType=_objectType;
    setFlags ( Qt::ItemIsUserCheckable |Qt::ItemIsEnabled );
    setOn ( false );
}
ckLvItem::ckLvItem ( QTreeWidget *parent,k9Main *dlg,eObjectType _objectType )
        : QTreeWidgetItem ( parent,1001 ) {
    m_checked=false;
    mainDlg=dlg;
    obj=NULL;
    stream=NULL;
    streamType=NONE;
    language="";
    objectType=_objectType;
    setFlags ( Qt::ItemIsUserCheckable | Qt::ItemIsEnabled );
    setOn ( false );
    //QCheckBox *bx=new QCheckBox(NULL);
    //dlg->getTreeView()->setItemWidget ( this, 0, bx );

}


k9DVDListItem::k9DVDListItem ( void *DVD,ckLvItem *List,eStreamType type ) {
    switch ( type ) {
    case AUD :
        audioStream= ( k9DVDAudioStream* ) DVD;
        subtitle=NULL;
        title=NULL;
        break;
    case SUB :
        subtitle = ( k9DVDSubtitle* ) DVD;
        audioStream=NULL;
        title=NULL;
        break;
    case VID :
        subtitle=NULL;
        audioStream=NULL;
        title = ( k9DVDTitle* ) DVD;
        break;
    default :
        break;
    }
    listItem= List;
    streamType=type;
}

void k9Main::clearItems() {
    while ( !items.isEmpty() ) delete items.takeFirst();
}

k9Main::k9Main ( QWidget* parent, const char* , k9CdDrives *_drives )
        : QWidget ( parent ) {
    Ui_MainDlg.setupUi ( this );
    listView1=Ui_MainDlg.listView1;
    connect ( Ui_MainDlg.cbOutputDev,SIGNAL ( currentIndexChanged ( int ) ),this,SLOT ( cbOutputDevActivated ( int ) ) );
    connect ( listView1,SIGNAL ( itemExpanded ( QTreeWidgetItem* ) ),this,SLOT ( expanded ( QTreeWidgetItem* ) ) );
    connect ( listView1,SIGNAL ( itemCollapsed ( QTreeWidgetItem* ) ),this,SLOT ( collapsed ( QTreeWidgetItem* ) ) );
    drives=_drives;
    m_parent= ( k9Copy* ) parent;
    QImage img;
    img.loadFromData ( img_chapter, sizeof ( img_chapter ), "PNG" );
    pxChapter.fromImage ( img );
    /*    m_factory = KLibLoader::self()->factory("libk9copy");
    if (m_factory)      {
    dvd=static_cast<k9DVD  *>(m_factory->create(this,"dvd", "k9DVD"));
    }
    */

    dvd=new k9DVD ( this );

    updating=false;

//  items.setAutoDelete(true);
//  listView1->setDefaultRenameAction(QListView::Accept);
    //    KStandardDirs kd;
    m_prefOutput=KStandardDirs::locateLocal ( "tmp","k9copy/",true ); //kd.findResource("tmp","");
    connect ( drives,SIGNAL ( deviceAdded ( k9CdDrive* ) ),this,SLOT ( deviceAdded ( k9CdDrive* ) ) );
    connect ( drives,SIGNAL ( deviceRemoved ( k9CdDrive* ) ),this,SLOT ( deviceRemoved ( k9CdDrive* ) ) );

    readSettings();
    Ui_MainDlg.binputOpen->setIcon ( SmallIcon ( "document-open" ) );
    Ui_MainDlg.binputOpenDir->setIcon ( SmallIcon ( "folder-open" ) );
    emit SelectionChanged ( NULL,true );
    m_update=new k9UpdateFactor ( this,"" );
    connect ( m_update,SIGNAL ( updateFactor_internal() ),this,SLOT ( updateFactor_internal() ) );
}


k9DVDListItem *k9Main::addListItem ( void *DVD,ckLvItem *List,eStreamType type ) {
    k9DVDListItem *litem;
    litem=new k9DVDListItem ( DVD,List,type );
    items.append ( litem );
    return litem;
}
/*
int LvItem::() const
{
  return(1000);
}


int ckLvItem::rtti() const
{
  return(1001);
}
*/
bool ckLvItem::operator< ( const QTreeWidgetItem & other ) const {
    int col=treeWidget()->sortColumn();

    if ( other.type() !=1001 )
        return true;
    ckLvItem *litem = ( ckLvItem* ) &other;
    k9DVDTitleset *titleset1,*titleset2;
    ckLvItem *l;
    uint id,id2;
    if ( col==0 ) {
        switch ( this->objectType ) {
        case TITLESET:
            titleset1= ( k9DVDTitleset* ) obj;
            titleset2= ( k9DVDTitleset* ) litem->obj;
            return titleset1->getnum() >titleset2->getnum();
        case STREAM:
            l= ( ckLvItem* ) this;
            id=streamType*100;
            id2=litem->streamType*100;

            if ( streamType==AUD ) {
                id+= ( ( k9DVDAudioStream* ) l->stream )->getID();
            }
            if ( streamType==SUB ) {
                id+= ( ( k9DVDSubtitle* ) l->stream )->getID().first();
            }

            if ( litem->streamType==AUD ) {
                id2+= ( ( k9DVDAudioStream* ) litem->stream )->getID();
            }
            if ( litem->streamType==SUB ) {
                id2+= ( ( k9DVDSubtitle* ) litem->stream )->getID().first();
            }


            return k9Main::compare ( id,id2 );
            break;
        case CHAPTER: {
            l= ( ckLvItem* ) this;
            k9DVDChapter *ch1= ( k9DVDChapter* ) l->obj;
            k9DVDChapter *ch2= ( k9DVDChapter* ) litem->obj;
            return k9Main::compare ( ch1->getnum() +ch1->getTitle()->getId() *1000 ,ch2->getnum() +ch2->getTitle()->getId() *1000 );
        }
        break;
        default:
            return true;
        }
    }

    if ( col ==1 ) {
        switch ( this->objectType ) {
        case TITLESET:
            titleset1= ( k9DVDTitleset* ) obj;
            titleset2= ( k9DVDTitleset* ) litem->obj;
            return k9Main::compare ( titleset1->getsize(),titleset2->getsize() );
            break;
        case STREAM:
            double size1,size2;
            l = ( ckLvItem* ) this;
            size1=l->getstreamSize();
            size2=litem->getstreamSize();
            return k9Main::compare ( size1,size2 );
            break;
        case CHAPTER: {
            l= ( ckLvItem* ) this;
            k9DVDChapter *ch1= ( k9DVDChapter* ) l->obj;
            k9DVDChapter *ch2= ( k9DVDChapter* ) litem->obj;
            return k9Main::compare ( ch1->getsectors(),ch2->getsectors() );
        }
        default:
            return true;
        }
    }
    return  false;



}

double ckLvItem::getstreamSize() {
    double size;
    k9DVDTitle *title;
    switch ( streamType ) {
    case SUB: {
        k9DVDSubtitle *sub= ( k9DVDSubtitle* ) stream;
        size=sub->getsize_mb();
        break;
    }
    case AUD: {
        k9DVDAudioStream *aud= ( k9DVDAudioStream* ) stream;
        size=aud->getsize_mb();
        break;
    }
    case VID: {
        title= ( k9DVDTitle* ) obj;
        size=title->gettotalvideosize_mb();
        break;
    }
    default:
        size=0;
        break;
    }
    return size;
}


bool LvItem::operator< ( const QTreeWidgetItem & other ) const {
    int col=treeWidget()->sortColumn();

    if ( other.type() ==1001 )
        return false;
    LvItem *litem = ( LvItem* ) &other;

    k9DVDTitle *title1,*title2;
    if ( col ==1 && objectType==TITLE ) {
        title1= ( k9DVDTitle* ) obj;
        title2= ( k9DVDTitle* ) litem->obj;
        return k9Main::compare ( title1->gettotalsize_mb(),title2->gettotalsize_mb() );
    }
    if ( col==0 && objectType==TITLE ) {
        title1= ( k9DVDTitle* ) obj;
        title2= ( k9DVDTitle* ) litem->obj;
        return k9Main::compare ( title1->getpgc(),title2->getpgc() );
    }

    return false;
}


void k9Main::listView1ItemChanged ( QTreeWidgetItem *_item,int _col ) {
    if ( !dvd->getopened() )
        return;
    if ( _item->type() ==1001 && _col==0 ) {
        ckLvItem *it= ( ckLvItem* ) _item;
        it->stateChange ( it->isOn() );
    }

    if ( ( _item->flags() & Qt::ItemIsEditable ) ==Qt::ItemIsEditable )
        itemRenamed ( _item,_col );
}


void ckLvItem::stateChange ( bool state ) {
    if ( m_checked ==state )
        return;
    m_checked=state;

    if ( mainDlg !=NULL ) {
        if ( mainDlg->getupdating() )
            return;
        switch ( objectType ) {
        case ROOT :
            mainDlg->checkAll ( state );
            break;
        case TITLESET:
            mainDlg->checkTS ( state,this );
            break;
        default :
            mainDlg->checkTitle ( state,this );
            break;
        }
        //        k9DVD *d = mainDlg->dvd;
        mainDlg->setDVDSize();
        mainDlg->updateFactor();
        //(mainDlg->factor)->setValue((int) (d->getfactor(mainDlg->withMenus(),true )*100)-100 );
    }
}


bool k9Main::getupdating() {
    return updating;
}


void k9Main::Copy() {

    k9ExecCopy execCopy;
    execCopy.setDvd ( dvd );
    QString path;
    execCopy.setCopyMenus ( withMenus() );
    execCopy.setSpeed ( Ui_MainDlg.cbBurnSpeed->currentText() );
    if ( m_useDvdAuthor || !withMenus() )
        m_playbackOptions->setSequence();

    if ( Ui_MainDlg.cbOutputDev->currentIndex() ==1 ) {
        execCopy.setOutput ( k9ExecCopy::oFolder );
        path= k9Dialogs::getExistingDirectory ( QDir::homePath() );
        if ( path=="" )
            return;
    } else if ( Ui_MainDlg.cbOutputDev->currentIndex() ==0 ) {
        path=k9Dialogs::getSaveFileName ( QDir::homePath(),"*.iso", 0,i18n ( "Save image to disk" ) );
        if ( path =="" )
            return;
        execCopy.setOutput ( k9ExecCopy::oISO );
    } else {
        k9CdDrive * drive= ( k9CdDrive* ) recorderList.at ( Ui_MainDlg.cbOutputDev->currentIndex()-2 );
        path=drive->device;
        execCopy.setOutput ( k9ExecCopy::oDVD );

    }
    execCopy.setPath ( path );

    execCopy.copyDVD();
    changeStatusbar ( i18n ( "Ready" ) ,sbMessage );

    /*
        QString c,filename;
        if (!dvd->getopened()) {
            k9Dialogs::error(  i18n("DVD is not opened"), i18n("DVD Copy"));
            return;
        }
        setDVDSize();
        updateSelection();

        QString outputDir=m_prefOutput;
        bool burn=false;

        if (Ui_MainDlg.cbOutputDev->currentIndex() ==0) {
            filename=k9Dialogs::getSaveFileName (QDir::homePath(),"*.iso", 0,i18n("Save image to disk"));
            if (filename =="")
                return;
        } else if (Ui_MainDlg.cbOutputDev->currentIndex()==1) {
            outputDir= k9Dialogs::getExistingDirectory(QDir::homePath());
            if (outputDir=="")
                return;
        }

        QDir dir(m_prefOutput);
        if (!dir.exists()) {
            dir.mkpath(m_prefOutput);
        }
        long fs=getFreeSpace( m_prefOutput);
        if ((fs <  m_prefSize) && (fs !=-1)) {
            if (k9Dialogs::warningContinueCancel ( i18n("Insufficient disk space on %1\n%2 mb expected.",m_prefOutput,m_prefSize),i18n("DVD Copy"))==KMessageBox::Cancel)
                return;
        }

        stopPreview();
        changeStatusbar( i18n("Backup in progress"),sbMessage);
        if (!m_useDvdAuthor || withMenus()) {
            //copy with k9DVDBackup
            //k9DVDBackup *backup = static_cast<k9DVDBackup  *>(m_factory->create(dvd,"backup", "k9DVDBackup"));
            m_playbackOptions->setSequence(); // JMP : temporaire

            k9DVDBackup *backup=new k9DVDBackup(dvd);

            backup->setOutput(outputDir);
            backup->setDevice(dvd->getDevice());
            backup->setWithMenus( withMenus());
            backup->execute();
            burn=backup->getErrMsg()=="";
            delete backup;
        } else {
            //k9DVDAuthor *b=static_cast<k9DVDAuthor  *>(m_factory->create(dvd,"dvdauthor", "k9DVDAuthor"));

            k9DVDAuthor *b=new k9DVDAuthor(dvd);
            m_playbackOptions->setSequence();
            b->setworkDir(outputDir);
            b->author();
            if (!b->getError())
                burn=true;


            delete b;
        }

        if (burn && Ui_MainDlg.cbOutputDev->currentIndex()!=1) {
            changeStatusbar(i18n("Burning DVD"),sbMessage);

            k9BurnDVD b;

            b.setworkDir(m_prefOutput+"/"+dvd->getDVDTitle());
            b.setUseK3b(m_prefK3b);
            b.setAutoBurn(m_prefAutoBurn);
            b.setvolId(dvd->getDVDTitle());
            b.setSpeed( Ui_MainDlg.cbBurnSpeed->currentText());
            if (Ui_MainDlg.cbOutputDev->currentIndex() >1) {
                k9CdDrive * drive=(k9CdDrive*)recorderList.at(Ui_MainDlg.cbOutputDev->currentIndex()-2);
                b.setburnDevice(drive->device);
                closeDVD();
                if (dvd->getDevice()== drive->device)
                    b.setAutoBurn(false);
            } else
                b.makeIso(filename);
            b.burn();
        }
        if (dvd->getopened())
            changeStatusbar(i18n("Ready"),sbMessage);
    */


}



void k9Main::eject() {
    closeDVD();
    drives->eject ( getDevice ( Ui_MainDlg.cbInputDev ) );
}



QString  k9Main::getDevice ( QComboBox *_combo ) {
    int index=-1;
    for ( int i=0; i<_combo->count();i++ ) {
        QString t =_combo->itemText ( i );
        if ( _combo->itemText ( i ) == _combo->currentText() )
            index=i;
    }
    QString res="";
    if ( ( index==-1 ) || ( _combo->currentText() ==i18n ( "ISO Image" ) ) ) {
        res=_combo->currentText();
        /*
            KUrl url=KUrl::fromPathOrUrl(res);
            //KIO::mount(true,0,res,"",true);
            KIO::UDSEntry entry;
            //first call to mount the device
            KIO::NetAccess::stat(KUrl::fromPathOrUrl(res+"/."),entry,0);
            if (KIO::NetAccess::stat(url,entry,0) )
            {
              //KIO::UDSEntry::iterator it;
              res=entry.stringValue( KIO::UDSEntry::UDS_LOCAL_PATH);
            }
        */
    } else {
        k9CdDrive * drive= ( k9CdDrive* ) driveList.at ( index );
        res=drive->device;
    }
    return res;
}

void k9Main::Open() {
    listView1->setSortingEnabled ( false );

    int i;
    k9DVDTitle * l_track;
    QString t;
    QTime h;

    listView1->disconnect ( SIGNAL ( itemChanged ( QTreeWidgetItem*,int ) ) );
    listView1->disconnect ( SIGNAL ( currentItemChanged ( QTreeWidgetItem * , QTreeWidgetItem * ) ) );
    disconnect ( m_langSelect->listView(),0,0,0 );


//  connect(listView1,SIGNAL(itemRenamed(QListViewItem*,int)),this,SLOT(itemRenamed(QListViewItem *,int)));

    closeDVD();
    listView1->clear();
    clearItems();
    tsItems.clear();
    chItems.clear();

    QString sDevice=getDevice ( Ui_MainDlg.cbInputDev );

    QString sVolName="";
    //if no dvd label, try to get it from hal
#ifdef HAVE_HAL_H
    foreach ( k9CdDrive *drive,driveList ) {

        if ( drive->getDevice() != NULL ) {
            if ( drive->getDevice()->mountPoint() ==sDevice ) {
                sVolName=drive->getDevice()->getVolumeName();
                sDevice=drive->device;
                break;
            }
        }
    }

#endif
    k9Config config;

    if ( sDevice.startsWith ( "/dev/" ) && config.getPrefReadAhead() !=-1 )
        k9CdDrive::setReadAhead ( sDevice,config.getPrefReadAhead() );

    dvd->scandvd ( sDevice,m_quickScan );
    if ( dvd->geterror() ) {
        k9Dialogs::error ( dvd->geterrMsg(), i18n ( "Open DVD" ) );
        return;
    }
    if ( dvd->getDVDTitle() ==i18n ( "unknown" ) && sVolName!="" ) {
        dvd->setDVDTitle ( sVolName );
    }

    root = new ckLvItem ( listView1,this,ROOT );
    root->setExpanded ( TRUE );

    root->setText ( 0, dvd->getDVDTitle() );
    root->setFlags ( root->flags() | Qt::ItemIsEditable );
    root->obj=NULL;
    root->streamType=NONE;
    root->setIcon ( 0,SmallIcon ( "media-optical" ) );

    for ( i=0;i<dvd->gettitlesetCount();i++ ) {
        ckLvItem *tsItem = new ckLvItem ( root,this,TITLESET );
        tsItem->setExpanded ( TRUE );
        QString c;
        c=i18n ( "Titleset %1",i+1 );
        tsItem->setText ( 0,c );
        QFont font=tsItem->font ( 1 );
        font.setWeight ( QFont::Bold );
        tsItem->setFont ( 1,font );

        tsItem->setText ( 1,"   "+dvd->gettitleset ( i )->getsize_mb() +" " +i18n ( "MB" ) );
        tsItem->setTextAlignment ( 1,Qt::AlignRight );
        tsItem->obj=dvd->gettitleset ( i ) ;
        tsItem->streamType=NONE;
        // tsItem->setRenameEnabled(0,false);
        tsItems.append ( tsItem );
        tsItem->setIcon ( 0,SmallIcon ( "folder-open" ) );
    }

    for ( i=0;i<dvd->gettitleCount();i++ ) {
        l_track=dvd->gettitle ( i );
        if ( ( l_track->getIndexed() ) )
            addTitle ( l_track );

        h=l_track->gettotallength();
    }

    m_playbackOptions->fillTitleList();
    m_langSelect->fillLvLanguages();
    listView1->setSortingEnabled ( true );
    changeStatusbar ( i18n ( "Ready" ),sbMessage );
    emit SelectionChanged ( dvd,withMenus() );
    this->setEnabled ( true );

    connect ( listView1,SIGNAL ( itemChanged ( QTreeWidgetItem*,int ) ),this,SLOT ( listView1ItemChanged ( QTreeWidgetItem*,int ) ) );
    connect ( listView1,SIGNAL ( currentItemChanged ( QTreeWidgetItem * , QTreeWidgetItem * ) ),this,SLOT ( listView1CurrentChanged ( QTreeWidgetItem *,QTreeWidgetItem * ) ) );

    resizeColumns();
}

void k9Main::resizeEvent ( QResizeEvent * ) {
    resizeColumns();
}

void k9Main::resizeColumns() {
    listView1->setColumnWidth ( 0,listView1->viewport()->width() );
    listView1->resizeColumnToContents ( 1 );
    listView1->resizeColumnToContents ( 2 );

    listView1->setColumnWidth ( 0,listView1->viewport()->width()-listView1->columnWidth ( 1 )-listView1->columnWidth ( 2 ) );

}

void k9Main::setDVDSize() {
    //k9DVDSize *dvdsize=static_cast<k9DVDSize  *>(m_factory->create(this,"dvd", "k9DVDSize"));
    k9DVDSize *dvdsize=new k9DVDSize ( this );
    dvdsize->setMaxSizeDyn ( m_prefSize );
    delete dvdsize;
}


k9Main::~k9Main() {
    clearItems();
    delete dvd;
}


void k9Main::addChapters ( QTreeWidgetItem *_parent,k9DVDTitle *_title ) {
    LvItem *chapter = new LvItem ( _parent,CHAPTER );
    chapter->setText ( 0, i18n ( "chapters" ) );
    chapter->setExpanded ( false );
    chapter->setIcon ( 0,pxChapter );

    int ch=0;
    for ( int i=0;i< _title->getchapterCount();i++ ) {
        ckLvItem *it =new ckLvItem ( chapter,this,CHAPTER );
        it->setText ( 0,i18n ( "chapter %1",++ch ) );
        QString s;

        s=QString ( "%1" ).arg ( ( double ) ( _title->getChapter ( i )->getsectors() ) /512,0,'f',2 );
        it->setText ( 1,i18n ( "%1 MB",s ) );
        it->setTextAlignment ( 1,Qt::AlignRight );
        it->streamType=CHAP;
        it->obj=_title->getChapter ( i );
        chItems.append ( it );
        it->mainTitle=_title;
    }
    for ( int j=0;j <_title->getTitles().count();j++ ) {
        k9DVDTitle *title2=_title->getTitles().at ( j );
        for ( int i=0;i< title2->getchapterCount();i++ ) {
            ckLvItem *it =new ckLvItem ( chapter,this,CHAPTER );
            it->setText ( 0,i18n ( "chapter %1",++ch ) );
            it->streamType=CHAP;
            it->obj=title2->getChapter ( i );
            QString s;
            s=QString ( "%1" ).arg ( ( double ) ( title2->getChapter ( i )->getsectors() ) /512,0,'f',2 );

            it->setText ( 1,i18n ( "%1 MB",s ) );
            it->setTextAlignment ( 1,Qt::AlignRight );
            chItems.append ( it );
            it->mainTitle=_title;
        }

    }

}
/** No descriptions */
void k9Main::addTitle ( k9DVDTitle *track ) {
    const int col1 =0;
    const int col2 =1;
    const int col3 =2;
    k9DVDAudioStream *l_auds;
    k9DVDSubtitle *l_sub;
    int i;
    QString c,ch;


    listView1->setRootIsDecorated ( true );

    LvItem * itemTrack = new LvItem ( tsItems.at ( track->getVTS()-1 ),TITLE );
    itemTrack->setExpanded ( false );
    itemTrack->setText ( col1,track->getname() );
    itemTrack->setFlags ( itemTrack->flags() | Qt::ItemIsEditable );
    itemTrack->setIcon ( col1,SmallIcon ( "title" ) );
    c.sprintf ( "%.2f ", track->gettotalsize_mb() );

    itemTrack->setText ( col2,c+i18n ( "MB" ) );
    itemTrack->setTextAlignment ( col2,Qt::AlignRight );
    itemTrack->obj=track;

    addChapters ( itemTrack,track );

    ckLvItem *video;
    video=new ckLvItem ( itemTrack,this,STREAM );
    video->streamType=VID;
    video->setIcon ( 0,SmallIcon ( "video" ) );
    addListItem ( track,video,VID );
    video->setExpanded ( false );
    c=i18n ( "video %1 ",track->getformat() );
    c.append ( " - " + track->gettotallength().toString ( "h:mm:ss" ) );
    video->setText ( col1, c );
    if ( track->gettotalvideosize_mb() ) {
        c.sprintf ( "%.2f ",  track->gettotalvideosize_mb() );
        video->setText ( col2,c +i18n ( "MB" ) );
        video->setTextAlignment ( col2,Qt::AlignRight );
    }
    video->obj=track;

    for ( i=0;i< track->getaudioStreamCount();i++ ) {
        l_auds=track->getaudioStream ( i );
        c=i18n ( "audio %1 ",i+1 );
        c.append ( l_auds->getlanguage() + " " +l_auds->getformat() +" " );
        ch.sprintf ( "%dch ",l_auds->getchannels() );
        c.append ( ch+l_auds->getfrequency() +" "+l_auds->getquantization() );
        ckLvItem * item = new ckLvItem ( itemTrack,this,STREAM );
        item->setIcon ( 0,SmallIcon ( "sound" ) );
        item->streamType=AUD;
        item->language=l_auds->getlanguage();
        addListItem ( l_auds,item,AUD );
        item->setText ( col1,  c );
        if ( l_auds->getsize_mb() ) {
            c=i18n ( "%1 MB",l_auds->getsize_mb() );
            item->setText ( col2,c );
            item->setTextAlignment ( col2,Qt::AlignRight );
        }
        item->setText ( col3,l_auds->getcontent() );

        item->obj=track;
        item->stream=l_auds;
    }
    for ( i=0;i< track->getsubPictureCount();i++ ) {
        l_sub=track->getsubtitle ( i );
        c=i18n ( "subpicture %1 ",i+1 );
        c.append ( l_sub->getlanguage() );
        ckLvItem * item = new ckLvItem ( itemTrack,this,STREAM );
        item->setIcon ( 0,SmallIcon ( "subtitle" ) );
        item->streamType=SUB;
        item->language=l_sub->getlanguage();
        addListItem ( l_sub,item,SUB );
        item->setText ( col1,  c );
        if ( l_sub->getsize_mb() ) {
            c=i18n ( "%1 MB",l_sub->getsize_mb() );
            item->setText ( col2,c );
            item->setTextAlignment ( col2,Qt::AlignRight );
        }
        item->setText ( col3, l_sub->getcontent() );

        item->obj=track;
        item->stream=l_sub;
    }
}


/** No descriptions */
void k9Main::updateSelection() {

    k9DVDListItem *litem;
    for ( int i=0;i<items.count();i++ ) {
        litem= ( k9DVDListItem* ) items.at ( i );

        switch ( litem->streamType ) {
        case SUB:
            k9DVDSubtitle *l_sub;
            l_sub=litem->subtitle;
            l_sub->setselected ( litem->listItem->isOn() );
            break;
        case AUD:
            k9DVDAudioStream *l_auds;
            l_auds=litem->audioStream;
            l_auds->setselected ( litem->listItem->isOn() );
            break;
        case VID :
            k9DVDTitle *l_title;
            l_title=litem->title;

            l_title->setvideoSelected ( litem->listItem->isOn() );
            //if title is not selected => shrink factor is not forced
            if ( !l_title->isSelected() )
                l_title->setforceFactor ( false );

            break;
        default :
            break;
        }
    }
    bool supdating=updating;
    updating=true;
    for ( int i=0;i<chItems.count();i++ ) {
        ckLvItem *it=chItems.at ( i );
        k9DVDChapter *c= ( k9DVDChapter* ) it->obj;
        it->setOn ( c->getSelected() );
    }
    updating=supdating;
}

void k9Main::checkLang ( QString lang,eStreamType streamType,bool state ) {
    updating =true;
    for ( int i=0;i<items.count();i++ ) {
        bool checked=false;
        k9DVDListItem *litem= ( k9DVDListItem* ) items.at ( i );
        if ( litem->streamType == streamType ) {
            switch ( litem->streamType ) {
            case SUB:
                k9DVDSubtitle *l_sub;
                l_sub=litem->subtitle;
                if ( l_sub->getlanguage() == lang ) {
                    l_sub->setselected ( state );
                    litem->listItem->setOn ( state );
                    checked=state;

                    k9DVDTitle *title= ( k9DVDTitle* ) litem->listItem->obj;
                    ckLvItem * itemtitleset= ( ckLvItem* ) litem -> listItem->parent()->parent();
                    itemtitleset->setOn ( title->gettitleset()->getselected() );
                }
                break;
            case AUD:
                k9DVDAudioStream *l_auds;
                l_auds=litem->audioStream;
                if ( l_auds->getlanguage() == lang ) {
                    l_auds->setselected ( state );
                    litem->listItem->setOn ( state );
                    checked=state;

                    k9DVDTitle *title= ( k9DVDTitle* ) litem->listItem->obj;
                    ckLvItem * itemtitleset= ( ckLvItem* ) litem -> listItem->parent()->parent();
                    itemtitleset->setOn ( title->gettitleset()->getselected() );
                }
                break;
            default:
                break;
            }
            //we must check the video item
            if ( checked ) {
                for ( int j=0; j<items.count();j++ ) {
                    k9DVDListItem *litem2= ( k9DVDListItem* ) items.at ( j );
                    if ( litem2->listItem->parent() ==litem->listItem->parent() && litem2->streamType==VID ) {
                        litem2->title->setvideoSelected ( state );
                        litem2->listItem->setOn ( state );
                    }
                }
            }
        }
    }
    m_playbackOptions->fillTitleList();
    updating=false;
    emit SelectionChanged ( dvd,withMenus() );

}

void k9Main::checkTitle ( bool state, ckLvItem *_item ) {
    m_update->wait();

    k9DVDListItem *litem;
    updating=true;

    k9DVDTitle *title;
    if ( _item->streamType==CHAP ) {
        k9DVDChapter *c= ( k9DVDChapter* ) _item->obj;
        c->setSelected ( state );
        //title=c->getTitle();
        title=_item->mainTitle;
        for ( int i=0;i<items.count() && state ;i++ ) {
            litem= ( k9DVDListItem* ) items.at ( i );
            if ( title==litem->title && litem->streamType==VID )
                litem->listItem->setOn ( state );

        }
    } else
        title= ( k9DVDTitle* ) _item->obj;


    for ( int i=0;i<items.count();i++ ) {
        litem= ( k9DVDListItem* ) items.at ( i );
        if ( litem->listItem->parent() == _item->parent() ) {
            //if current item is video and is unchecked, uncheck audio and subtitles
            if ( !state && _item->streamType==VID ) {
                switch ( litem->streamType ) {
                case SUB:
                    k9DVDSubtitle *l_sub;
                    l_sub=litem->subtitle;
                    litem->listItem->setOn (state);
                    l_sub->setselected ( state);
                    break;

                case AUD:
                    k9DVDAudioStream *l_auds;
                    l_auds=litem->audioStream;
                    litem->listItem->setOn ( state);
                    l_auds->setselected ( state);
                    break;
                default:
                    break;
                }
            } else if ( litem->streamType == VID && state && ( _item->streamType==SUB || _item->streamType==AUD ) ) {
                litem->title->setvideoSelected ( state );
                litem->listItem->setOn ( state );
            }
        }
    }


    updateSelection();

    k9DVDTitleset * titleset=NULL;

    titleset=title->gettitleset();

    m_langSelect->update();

    //check the titleset checkbox
    if ( titleset!=NULL ) {
        ckLvItem * itemtitleset;
        if ( _item->streamType==CHAP )
            itemtitleset= ( ckLvItem* ) _item->parent()->parent()->parent();
        else
            itemtitleset= ( ckLvItem* ) _item->parent()->parent();
        itemtitleset->setOn ( titleset->getselected() );
    }

    m_playbackOptions->fillTitleList();
    updating=false;
    emit SelectionChanged ( dvd,withMenus() );
}



void k9Main::checkAll ( bool state ) {
    k9DVDListItem *litem;
    updating=true;
    k9Config config;
    for ( int i=0;i<items.count();i++ ) {
        litem= ( k9DVDListItem* ) items.at ( i );
        switch ( litem->streamType ) {
        case SUB:
            if ( state )
                litem->listItem->setOn ( ( config.getPrefSubtitleLang().trimmed() =="" ) || ( litem->subtitle->getlangCod() ==config.getPrefSubtitleLang() ) );
            else
                litem->listItem->setOn ( state );
            break;
        case AUD:
            if ( state )
                litem->listItem->setOn ( ( config.getPrefAudioLang().trimmed() =="" ) || ( litem->audioStream->getlangCod() ==config.getPrefAudioLang() ) );
            else
                litem->listItem->setOn ( state );
            break;
        case VID: {
            k9DVDTitle * l_title;
            l_title=litem->title;
            //            l_title->setforceSelection(state);
            litem->listItem->setOn ( state );

            //            k9DVDTitle *title=(k9DVDTitle*)litem->listItem->obj;
            ckLvItem * itemtitleset= ( ckLvItem* ) litem -> listItem->parent()->parent();
            l_title->gettitleset()->setselected ( state );
            itemtitleset->setOn ( l_title->gettitleset()->getselected() );
        }
        break;
        default:
            break;
        }
    }

    //m_langSelect->selectAll(state);
    updateSelection();
    m_langSelect->update();

    m_playbackOptions->fillTitleList();
    updating=false;
    emit SelectionChanged ( dvd,withMenus() );

}

void k9Main::checkTS ( bool _state,ckLvItem *_item ) {
    k9DVDTitleset *titleset = ( k9DVDTitleset* ) _item->obj;
    titleset->setselected ( _state );
    k9DVDListItem *litem;
    k9Config config;
    updating=true;
    for ( int i=0;i<items.count();i++ ) {
        litem= ( k9DVDListItem* ) items.at ( i );
        if ( litem->listItem->parent ()->parent() == _item ) {
            switch ( litem->streamType ) {
            case SUB:
                if ( _state )
                    litem->listItem->setOn ( ( config.getPrefSubtitleLang().trimmed() =="" ) || ( litem->subtitle->getlangCod() ==config.getPrefSubtitleLang() ) );
                else
                    litem->listItem->setOn ( _state );
                break;
            case AUD:
                if ( _state )
                    litem->listItem->setOn ( ( config.getPrefAudioLang().trimmed() =="" ) || ( litem->audioStream->getlangCod() ==config.getPrefAudioLang() ) );
                else
                    litem->listItem->setOn ( _state );
                break;
            default :
                litem->listItem->setOn ( _state );
                break;
            }
        }
    }
    m_langSelect->update();

    updateSelection();

    m_playbackOptions->fillTitleList();
    updating=false;
    emit SelectionChanged ( dvd,withMenus() );
}

void k9Main::expanded ( QTreeWidgetItem *item ) {
    if ( item->type() ==1001 ) {
        ckLvItem *ckit = ( ckLvItem* ) item;
        if ( ckit->objectType==TITLESET )
            ckit->setIcon ( 0,SmallIcon ( "folder-open" ) );
    }
    //  listView1->resizeColumnToContents(0);
    resizeColumns();

}

void k9Main::collapsed ( QTreeWidgetItem *item ) {
    if ( item->type() ==1001 ) {
        ckLvItem *ckit = ( ckLvItem* ) item;
        if ( ckit->objectType==TITLESET )
            ckit->setIcon ( 0,SmallIcon ( "folder" ) );
    }
    resizeColumns();
}


/** No descriptions */
void k9Main::itemRenamed ( QTreeWidgetItem * item,int ) {
    k9DVDTitle *t=NULL;
    QString newText;
    if ( item->type() ==1000 ) {
        LvItem *it = ( LvItem* ) item;
        t= ( k9DVDTitle* ) it->obj;
        newText=it->text ( 0 );
    } else if ( item->type() ==1001 ) {
        ckLvItem *ckit = ( ckLvItem* ) item;
        t= ( k9DVDTitle* ) ckit->obj;
        newText=ckit->text ( 0 );
        if ( !ckit->renamed ( newText ) )
            return;
    }

    QString c;
    if ( t !=NULL ) {
        //QMessageBox::critical( this, "test", c.sprintf("%d",it->tag));
        t->setname ( newText );
        m_playbackOptions->titleRenamed ( t,newText );
    } else
        dvd->setDVDTitle ( item->text ( 0 ) );
}


/** No descriptions */
void k9Main::readSettings() {
    readDrives();
    k9Config config;
    config.read();

    m_prefOutput=config.getPrefOutput();
    Ui_MainDlg.cbInputDev->setCurrentIndex ( config.getInputDev() );
    Ui_MainDlg.cbOutputDev->setCurrentIndex ( config.getOutputDev() );
    m_prefK3b=config.getPrefK3b();

    m_prefAutoBurn=config.getPrefAutoBurn();
    m_quickScan=config.getQuickScan();
    m_prefSize=config.getPrefSize();
    //fill the burn speed combo
    //cbOutputDevActivated( cbOutputDev->currentItem());
    cbOutputDevActivated ( config.getOutputDev() );


    //m_useDvdAuthor=settings.readBoolEntry("/options/useDvdAuthor",true);
    m_useDvdAuthor=config.getUseDvdAuthor();
}
/** No descriptions */
void k9Main::saveSettings() {
    k9Config config;
    config.read();

    config.setInputDev ( Ui_MainDlg.cbInputDev->currentIndex() );
    config.setOutputDev ( Ui_MainDlg.cbOutputDev->currentIndex() );
    config.setKeepMenus ( withMenus() );
    config.save();
}
/** No descriptions */
void k9Main::bSaveClick() {
    saveSettings();
}

/** No descriptions */
void k9Main::PreviewTitle() {
    if ( listView1->currentItem() ==NULL )
        return;
    if ( listView1->currentItem()->type() ==0 )
        return;
    int rtti=listView1->currentItem()->type();
    void *obj;
    if ( rtti==1000 ) {
        LvItem *it= ( LvItem* ) listView1->currentItem();
        obj=it->obj;
    } else {
        ckLvItem *it= ( ckLvItem* ) listView1->currentItem();
        if ( it->objectType ==TITLESET )
            return;
        obj=it->obj;
    }

    if ( obj !=NULL ) {
        k9DVDTitle *t;
        ckLvItem *it= ( ckLvItem* ) listView1->currentItem();
        int chapter=1;
        if ( it->objectType==CHAPTER ) {
            k9DVDChapter *c= ( k9DVDChapter* ) obj;
            t=c->getTitle();
            chapter=c->getnum();
        } else
            t= ( k9DVDTitle* ) obj;
        //viewer->show();
        //viewer->open(dvd,t);


        emit showPreview ( dvd,t,chapter );
    }
}

void k9Main::CreateMP4() {
    /*  if (!dvd->getopened()) {
          k9Dialogs::error(  i18n("DVD is not opened"), i18n("MPEG-4 Encoding"));
          return;
      }
      QString filename="";
      int cpt=0;
      bool bStop=false;

      QDir dir(m_prefOutput);
      if (!dir.exists()) {
          dir.mkpath(m_prefOutput);
      }

      for (int i=0; i < dvd->gettitleCount();i++) {
          k9DVDTitle *t=dvd->gettitle(i);
          changeStatusbar( i18n("Transcoding title : %1",t->getname()) ,sbMessage);

          if (t->isSelected() && t->getIndexed() ) {
              QString name;
              if (filename=="")
                  filename=k9Dialogs::getSaveFileName (QDir::homePath(),"*.avi|Audio Video Interleave (*.avi)\n*.mpg|MPEG-1 and MPEG-2 systems (*.mpg)\n*.mp4|MPEG-4 format (*.mp4)\n*.asf|Advanced Streaming Format (*.asf)\n*.swf|Adobe Flash (*.swf)\n*.flv|Adobe Flash video files (*.flv)\n*.rm|RealVideo (*.rm)\n*.mov|QuickTime (*.mov)", 0,i18n("Save file to disk"));
              if (filename=="") {
                  bStop=true;
                  break;
              }

              k9MP4Enc *mp4=new k9MP4Enc();
              if (cpt >0) {
                  QString ext=filename.section(".",-1);
                  if (ext!="")
                      ext="."+ext;
                  QString path=filename.left(filename.length()-ext.length());
                  path=path+QString::number(cpt)+ext;
                  mp4->setFilename(path);
              } else
                  mp4->setFilename(filename);

              cpt++;
              k9TitleEncOpt * opt=t->getEncOpt();
              mp4->setDevice(dvd->getDevice());
              mp4->setAudioBitrate(opt->getAudioBr());
              mp4->setVideoBitrate(opt->getVideoBr());
              mp4->setCodec( opt->getCodec());
              mp4->setAudioCodec(opt->getAudioCodec());
              mp4->setSize(QString::number(opt->getMaxSize()));
              mp4->setAudioGain(QString::number(opt->getAudioGain()));
              mp4->setNumberCD(QString::number(opt->getNumParts()));
              mp4->setWidth(opt->getWidth() );
              mp4->setHeight(opt->getHeight());
              mp4->set2Passes( opt->get2Passes());
              mp4->setUseCache(opt->getUseCache());
              mp4->execute(t);
              bStop=mp4->isCanceled();
              delete mp4;
              if (bStop)
                  break;
          }
      }
      if (!bStop)
          k9Dialogs::information( i18n("Selected titles have been successfully encoded"), i18n("Encoding") );

    */
    k9ExecCopy execCopy;
    execCopy.setDvd ( dvd );
    execCopy.CreateMP4();
    changeStatusbar ( i18n ( "Ready" ) ,sbMessage );

    changeStatusbar ( i18n ( "Ready" ) ,sbMessage );


}


void k9Main::extractMPEG2() {
    /*
        if (!dvd->getopened()) {
            k9Dialogs::error(  i18n("DVD is not opened"), i18n("MPEG-4 Encoding"));
            return;
        }

        QString filename="";
        int cpt=0;
        bool bStop=false;

        QDir dir(m_prefOutput);
        if (!dir.exists()) {
            dir.mkpath(m_prefOutput);
        }

        for (int i=0; i < dvd->gettitleCount();i++) {
            k9DVDTitle *t=dvd->gettitle(i);
            changeStatusbar( i18n("Extracting title : %1",t->getname()) ,sbMessage);

            if (t->isSelected() && t->getIndexed() ) {
                QString name;
                if (filename=="")
                    filename=k9Dialogs::getSaveFileName (QDir::homePath(),"*.mpg|MPEG-1 and MPEG-2 systems (*.mpg)", 0,i18n("Save file to disk"));
                if (filename=="") {
                    bStop=true;
                    break;
                }

                k9MP4Enc *mp4=new k9MP4Enc();
                mp4->setMpeg2(true);
                if (cpt >0) {
                    QString ext=filename.section(".",-1);
                    if (ext!="")
                        ext="."+ext;
                    QString path=filename.left(filename.length()-ext.length());
                    path=path+QString::number(cpt)+ext;
                    mp4->setFilename(path);
                } else
                    mp4->setFilename(filename);

                cpt++;
                mp4->setDevice(dvd->getDevice());
                mp4->execute(t);
                bStop=mp4->isCanceled();
                delete mp4;
                if (bStop)
                    break;
            }
        }
        if (!bStop)
            k9Dialogs::information( i18n("Selected titles have been successfully extracted"), i18n("Encoding") );
    */

    k9ExecCopy execCopy;
    execCopy.setDvd ( dvd );
    execCopy.extractMPEG2();
    changeStatusbar ( i18n ( "Ready" ) ,sbMessage );


}


void k9Main::deviceAdded ( k9CdDrive *_drive ) {
    addDrive ( _drive );
}

void k9Main::deviceRemoved ( k9CdDrive *_drive ) {
    if ( _drive->device == dvd->getDevice() )
        closeDVD();

    int i=driveList.indexOf ( _drive );
    driveList.removeAt ( i );
    Ui_MainDlg.cbInputDev->removeItem ( i );

    i=recorderList.indexOf ( _drive );
    recorderList.removeAt ( i );
    Ui_MainDlg.cbOutputDev->removeItem ( i+2 );

}

void k9Main::addDrive ( k9CdDrive *drive ) {
#ifdef HAVE_HAL_H
    if ( drive->getDevice() !=NULL ) {
        k9HalDevice *dev=drive->getDevice();
        connect ( dev,SIGNAL ( volumeChanged ( const QString &,const QString & ) ),this,SLOT ( volumeChanged ( const QString&,const QString& ) ) );
    }
#else
    connect ( drive,SIGNAL ( volumeChanged ( const QString &,const QString & ) ),this,SLOT ( volumeChanged ( const QString&,const QString& ) ) );

#endif
    if ( drive->canReadDVD ) {
        QString c ( drive->name + "  ("+drive->device+")" );
        Ui_MainDlg.cbInputDev->addItem ( c );
        driveList.append ( drive );
    }
    if ( drive->canWriteDVD ) {
        Ui_MainDlg.cbOutputDev->addItem ( drive->name+ "  ("+drive->device+")" );
        recorderList.append ( drive );
    }

}

/*!
    \fn k9Main::readDrives()
 */
void k9Main::readDrives() {
    Ui_MainDlg.cbInputDev->clear();
    Ui_MainDlg.cbOutputDev->clear();
    driveList.clear();
    recorderList.clear();
    Ui_MainDlg.cbOutputDev->addItem ( i18n ( "ISO Image" ) );
    Ui_MainDlg.cbOutputDev->addItem ( i18n ( "Folder" ) );

    drives->scanDrives();

}


void k9Main::volumeChanged ( const QString &device,const QString &volumeName ) {
    if ( device==dvd->getDevice() && dvd->getopened() && volumeName=="" )
        closeDVD();
    else if ( !dvd->getopened() && volumeName !="" && getDevice ( Ui_MainDlg.cbInputDev ) ==device ) {
        Open();
    }
}

/*!
    \fn k9Main::listView1CurrentChanged( QListViewItem *newItem )
 */
void k9Main::listView1CurrentChanged ( QTreeWidgetItem *newItem,QTreeWidgetItem* ) {
    if ( newItem == NULL ) {
        m_playbackOptions->enable ( false );
        return;
    } else {
        if ( !withMenus() ) {
            m_playbackOptions->enable ( true );
        }
    }

    k9DVDTitle *title=NULL;

    if ( newItem->type() ==1000 ) {
        LvItem *it = ( LvItem* ) newItem;
        title= ( k9DVDTitle* ) it->obj;
    } else if ( newItem->type() ==1001 ) {
        ckLvItem *ckit = ( ckLvItem* ) newItem;
        if ( ckit->objectType!=TITLESET ) {
            if ( ( ( ckLvItem* ) newItem )->streamType==CHAP ) {
                LvItem *parent= ( LvItem* ) ( ckit->parent()->parent() );
                title= ( k9DVDTitle* ) parent->obj;
            } else
                title= ( k9DVDTitle* ) ckit->obj;
        }
    }
    if ( title !=NULL ) {
        emit changedTitle ( title );
        PreviewTitle();
    }

}


void k9Main::closeDVD() {
    //viewer->bStopClick();
    emit stopPreview();
    emit changedTitle ( NULL );
    emit SelectionChanged ( NULL,withMenus() );
    changeStatusbar ( "",sbFactor );
    changeStatusbar ( "",sbMessage );
    listView1->clear();
    clearItems();
    m_langSelect->clear();
    dvd->close();

}


bool k9Main::compare ( double v1,double v2 ) {
    if ( v1 >v2 )
        return true;
    if ( v1<v2 )
        return false;
    return true;
}


void k9Main::cbOutputDevActivated ( int _index ) {

    if ( _index<2 )
        return;

    k9CdDrive * drive= ( k9CdDrive* ) recorderList.at ( _index-2 );
    if ( drive !=NULL ) {
        QList <int>list=drive->getWriteSpeeds();
        Ui_MainDlg.cbBurnSpeed->clear();
        Ui_MainDlg.cbBurnSpeed->addItem ( i18n ( "default" ) );
        foreach ( int speed,list ) {
            Ui_MainDlg.cbBurnSpeed->addItem ( QString::number ( ( double ) ( speed ) /1385 ) );
        }
    }
}


void k9Main::bInputOpenClick() {
    QString result=k9Dialogs::getOpenFileName ( QDir::homePath(),"*.iso", 0,i18n ( "Open ISO Image" ) );
    if ( result!="" ) {
        k9Tools::setComboText ( Ui_MainDlg.cbInputDev,result );
        Open();
    }
}


void k9Main::bInputOpenDirClick() {
    QString result= k9Dialogs::getExistingDirectory ( QDir::homePath() );
//KDirSelectDialog::selectDirectory (QDir::homePath(), false, this,i18n("Open DVD folder")).path();
    if ( result!="" ) {
        k9Tools::setComboText ( Ui_MainDlg.cbInputDev,result );
        Open();
    }
}


long k9Main::getFreeSpace ( const QString & _path ) {
    long fs=k9Tools::getFreeSpace ( _path );
    if ( fs!=-1 ) {
        return fs;
    } else
        return -1;


}


void k9Main::setInput ( QString _input ) {
    bool found=false;
    for ( int i=0;i< driveList.count();i++ ) {
        k9CdDrive *drive= ( k9CdDrive* ) driveList.at ( i );
        if ( drive->device == _input ) {
            Ui_MainDlg.cbInputDev->setCurrentIndex ( i );
            found=true;
        }
    }
    if ( !found )
        k9Tools::setComboText ( Ui_MainDlg.cbInputDev,_input );
}

void k9Main::setOutput ( QString _output ) {
    Ui_MainDlg.cbOutputDev->setCurrentIndex ( 0 );
    for ( int i=0 ;i <recorderList.count();i++ ) {
        k9CdDrive * drive= ( k9CdDrive* ) recorderList.at ( i );
        QString c ( drive->device );
        //        qDebug ("output=" +c);
        if ( c==_output ) {
            Ui_MainDlg.cbOutputDev->setCurrentIndex ( i+2 );
            break;
        }
    }
}

void k9Main::Clone ( QString _input,QString _output ) {
    setInput ( _input );
    setOutput ( _output );
    m_playbackOptions->setwithMenus ( true );
    m_quickScan=true;
    Open();
    checkAll ( true );
    Copy();
}

void k9Main::updateFactor() {

// m_update->updateFactor();
    updateFactor_internal();
}

void k9Main::updateFactor_internal() {
    if ( dvd->getopened() && m_mutex.tryLock() ) {
        updateSelection();
        setDVDSize();
        double dbfactor=dvd->getfactor ( withMenus(),true,m_useDvdAuthor );

//    Ui_MainDlg.factor->setValue((int) ( dbfactor*100)-100 );

        if ( dvd->getsizeSelected ( FALSE ) ==0 )
            changeStatusbar ( "",sbFactor );
        else
            changeStatusbar ( QString::number ( dbfactor,'f',2 ),sbFactor );
        emit SelectionChanged ( dvd,withMenus() );
        m_mutex.unlock();
    }
}

bool k9Main::withMenus() {
    return m_playbackOptions->withMenus();
}


void k9Main::setDrives ( k9CdDrives* _value ) {
    drives = _value;
}
