#ifndef _PORTLISTBOX_H_
#define _PORTLISTBOX_H_

#include <qlistbox.h>
#include <alsa/asoundlib.h>

#define PORTLISTBOX_MAX_PORTS 32

class PortListBox : public QListBox {

    Q_OBJECT

    private: 
        snd_seq_t *seq;
        int readflag;
        int selected_port, selected_client;

    private:
        int check_permission(snd_seq_port_info_t *pinfo, int perm);
        void list_ports(int perm);

    public:
        PortListBox(QWidget *parent, snd_seq_t *pseq, int preadflag);
        int client(int index);
        int port(int index);  
                    
    public slots:
        void updateList(int n);
};

#endif
