#ifndef AMAROK_H
#define AMAROK_H

#include <dcopclient.h>
#include <qobject.h>

#include "chat.h"
#include "misc.h"

class AmaroK : public QObject
{
	Q_OBJECT

	public:
		AmaroK();
		~AmaroK();
		QString getArtist();
		QString nowPlaying();
		QString getAlbum();
		QString getTitle();
		int getLength();
		int getCurrentPos();
		Chat* getCurrentChat();
		QString parse(QString);
		bool isPlaying();
		bool isOn();

	private:
		QTimer* timer;
		QString amarokAppVer;
		QString currentTitle;
		QString descriptionToUse;
		QString descriptionToSet;
		QPopupMenu* menu;
		int popups[3];
		DCOPClient* client;
		QMap<Chat*,QPushButton*> chatButtons;
		ConfigFile* config;

	public slots:
		void putSongTitle(int);
		void checkTitle();
		void toggleTimer(int);
		void checkStatusDesc(UserStatus&, bool&);

	private slots:
		void amarokActionActivated(const UserGroup*, const QWidget*);
		void onCreateConfig();
		void onDestroyConfig();
		void onUpdateConfig();
};

#endif
