#ifndef __KADU_OSD_MANAGER_H
#define __KADU_OSD_MANAGER_H
#include <qptrlist.h>

#include "../notify/notify.h"

#include "osd_widget.h"

/**

	based on hints module

**/

class OSDManager : public Notifier
{
	Q_OBJECT
	
	public:
		OSDManager(QWidget *parent=0, const char *name=0);
		~OSDManager();
		
		void reload(void);
	
	public slots:
	
		void deleteAll(void);

/*********** sloty dla notify ************/
		/* nowa rozmowa */
		void newChat(Protocol *protocol, UserListElements senders, const QString &msg, time_t t);

		/* nowa wiadomo w oknie chat */
		void newMessage(Protocol *protocol, UserListElements senders, const QString &msg, time_t t, bool &grab);

		/* bd poczenia */
		void connectionError(Protocol *protocol, const QString &message);

		/* uytkownik zmieni status na "Dostpny" */
		void userChangedStatusToAvailable(const QString &protocolName, UserListElement);

		/* uytkownik zmieni status na "Zaraz wracam" */
		void userChangedStatusToBusy(const QString &protocolName, UserListElement);

		/* uytkownik zmieni status na "Niewidoczny" */
		void userChangedStatusToInvisible(const QString &protocolName, UserListElement);

		/* uytkownik zmieni status na "Niewidoczny" lub "Niedostpny" */
		void userChangedStatusToNotAvailable(const QString &protocolName, UserListElement);
		
		void userBoxChangeToolTip(const QPoint &point, UserListElement user, bool show);

		/* inna informacja do powiadomienia */
		/* jeeli parameters == NULL, to brane s domylne ustawienia dymkw typu message
		 * w przeciwnym razie z mapy brane s nastpujce wartoci:
		 *		"Pixmap"		- QPixmap
		 *		"Font"			- QFont
		 *		"Foreground color"	- QColor
		 *		"Background color"	- QColor
		 *		"Timeout"		- unsigned int	0 - cay czas, ale to raczej bez sensu ;)
		 * jeeli ktra z wartoci jest nieokrelona, to dla niej brana jest warto domylna
		 * gdy UserListElement != NULL, to jego uin brany jest do tworzenia dymka (LMB np otwiera okno rozmowy z danym uinem)
		*/
		void message(const QString &from, const QString &message, const QMap<QString, QVariant> *parameters, const UserListElement *ule);
		
		virtual void externalEvent(const QString &notifyType, const QString &msg, const UserListElements &ules);
/*********** koniec slotw dla notify *************/

	private:
		QPtrList<OSDWidget> widgets;
		OSDWidget *tipWidget;
		int height;
		unsigned int new_osd;
		unsigned int corner;
		unsigned int separator;
		double translucency_level;
		int def_x;
		int def_y;
		
		void addOSD(QString, const QFont, const QColor, const QColor, const QColor, const unsigned int, const int, const UserListElements);
		void addMessage(const UserListElements, const QString &, const QString);
		void addStatus(const UserListElements, const QString);
		
	private slots:
		void timeout(int id, bool chat);
		void windowActivationChanged(bool, const UserGroup *);
		void chatCreated(const UserGroup *);
};
#endif
