#ifndef KADU_DNS_HANDLER_H
#define KADU_DNS_HANDLER_H

#include <qdns.h>
#include <qhostaddress.h>
#include <qobject.h>
#include <qstring.h>

/**
	Tumaczy adres IP na nazw domeny (DNS). Kiedy proces zostanie zakoczony,
	emituje odpowiedni sygna zawierajcy informacj o nazwie domeny.
	\class DNSHandler
	\brief Klasa tumaczca adres IP na nazw domeny.
**/
class DNSHandler : public QObject
{
	Q_OBJECT

	public:
		/**
			\fn DNSHandler(const QString &marker, const QHostAddress &addr)
			Konstruktor wywoujcy zapytanie o domen dla danego adresu IP.
			\param marker znacznik (np. identyfikator protokou)
			\param addr adres IP
		**/
		DNSHandler(const QString &marker, const QHostAddress &addr);

		/**
			\fn ~DNSHandler()
			Destruktor klasy
		**/
		~DNSHandler();

		static int counter; /*!< licznik obiektw tej klasy */

	private:
		QDns DNSResolver; /*!< obiekt zajmujcy si translacj adresu na nazw domeny */
		QString marker; /*!< znacznik (np. identyfikator protokou) */

	private slots:
		/**
			\fn void resultsReady()
			Funkcja wywoywana, gdy proces tumaczenia zosta zakoczony.
		**/
		void resultsReady();

	signals:
		/**
			\fn void result(const QString &marker, const QString &hostname)
			Sygna emitowany, gdy proces tumaczenia zosta zakoczony.
			\param marker znacznik (np. identyfikator protokou)
			\param hostname nazwa domeny odpowiadajca adresowi IP o ktry pytano
		**/
		void result(const QString &marker, const QString &hostname);
};
#endif
