/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*
 * autor
 * Micha Podsiadlik
 * michal at gov.one.pl
 */

#include "message_box.h"
#include "debug.h"

#include <errno.h>

#include "pop3.h"

Pop3Proto::Pop3Proto(QString name, QString host, int port, QString user, QString password, SecureType type): QObject(), Name(name), Host(host), User(user), Password(password), Port(port), Encryption(type)
{
	kdebugf();
	mailserver = new SSocket();
	connect(mailserver, SIGNAL(error(int)), SLOT(connecterror(int)));
	connect(mailserver, SIGNAL(connected()), SLOT(connected()));
	connect(mailserver, SIGNAL(readyRead()), SLOT(parsemessage()));
}


Pop3Proto::~Pop3Proto()
{
	delete mailserver;	
}

void Pop3Proto::connecterror(int error)
{
	MessageBox::msg(tr("Cannot connect to mail server : %0 on account %1").arg(strerror(errno)).arg(Name), true, "Warning");
	kdebugm(KDEBUG_INFO, "cannot connect\n");
}

void Pop3Proto::connected()
{
	kdebugf();
}

void Pop3Proto::parsemessage()
{
	QString response=mailserver->readLine();

	if (response.isEmpty())
		return;

	QString send;
	QStringList arg=QStringList::split(" ", response);

	if (response.find("+OK")<0)
	{
		switch(state)
		{
			case Connecting:
				MessageBox::msg(tr("Cannot connect to mail server on account %1").arg(Name), true, "Warning");
				break;
			case LoginUser:
				MessageBox::msg(tr("Bad login to POP server on %0").arg(Name), true, "Warning");
				break;
			case LoginPassword:
				MessageBox::msg(tr("Bad password to POP server on %0").arg(Name), true, "Warning");
				break;
			case Stat:
				MessageBox::msg(tr("Cannot check mail"), true, "Warning");
				break;
			default:
				break;
		}
	}
	else 
	{
		switch (state)
		{
			case Connecting:
				send = QString("USER ") + User + QString("\r\n");
				writesocket(&send);
				state = LoginUser;
				mailserver->flush();
				break;
			case LoginUser:
				send = QString("PASS ") + Password + QString("\r\n");
				writesocket(&send);
				state = LoginPassword;
				mailserver->flush();
				break;
			case LoginPassword:
				writesocket(new QString("STAT\r\n"));
				state = Stat;
				mailserver->flush();
				break;
			case Stat:
				emit done(Lastmails, arg[1].toInt(), arg[2].toInt(), Name);
				Lastmails = arg[1].toInt();
				writesocket(new QString("QUIT\r\n"));
				state = Quit;
				break;
			case Quit:
				kdebugm(KDEBUG_INFO, "disconnected from server\n");
			default:
				mailserver->close();
				break;

		}		
	}
}

void Pop3Proto::writesocket(QString* str)
{
	mailserver->writeBlock(str->latin1(), str->length());
}

void Pop3Proto::getStats()
{
	kdebugm(KDEBUG_INFO, "Connecting to: " + host + ":%i\n", Port);
	state=Connecting;
	mailserver->connectToHost(Host, Port);
}

void Pop3Proto::setEncryption(SecureType type)
{
	Encryption=type;
	mailserver->setType(type);
}
