#ifndef MIME_TEX_H
#define MIME_TEX_H

#include <qobject.h>
#include <qstringlist.h>

class UserGroup;
class QWidget;
class Action;

namespace MimeTeX {
	//! This class provides "TeX formula" action
	class MimeTeX : public QObject
	{
		Q_OBJECT
		public:
			/*!
			 * \brief Default constructor
			 * \param *parent parent object
			 * \param *name object's name
			 */
			MimeTeX(QObject *parent = 0, const char *name = 0);

			//! Default destructor
			~MimeTeX();

			//! Default font size used by MimeTeX (see MimeTeX tab in config dialog for details).
			static int defaultFontSize();

		signals:
			//! This signal is emmited when the MimeTeX is deleted
			void deleting();

		public slots:
				/*!
				 * \brief Called each time, "TeX formula" actions button is being pressed
				 * \param *group interlocutors
				 * \param *actionButton "TeX formula" actions button
				 * \param activated ignored
				 */
				void TeXActionActivated(const UserGroup *group, const QWidget *actionButton, bool activated);

		private:
			//! temp files names to be deleted in the destructor
			QStringList tmpFiles;

			//! Action for a toolbar button
			Action *TeXAction;
	};
}

extern MimeTeX::MimeTeX *mimeTeX;

#endif

