/***************************************************************************
                           configwidget.cpp
                             -------------------
    begin                : Sam Mai 3 2003
    revision             : $Revision: 1.15 $
    last modified        : $Date: 2004/04/20 10:04:12 $ by $Author: juergenk $
    copyright            : (C) 2003-2004 by J. Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <kpushbutton.h>
#include <kfontdialog.h>
#include <kglobal.h>
#include <kiconloader.h>

#include <qlayout.h>
#include <qvbox.h>
#include <qlabel.h>
#include <qnamespace.h>

#include "configwidget.h"
#include "configwidget.moc"

ConfigWidget::ConfigWidget(bool genLoadPL, bool genSystemTray, bool genLoadMeta, int genScreensaver, QColor* altCol, QString *genMetaStr,
               QFont* infoFont, QColor* infoColor,bool osdUse, bool osdAnim,
               int osdAnimSpeed, QFont* osdFont, QColor* osdColor,
               int osdTime, int osdX, int osdY)
          : KDialogBase(KDialogBase::IconList, i18n("Kaffeine Setup"), KDialogBase::Ok|KDialogBase::Apply|KDialogBase::Cancel, KDialogBase::Cancel)
{               

  tmpOsdFont = *osdFont;
  tmpInfoFont = *infoFont;

  resize(350, 450);
  
/********* General PAGE ***********/

  QPixmap fontIcon = KGlobal::iconLoader()->loadIcon("fonts", KIcon::Small);

  QWidget* general = addPage(i18n("General"), i18n("General Options"),
           KGlobal::iconLoader()->loadIcon("configure", KIcon::Panel, KIcon::SizeMedium));
  QGridLayout* genGrid = new QGridLayout(general, 7, 2);
  genGrid->setSpacing(10);

  loadPlaylistCB = new QCheckBox(general);
  loadPlaylistCB->setText(i18n("Load last playlist at startup"));
  loadPlaylistCB->setChecked(genLoadPL);
  genGrid->addMultiCellWidget(loadPlaylistCB, 0,0, 0, 1);

  systemTrayCB = new QCheckBox(general);
  systemTrayCB->setText(i18n("Embed in system tray"));
  systemTrayCB->setChecked(genSystemTray);
  genGrid->addMultiCellWidget(systemTrayCB, 1, 1, 0, 1);

  loadMetaCB = new QCheckBox(general);
  loadMetaCB->setText(i18n("Read meta information and CDDB entries on loading"));
  loadMetaCB->setChecked(genLoadMeta);
  genGrid->addMultiCellWidget(loadMetaCB, 2, 2, 0, 1);

  genSSTimeout = new QSpinBox(general);
  genSSTimeout->setMinValue(0);
  genSSTimeout->setMaxValue(10);
  genSSTimeout->setSuffix(i18n(" min"));
  genSSTimeout->setValue(genScreensaver);
  genSSTimeout->setSpecialValueText(i18n("off"));
  genGrid->addWidget(genSSTimeout, 3,0);
  QLabel* genSSText = new QLabel(i18n("Interval to fake keypresses\n(prevent screensaver from activating)"), general);
  genGrid->addWidget(genSSText, 3,1);

  altColButton = new KColorButton( *altCol, general );
  genGrid->addWidget( altColButton, 4, 0 );
  QLabel* altColText = new QLabel(i18n("Alternate background color of playlist"), general);
  genGrid->addWidget( altColText, 4,1 );
 
  KPushButton* clearRecentPB = new KPushButton( i18n("Clear"), general );
  clearRecentPB->setSizePolicy( QSizePolicy (QSizePolicy::Minimum, QSizePolicy::Fixed) );
  connect( clearRecentPB, SIGNAL(clicked()), this, SIGNAL(signalClearRecent()) );
  genGrid->addWidget( clearRecentPB, 5, 0 );
  QLabel* genClearText = new QLabel(i18n("Clear recent files list"), general);
  genGrid->addWidget( genClearText, 5, 1 );

/** titleformat **/  
  QGroupBox* metaGroup = new QGroupBox( i18n("Titleformat"), general );
  genGrid->addMultiCellWidget( metaGroup, 6, 6, 0, 1 );
  QGridLayout* metaGrid = new QGridLayout(metaGroup, 2, 2);
  metaGrid->setSpacing(5);
  metaGrid->setMargin(15);
  
  meta = new KLineEdit(*genMetaStr, metaGroup);
  metaGrid->addWidget(meta, 0, 0);
  KPushButton* metaRefreshPB = new KPushButton( i18n("Refresh Titles"), metaGroup );
  metaGrid->addWidget( metaRefreshPB, 0, 1 );
  connect( metaRefreshPB, SIGNAL(clicked()), this, SLOT(slotRefreshTitles()));
  QLabel* metaDescr = new QLabel( "(artist, title, album, track)", metaGroup);
  metaGrid->addWidget(metaDescr, 1, 0 );
 
/*** inforow ***/
  QGroupBox* infoGroup = new QGroupBox(i18n("Info Row"), general);
  genGrid->addMultiCellWidget(infoGroup, 7, 7, 0, 1);
  QGridLayout* infoGrid = new QGridLayout(infoGroup, 2, 3);
  infoGrid->setSpacing(5);
  infoGrid->setMargin(15);

  infoFontFamily = new KLineEdit(QString("%1  (%2 p)").arg(infoFont->family()).arg(infoFont->pointSize()), infoGroup);
  infoFontFamily->setReadOnly(true);
  infoGrid->addWidget(infoFontFamily, 0, 1);
  QLabel* infoFontText = new QLabel(i18n("Font for info row"), infoGroup);
  infoGrid->addWidget(infoFontText, 0,2);
  KPushButton* infoChoose = new KPushButton(infoGroup);
  infoChoose->setPixmap(fontIcon);
  infoGrid->addWidget(infoChoose, 0,0);

  connect(infoChoose, SIGNAL(clicked()), this, SLOT(slotInfoFontChooser()));

  infoColButton = new KColorButton(*infoColor, infoGroup);
  infoGrid->addWidget(infoColButton, 1, 0);
  QLabel* infoColText = new QLabel(i18n("Color for info row font"), infoGroup);
  infoGrid->addMultiCellWidget(infoColText, 1, 1, 1, 2);
 

/***** OSD OPTIONS PAGE *******/

  QVBox* osd = addVBoxPage(i18n("OSD"), i18n("OSD Options"),
       KGlobal::iconLoader()->loadIcon("charset", KIcon::Panel, KIcon::SizeMedium));
  osd->setSpacing(10);

  useOsdCB = new QCheckBox(osd);
  useOsdCB->setText(i18n("Use OSD Titles"));
  useOsdCB->setChecked(osdUse);
 
  QGroupBox* osdGroup = new QGroupBox(i18n("OSD Options"), osd);
  QGridLayout* osdGrid = new QGridLayout(osdGroup, 7, 3);
  osdGrid->setSpacing(5);
  osdGrid->setMargin(20);
  osdGroup->setEnabled(osdUse);

  connect(useOsdCB, SIGNAL(toggled(bool)), osdGroup, SLOT(setEnabled(bool)));

  animateOsdCB = new QCheckBox(osdGroup);
  animateOsdCB->setText(i18n("Animate OSD Titles"));
  animateOsdCB->setChecked(osdAnim);
  osdGrid->addMultiCellWidget(animateOsdCB, 0,0, 0,2);

  animSpeed = new QSlider(Qt::Horizontal, osdGroup);
  animSpeed->setRange(5, 40);
  animSpeed->setValue(osdAnimSpeed);
  osdGrid->addMultiCellWidget(animSpeed, 1,1,0,1);
  QLabel* speedText = new QLabel(i18n("Animation speed"), osdGroup);
  osdGrid->addWidget(speedText, 1,2);
  animSpeed->setEnabled(osdAnim);

  connect(animateOsdCB, SIGNAL(toggled(bool)), animSpeed, SLOT(setEnabled(bool)));

  osdFontFamily = new KLineEdit(QString("%1  (%2 p)").arg(osdFont->family()).arg(osdFont->pointSize()), osdGroup);
  osdFontFamily->setReadOnly(true);
  osdGrid->addWidget(osdFontFamily, 2, 1);
  QLabel* osdFontText = new QLabel(i18n("Font for OSD titles"), osdGroup);
  osdGrid->addWidget(osdFontText, 2,2);
  KPushButton* osdChoose = new KPushButton(osdGroup);
  osdChoose->setPixmap(fontIcon);
  osdGrid->addWidget(osdChoose, 2,0);

  connect(osdChoose, SIGNAL(clicked()), this, SLOT(slotOsdFontChooser()));

  osdColButton = new KColorButton(*osdColor, osdGroup);
  osdGrid->addWidget(osdColButton, 3, 0);
  QLabel* osdColText = new QLabel(i18n("Color for OSD titles"), osdGroup);
  osdGrid->addMultiCellWidget(osdColText, 3, 3, 1,2);

  osdDisplayTime = new QSpinBox(osdGroup);
  osdDisplayTime->setMinValue(1);
  osdDisplayTime->setMaxValue(10);
  osdDisplayTime->setSuffix(i18n(" sec"));
  osdDisplayTime->setValue(osdTime);
  osdGrid->addWidget(osdDisplayTime, 4,0);
  QLabel* osdTimeText = new QLabel(i18n("OSD Display Time"), osdGroup);
  osdGrid->addMultiCellWidget(osdTimeText, 4,4, 1,2);

  osdPosX = new QSpinBox(osdGroup);
  osdPosX->setMinValue(0);
  osdPosX->setMaxValue(1600);
  osdPosX->setValue(osdX);
  osdGrid->addWidget(osdPosX, 5,0);
  QLabel* osdXText = new QLabel(i18n("X-Position of OSD title"), osdGroup);
  osdGrid->addMultiCellWidget(osdXText, 5,5, 1,2);
  
  osdPosY = new QSpinBox(osdGroup);
  osdPosY->setMinValue(0);
  osdPosY->setMaxValue(1200);
  osdPosY->setValue(osdY);
  osdGrid->addWidget(osdPosY, 6,0);
  QLabel* osdYText = new QLabel(i18n("Y-Position of OSD title"), osdGroup);
  osdGrid->addMultiCellWidget(osdYText, 6,6, 1,2);

  connect(this, SIGNAL(okClicked()), SLOT(slotOkPressed()));
  connect(this, SIGNAL(applyClicked()), SLOT(slotApplyPressed()));
}


ConfigWidget::~ConfigWidget(){}


void ConfigWidget::slotInfoFontChooser()
{
  if (KFontDialog::getFont(tmpInfoFont))
    infoFontFamily->setText(QString("%1  (%2 p)").arg(tmpInfoFont.family()).arg(tmpInfoFont.pointSize()));
}


void ConfigWidget::slotOsdFontChooser()
{
  if (KFontDialog::getFont(tmpOsdFont))
    osdFontFamily->setText(QString("%1  (%2 p)").arg(tmpOsdFont.family()).arg(tmpOsdFont.pointSize()));
}


void ConfigWidget::slotOkPressed()
{
  ApplyChanges();
  hide();
}


void ConfigWidget::slotApplyPressed()
{
  ApplyChanges();
}


void ConfigWidget::slotRefreshTitles()
{
  emit signalMSForPlaylist(meta->text());
  emit signalRefreshTitles();
}  


/***************** apply all changes ***************/

void ConfigWidget::ApplyChanges()
{
  emit signalNewGenConfig(loadPlaylistCB->isChecked(), systemTrayCB->isChecked() );

  QColor tmpCol = infoColButton->color();
  emit signalNewInfoRowConfig(&tmpInfoFont, &tmpCol);
  
  emit signalNewScreensaverTimeout( genSSTimeout->value() );

  emit signalNewAlternateColor( altColButton->color() );

  emit signalMSForPlaylist(meta->text());

  emit signalReadMetaOnLoading( loadMetaCB->isChecked() ); 

  tmpCol = osdColButton->color();

  emit signalNewOsdConfig(useOsdCB->isChecked(), animateOsdCB->isChecked(),
                     animSpeed->value(), &tmpOsdFont, &tmpCol,
                    osdDisplayTime->value(), osdPosX->value(), osdPosY->value()); 
}




