/***************************************************************************
                           configwidget.h 
                             -------------------
    begin                : Sam Mai 3 2003
    revision             : $Revision: 1.5 $
    last modified        : $Date: 2004/01/30 10:15:25 $ by $Author: juergenk $
    copyright            : (C) 2003-2004 by J. Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONFIGWIDGET_H
#define CONFIGWIDGET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kcolorbutton.h>
#include <kdialogbase.h>
#include <kpushbutton.h>
#include <klineedit.h>

#include <qwidget.h>
#include <qfont.h>
#include <qcolor.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qslider.h>
#include <qgroupbox.h>



class ConfigWidget : public KDialogBase  {
   Q_OBJECT
public: 
	ConfigWidget(bool genLoadPL, bool genSystemTray, bool genLoadMeta, int genScreensaver, QColor* altCol, QString *genMetaStr,
               QFont* infoFont, QColor* infoColor,bool osdUse, bool osdAnim,
               int osdAnimSpeed, QFont* osdFont, QColor* osdColor,
               int osdTime, int osdX, int osdY);
	~ConfigWidget();

signals:

/* send the new config back */
 void signalNewGenConfig(bool loadPlaylist, bool embedInSystemTray);
 void signalNewInfoRowConfig(QFont* infoFont, QColor* infoColor);
 void signalNewScreensaverTimeout( int ssTimeout );
 void signalNewOsdConfig(bool use, bool anim, int speed, QFont* f,
                    QColor* col, int time, int x, int y);
 void signalMSForPlaylist(const QString& mstr);
 void signalReadMetaOnLoading( bool read );
 void signalClearRecent();
 void signalRefreshTitles();
 void signalNewAlternateColor( const QColor& );
    
private slots:
  void slotInfoFontChooser();
  void slotOsdFontChooser();
  void slotOkPressed();
  void slotApplyPressed();
  void slotRefreshTitles();
  
private:
  void ApplyChanges();

  QFont tmpOsdFont;
  QFont tmpInfoFont;

  QCheckBox* loadPlaylistCB;
  QSpinBox* genSSTimeout;
  KLineEdit* meta;
  KColorButton* altColButton;
  KLineEdit* infoFontFamily;
  KColorButton* infoColButton;
  
  QCheckBox* useOsdCB;
  QCheckBox* animateOsdCB;
  QCheckBox* systemTrayCB;
  QCheckBox* loadMetaCB;
  QSlider* animSpeed;
  KLineEdit* osdFontFamily;
  KColorButton* osdColButton;
  QSpinBox* osdDisplayTime;
  QSpinBox* osdPosX;
  QSpinBox* osdPosY;
  
};

#endif
