/***************************************************************************
                          deinterlacequality.cpp  -
                          in this dialog the user can select the quality of deinterlacing
                             -------------------
    begin                : Mon Apr 19 2004
    revision             : $Revision: 1.4 $
    last modified        : $Date: 2004/04/24 09:38:44 $ by $Author: juergenk $
    copyright            : (C) 2004 by Juergen  Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlabel.h>
#include <qlayout.h>
#include <kdebug.h>
 
#include "deinterlacequality.h"
#include "deinterlacequality.moc"

DeinterlaceQuality::DeinterlaceQuality(QWidget *parent, const char *name )
:KDialogBase( parent, name, true, i18n("Deinterlace Quality"), KDialogBase::Close )
{
  configStrings << "tvtime:method=Greedy2Frame,enabled=1,pulldown=vektor,framerate_mode=full,judder_correction=1,use_progressive_frame_flag=1,chroma_filter=1,cheap_mode=0";
  configStrings << "tvtime:method=Greedy2Frame,enabled=1,pulldown=vektor,framerate_mode=full,judder_correction=0,use_progressive_frame_flag=1,chroma_filter=0,cheap_mode=0";
  configStrings << "tvtime:method=Greedy,enabled=1,pulldown=none,framerate_mode=half_top,judder_correction=0,use_progressive_frame_flag=1,chroma_filter=0,cheap_mode=0";
  configStrings << "tvtime:method=Greedy,enabled=1,pulldown=none,framerate_mode=half_top,judder_correction=0,use_progressive_frame_flag=1,chroma_filter=0,cheap_mode=1";
  configStrings << "tvtime:method=LinearBlend,enabled=1,pulldown=none,framerate_mode=half_top,judder_correction=0,use_progressive_frame_flag=1,chroma_filter=0,cheap_mode=1";
  configStrings << "tvtime:method=LineDoubler,enabled=1,pulldown=none,framerate_mode=half_top,judder_correction=0,use_progressive_frame_flag=1,chroma_filter=0,cheap_mode=1";
  
  setInitialSize( QSize(650,500), true );
  QWidget* mainWidget = makeMainWidget();
  QGridLayout* grid = new QGridLayout( mainWidget, 9, 2 );
  grid->setSpacing( 10 );

  qualitySlider = new QSlider( QSlider::Vertical, mainWidget );
  qualitySlider->setRange( 0, 5 );
  qualitySlider->setSteps( 1, 1 );
  qualitySlider->setTickmarks( QSlider::Right );
  grid->addMultiCellWidget( qualitySlider, 0, 5, 0, 0 );

  QLabel* level0Descr = new QLabel( i18n("<b>Very low cpu usage, worst quality.</b><br>Half of vertical resolution is lost. For some systems (with PCI video cards) this might decrease the cpu usage when compared to plain video playback (no deinterlacing)."), mainWidget );
  level0Descr->setAlignment( QLabel::WordBreak  );
  grid->addWidget( level0Descr, 5, 1 );
  QLabel* level1Descr = new QLabel( i18n("<b>Low cpu usage, poor quality.</b><br>Image is blurred vertically so interlacing effects are removed."), mainWidget );
  level1Descr->setAlignment( QLabel::WordBreak  );
  grid->addWidget( level1Descr, 4, 1 );
  QLabel* level2Descr = new QLabel( i18n("<b>Medium cpu usage, medium quality.</b><br>Image is analysed and areas showing interlacing artifacts are fixed (interpolated)."), mainWidget );
  level2Descr->setAlignment( QLabel::WordBreak | QLabel::AlignVCenter );
  grid->addWidget( level2Descr, 3, 1 );
  QLabel* level3Descr = new QLabel( i18n("<b>High cpu usage, good quality.</b><br>Conversion of dvd image format improves quality and fixes chroma upsampling bug."), mainWidget );
  level3Descr->setAlignment( QLabel::WordBreak | QLabel::AlignVCenter );
  grid->addWidget( level3Descr, 2, 1 );
  QLabel* level4Descr = new QLabel( i18n("<b>Very high cpu usage, great quality.</b><br>Besides using smart deinterlacing algorithms it will also double the frame rate (30->60fps) to match the field rate of TVs. Detects and reverts 3-2 pulldown. *"), mainWidget );
  level4Descr->setAlignment( QLabel::WordBreak | QLabel::AlignVCenter );
  grid->addWidget( level4Descr, 1, 1 );
  QLabel* level5Descr = new QLabel( i18n("<b>Very very high cpu usage, great quality with (experimental) improvements.</b><br>Enables judder correction (play films at their original 24 fps speed) and vertical color smoothing (fixes small color stripes seen in some dvds). *"), mainWidget );
  level5Descr->setAlignment( QLabel::WordBreak | QLabel::AlignVCenter );
  grid->addWidget( level5Descr, 0, 1 );

  customBox = new QCheckBox( i18n("User Defined..."), mainWidget );
  grid->addMultiCellWidget( customBox, 6, 6, 0, 1 );
  connect( customBox, SIGNAL(toggled(bool)), this, SLOT(slotCustomBoxToggled(bool)));

  customConfigButton = new KPushButton( i18n("Configure tvtime Deinterlace Plugin"), mainWidget );
  customConfigButton->setSizePolicy ( QSizePolicy (QSizePolicy::Minimum, QSizePolicy::Fixed) );
  grid->addWidget( customConfigButton, 7, 1 );
  connect( customConfigButton, SIGNAL(clicked()), this, SIGNAL(signalConfigureDeinterlacer()));

  QLabel* note = new QLabel( i18n("* <i>May require a patched 2.4 kernel (like RedHat one) or 2.6 kernel.</i>"), mainWidget );
  note->setAlignment( QLabel::WordBreak | QLabel::AlignVCenter );
  grid->addMultiCellWidget( note, 9, 9, 0, 1 );
}


DeinterlaceQuality::~DeinterlaceQuality()
{
  kdDebug(555) << "Deinterlace Quality Dialog destructed" << endl;
}


void DeinterlaceQuality::slotLevelChanged( int level )
{
  // kdDebug(555) << "Change to quality " << level << endl;
   emit signalSetDeinterlaceConfig( configStrings[level] );
}


void DeinterlaceQuality::slotCustomBoxToggled( bool on )
{
  if (on)
  {
    customConfigButton->setEnabled( true );
    qualitySlider->setEnabled( false );
  }
  else
  {
    customConfigButton->setEnabled( false );
    qualitySlider->setEnabled( true );
  }
}


void DeinterlaceQuality::SetQuality( uint qu )
{
  if (qu < 10)
  {
    qualitySlider->setValue( qu );
    customBox->setChecked( false );
    slotCustomBoxToggled( false );
  }
  else
  {
    qualitySlider->setValue( qu-10 );
    customBox->setChecked( true );
  }
  connect( qualitySlider, SIGNAL(valueChanged(int)), this, SLOT(slotLevelChanged(int)));
}     


uint DeinterlaceQuality::GetQuality() const
{
  if (customBox->isChecked())
    return qualitySlider->value()+10;
   else
    return qualitySlider->value();
}

    

  

