/***************************************************************************
                           filterdialog.cpp - config dialog for postprocessing filters
                             -------------------
    begin                : Mon Dez 8 2003
    revision             : $Revision: 1.7 $
    last modified        : $Date: 2004/04/21 11:37:25 $ by $Author: juergenk $
    copyright            : (C) 2003-2004 by Juergen  Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <kdebug.h>
#include <kpushbutton.h>

#include <qcheckbox.h>
#include <qlayout.h>
#include <qscrollview.h>
 
#include "filterdialog.h"
#include "filterdialog.moc"


FilterDialog::FilterDialog(const QStringList& filters, QWidget *parent, const char *name ) :
    KDialogBase( parent, name, true, i18n("Video Postprocessing Filters"), KDialogBase::Close )
{
  setInitialSize( QSize(500,500) );
  
  QWidget* mainWidget = makeMainWidget();
  QGridLayout* grid = new QGridLayout( mainWidget, 3, 3 );
  grid->setSpacing( 5 );

  QCheckBox* useFiltersCB = new QCheckBox( mainWidget );
  useFiltersCB->setText( i18n("Enable Video &Postprocessing") );
  useFiltersCB->setChecked( true );
  connect( useFiltersCB, SIGNAL(toggled(bool)), this, SLOT(slotUseFilters(bool)));

  grid->addMultiCellWidget( useFiltersCB, 0, 0, 0, 2 );
  
  filterCombo = new KComboBox( mainWidget );
  filterCombo->insertStringList( filters );

  addButton = new KPushButton( i18n("Add Filter"), mainWidget );
  connect( addButton, SIGNAL( clicked() ), this, SLOT( slotAddClicked() ));
  removeButton = new KPushButton( i18n("Remove All Filters"), mainWidget );
  connect( removeButton, SIGNAL( clicked() ), this, SIGNAL( signalRemoveAll() ));

  grid->addWidget( filterCombo, 1, 0 );
  grid->addWidget( removeButton, 1, 2 );
  grid->addWidget( addButton, 1, 1 );

  QScrollView* sv = new QScrollView( mainWidget );
  sv->setResizePolicy(QScrollView::AutoOneFit);
  filterPage = new QVBox(sv->viewport());
  filterPage->setMargin( 5 );
  sv->addChild(filterPage);

  grid->addMultiCellWidget( sv, 2, 2, 0, 2  );

}


FilterDialog::~FilterDialog()
{
  kdDebug(555) << "FilterDialog destructor" << endl;
}


void FilterDialog::slotUseFilters( bool on )
{
  filterCombo->setEnabled( on );
  removeButton->setEnabled( on );
  addButton->setEnabled( on );
  filterPage->setEnabled( on );
  emit signalUseFilters( on );
}





