/***************************************************************************
                           splashwidget.h - alpha masked OSD
                             -------------------
    begin                : Mit Apr 30 2003
    revision             : $Revision: 1.3 $
    last modified        : $Date: 2004/01/11 12:37:21 $ by $Author: juergenk $
    copyright            : (C) 2003-2004 by J. Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SPLASHWIDGET_H
#define SPLASHWIDGET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include <qfont.h>
#include <qcolor.h>
#include <qbitmap.h>
#include <qtimer.h>


/*************************************************************
              splash the osd titles
****************************************************************/      


class SplashWidget : public QWidget
{
   Q_OBJECT
public: 
	SplashWidget(QWidget *parent=0, const char *name=0);
	~SplashWidget();

  void GetConfig(bool& use, bool& anim, int& speed, QFont& f,
                 QColor& col, int& time, int& x, int& y) const;

public slots:
  void slotSetConfig(bool use, bool anim, int speed, QFont* f,
                    QColor* col, int time, int x, int y);
                    
 /* text to be shown */
  void slotOsdShow(const QString&);

private slots:
  void slotFadeIn();
  void slotFadeOut();
  void slotWait();  
                    
private:
  bool useMe;
  bool animate;
  QFont font;
  QColor color;
  int displayTime;
  int posx, posy;
  int animSpeed;

  int animPos;
  int width, height;
  QBitmap mask;
  QPixmap playIcon;

  QTimer fadeInTimer;
  QTimer fadeOutTimer;
  QTimer waitTimer;

};

#endif
