/***************************************************************************
                           systemtray.h 
                             -------------------
    begin                : Son Okt 26 2003
    revision             : $Revision: 1.3 $
    last modified        : $Date: 2004/01/11 12:38:10 $ by $Author: juergenk $
    copyright            : (C) 2003-2004 by Juergen  Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SYSTEMTRAY_H
#define SYSTEMTRAY_H



#include <ksystemtray.h>
#include <kaction.h>
#include <kurl.h>


#include <qwidget.h>

/**
  *@author Juergen  Kofler
  */

class SystemTray : public KSystemTray  {
   Q_OBJECT
public: 
	SystemTray(QWidget *parent=0, const char *name=0);
	~SystemTray();

  void SetPlaying(const QString& title);
  void SetRecording();
  
 protected:
   virtual void dropEvent(QDropEvent*);
   virtual void dragEnterEvent(QDragEnterEvent*);
   virtual void dragLeaveEvent(QDragLeaveEvent*);

 signals:
   void signalPlayPause();
   void signalNext();
   void signalPrev();
   void signalStop();
   void signalShowPlaylist();
   void signalShowEqualizer();
   void signalShowVideosettings();
   void signalPlayFiles(const KURL::List&);
   void signalSaveStreamAs();

 public slots:
   void slotNormalIcon();
   void slotPlayIcon();
   void slotPauseIcon();
   void slotRecordIcon();

 private slots:
   void slotOpenFiles();

 private:
  KAction* actionPlayPause;
  KAction* actionNext;
  KAction* actionPrevious;
  KAction* actionStop;
  KAction* actionShowPlaylist;
  KAction* actionOpenFile;
  KAction* actionSaveStreamAs;
  KAction* actionEqualizer;
  KAction* actionVideosettings;

  QColor background;
  
};

#endif
