/***************************************************************************
    begin                : Mon Oct 29 2001
    copyright            : (C) 2001 by Mantia Andras
    email                : amantia@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KALLERYFUNCTIONS_H
#define KALLERYFUNCTIONS_H

#include "kallery_def.h"

#include <qobject.h>

/*Forward declaration of QT classes. The include files are specified in the .cpp file */
class QString;
class QStringList;
class QListBox;
class QLineEdit;
class QLabel;
class QToolButton;
class QProgressDialog;
struct _Image;

/**
 * @short 
 * This provides the needed functionality to convert the images, create the html files.
 * It also contains helper methods used by the other classes.
 * @author Mantia Andras <amantia@kdewebdev.org>
 */
class KalleryFunctions : public QObject
{
  Q_OBJECT
  public:
  /**
   *  since this class is a singleton you must use this function to access it
   *  @return the class pointer
   */
  static KalleryFunctions* ref(QWidget* widget = 0L)
  {
    static KalleryFunctions *m_ref;
    if (!m_ref) m_ref = new KalleryFunctions(widget);
    return m_ref;
  }
    virtual ~KalleryFunctions();
    /** Move an item - the current one - up or down with delta position in a QStringList
     * and the corresponding listbox.
     * @param listBox the listbox object
     * @param itemList the list of items
     * @param descList the list with descriptions of the items. Can be NULL.
     * @param delta the movement difference
     * @param special  if special == -1, the item will be the first item,
                       if special == 1, the item will became the last item.
     */
    void moveInListAndBox(QListBox *listBox, QStringList &itemList, QValueList<OptionType::Description> *descList,
                             int delta, int special);
    
    /** Common method to delete the current item from a QStringList and
     *  also delete the item from the visual list box. If descList is not
     *  NULL, delete the description from that list.
     * 
     * @param listBox the listbox object
     * @param itemList the list of items
     * @param label a label to display the number of items in the list.
     * @param descList the list with descriptions of the items. Can be NULL.
     */
    void deleteFromList(QListBox *listBox, QStringList &itemList, QLabel *label,  QValueList<OptionType::Description> *descList);
    
    /** Returns in the dir parameter the relative path of dir based on baseDir. 
     * @param baseDir the base directory
     * @param dir the directory to transform. Will hold the transformation result as well.
     * @return true in case of success, false otherwise
    */
    bool makeRelativePath(const QString &baseDir, QString &dir);
    /** Convert the dir to an absolute path, if it was a relative path based on baseDir. 
     * @param baseDir the base directory
     * @param dir the directory to transform. Will hold the transformation result as well.
     * @return true in case of success, false otherwise
     */
    bool makeAbsolutePath(const QString & baseDir, QString &dir);
    
    /** 
     * Saves the project in a file. 
     * @param projectFileName points to the project file
     * @return true in case of success, false in case of failure
    */
    bool saveProject(const QString& projectFileName);
    
    /** 
     * Load the project from a file. 
     * @param projectFileName points to the project file
     * @return true in case of success, false in case of failure
     */
    bool openProject(const QString& projectFileName);
    
    /** Converts, copies each image and creates the thumbnails if it was requested.
     *  This is the one place where we use the ImageMagick (the other is when we
     *  get the supported file list).
     *  @param progress pointer to the progress dialog
     */
    bool convertImages(QProgressDialog* progress);
    
    /** Create the gallery html and the htmls for the images, if needed. 
     *  @param progress pointer to the progress dialog
     */
    void createHtmls(QProgressDialog *progress);
    
    /** Read the descriptions from a file into the descList. 
     * @param fileName the file containing the descriptions
     * @param descList put the descriptions in this list
     * @return true in case of success, false otherwise
    */
    bool readDescriptions(const QString& fileName, QValueList<OptionType::Description>& descList);
    
    /** Write the descriptions from descList into the file. 
     * @param fileName the target file
     * @param descList the descriptions
     * @return true in case of success, false otherwise
     */
    bool writeDescriptions(const QString& fileName, QValueList<OptionType::Description>& descList);
    
  private: // Private methods
    KalleryFunctions(QWidget* widget);

    /** Creates a html file with the image and the navigation buttons. 
     * @param imageIndex the index of the image in the list
     * @param htmlName the name of the html file to be created
     * @param language the language used for descriptions
    */
    void createHtmlForImage(uint imageIndex, const QString &htmlName, const QString& language);
        
    /** Insert the content of sourceName file into the destStream text stream (another file). 
     * @param sourceName the file containing the text to insert 
     * @param destStream a text stream where to append the text
    */
    void insertFile(QString& sourceName, QTextStream & destStream);
    
    /**
     * Convert the encoding names from KDE format to HTML format.
     * @param encoding the KDE format
     * @return the format accepted in HTML files
     */
    QString convertEncodingName(const QString &encoding);
    /**
     * Reads the image informations for a file and put the result into the
     * description list.
     * @param source pointer to the image
     * @param fileName the name (with path) to the file
     * @return the read information
     */
    OptionType::Description readImageInfo(_Image *source, const QString& fileName);
    private: // Private attributes
    QWidget* mainWidget;    ///< The main widget of the application, used to display the message boxes

    bool cancelPressed;     ///< True if the user pressed cancel during the generation. 
  public slots: // Public slots
    /** Called when the user presses the Cancel button. */
    void slotProgressCancelled();
};

#endif
