/***************************************************************************
    copyright            : (C) 2001, 2006 by Mantia Andras
    email                : amantia@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TARGETPATH_H
#define TARGETPATH_H

#include "ktargetpath.h"
#include "wizardpagebase.h"

/**
 * @short
 * Target path page.
 * 
 * @author Andras Mantia <amantia@kdewebdev.org>
 */
class TargetPath: public KTargetPathPage, public WizardPageBase  {
Q_OBJECT
public:
  TargetPath(QWidget *parent = 0, const char *name = 0);
  void invokeHelp();
  bool processPage();
  void setupPage();

private slots:
  /**
   * Select a folder for the thumbnails.
   */
  void slotSelectThumbDir();
  /**
   * Select a folder for the images.
   */
  void slotSelectImageDir();
  /**
   * Select the place of the main gallery file.
   */
  void slotSelectGalleryFile();

private:
  /** 
   * Checks for a directory and creates if necessary. 
   * @param dirName the name of the directory (folder)
  */
  bool checkAndCreateDir(const QString& dirName );
  /** 
   * Common method to display a directory selection dialog. 
   * @param caption the caption of the dialog
   * @param dirTextLine points to the lineedit object where the result string will be put
   * @param dirName acts as starting directory in the dialog and will hold the result after the selection was made
  */
  void selectDir(const QString &caption, QLineEdit *dirTextLine, QString &dirName);
};

#endif
