/*
 * This file was generated automatically by ExtUtils::ParseXS version 2.18_02 from the
 * contents of openserxs.xs. Do not edit this file, edit openserxs.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST! 
 *
 */

#line 1 "openserxs.xs"
/*
 * $Id$
 *
 * Perl module for OpenSER
 *
 * Copyright (C) 2006 Collax GmbH
 *                    (Bastian Friedrich <bastian.friedrich@collax.com>)
 *
 * This file is part of openser, a free SIP server.
 *
 * openser is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * openser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <EXTERN.h>
#include <perl.h>
#include <XSUB.h>
#include <unistd.h>
#undef load_module

/* perl.h defines union semun */
#ifdef USE_SYSV_SEM
# undef _SEM_SEMUN_UNDEFINED
#endif

#include "../../sr_module.h"
#include "../../parser/msg_parser.h"
#include "../../parser/parse_uri.h"
#include "../../usr_avp.h"
#include "../../action.h"
#include "../../flags.h"
#include "../../pvar.h"
#include "../../dset.h"
#include "../../mem/mem.h"
#include "../../route_struct.h"
#include "../../qvalue.h"
#include "../../dprint.h"

extern int unsafemodfnc;

enum xs_uri_members {
	XS_URI_USER = 0,
	XS_URI_PASSWD,
	XS_URI_HOST,
	XS_URI_PORT,
	XS_URI_PARAMS,
	XS_URI_HEADERS,
	XS_URI_TRANSPORT,
	XS_URI_TTL,
	XS_URI_USER_PARAM,
	XS_URI_MADDR,
	XS_URI_METHOD,
	XS_URI_LR,
	XS_URI_R2,
	XS_URI_TRANSPORT_VAL,
	XS_URI_TTL_VAL,
	XS_URI_USER_PARAM_VAL,
	XS_URI_MADDR_VAL,
	XS_URI_METHOD_VAL,
	XS_URI_LR_VAL,
	XS_URI_R2_VAL
	
	/* These members are no strings:
		unsigned short port_no;
	unsigned short proto; / * from transport * /
	uri_type type; / * uri scheme */
};

/*
 * Return the sip_msg struct referred to by perl reference sv
 */
struct sip_msg * sv2msg(SV *sv) {
	struct sip_msg* m;
	if (SvROK(sv)) {
		sv = SvRV(sv);
		if (SvIOK(sv)) {
			m = INT2PTR(struct sip_msg*, SvIV(sv));
			return m;
		}
	}
	return NULL; /* In case of error above... */
}

struct sip_uri * sv2uri(SV *sv) {
	struct sip_uri* u;
	if (SvROK(sv)) {
		sv = SvRV(sv);
		if (SvIOK(sv)) {
			u = INT2PTR(struct sip_uri*, SvIV(sv));
			return u;
		}
	}
	return NULL; /* In case of error above... */
}

struct action * sv2action(SV *sv) {
	struct action* a;
	if (SvROK(sv)) {
		sv = SvRV(sv);
		if (SvIOK(sv)) {
			a = INT2PTR(struct action*, SvIV(sv));
			return a;
		}
	}
	return NULL; /* In case of error above... */
}

/*
 * We have a private function for two reasons:
 * a) Return SIP_INVALID even if type was sth different
 * b) easy access
 */

inline static int getType(struct sip_msg *msg) {
	int t = SIP_INVALID;

	if (!msg) return SIP_INVALID;

	switch ((msg->first_line).type) {
		case SIP_REQUEST:	t = SIP_REQUEST; break;
		case SIP_REPLY:		t = SIP_REPLY; break;
	}
	return t;
}
		

SV *getStringFromURI(SV *self, enum xs_uri_members what) {
	struct sip_uri *myuri = sv2uri(self);
	str *ret = NULL;

	if (!myuri) {
		LM_ERR("Invalid URI reference\n");
		ret = NULL;
	} else {
		
		switch (what) {
			case XS_URI_USER:	ret = &(myuri->user);
						break;
			case XS_URI_HOST:	ret = &(myuri->host);
						break;
			case XS_URI_PASSWD:	ret = &(myuri->passwd);
						break;
			case XS_URI_PORT:	ret = &(myuri->port);
						break;
			case XS_URI_PARAMS:	ret = &(myuri->params);
						break;
			case XS_URI_HEADERS:	ret = &(myuri->headers);
						break;
			case XS_URI_TRANSPORT:	ret = &(myuri->transport);
						break;
			case XS_URI_TTL:		ret = &(myuri->ttl);
						break;
			case XS_URI_USER_PARAM:	ret = &(myuri->user_param);
						break;
			case XS_URI_MADDR:	ret = &(myuri->maddr);
						break;
			case XS_URI_METHOD:	ret = &(myuri->method);
						break;
			case XS_URI_LR:		ret = &(myuri->lr);
						break;
			case XS_URI_R2:		ret = &(myuri->r2);
						break;
			case XS_URI_TRANSPORT_VAL:	ret = &(myuri->transport_val);
						break;
			case XS_URI_TTL_VAL:	ret = &(myuri->ttl_val);
						break;
			case XS_URI_USER_PARAM_VAL:	ret = &(myuri->user_param_val);
						break;
			case XS_URI_MADDR_VAL:	ret = &(myuri->maddr_val);
						break;
			case XS_URI_METHOD_VAL:	ret = &(myuri->method_val);
						break;
			case XS_URI_LR_VAL:	ret = &(myuri->lr_val);
						break;
			case XS_URI_R2_VAL:	ret = &(myuri->r2_val);
						break;

			default:	LM_INFO("Unknown URI element"
						" requested: %d\n", what);
					break;
		}
	}

	if ((ret) && (ret->len)) {
		return sv_2mortal(newSVpv(ret->s, ret->len));
	} else {
		return &PL_sv_undef;
	}
}



/*
 * Calls an exported function. Parameters are copied and fixup'd.
 *
 * Return codes:
 *   -1 - Function not available (or other error).
 *    1 - Function was called. Its return value is returned via the retval
 *        parameter.
 */

int moduleFunc(struct sip_msg *m, char *func,
	       char *param1, char *param2,
	       int *retval) {

	sr31_cmd_export_t* exp_func_struct;
	struct action *act;
	unsigned mod_ver;
	char *argv[2];
	int argc = 0;
	struct run_act_ctx ra_ctx;

	if (!func) {
		LM_ERR("moduleFunc called with null function name. Error.");
		return -1;
	}

	if ((!param1) && param2) {
		LM_ERR("moduleFunc called with parameter 1 UNSET and"
			   " parameter 2 SET. Error.");
		return -1;
	}


	if (param1) {
		argv[0] = (char *)pkg_malloc(strlen(param1)+1);
		strcpy(argv[0], param1);
		argc++;
	} else {
		argv[0] = NULL;
	}

	if (param2) {
		argv[1] = (char *)pkg_malloc(strlen(param2)+1);
		strcpy(argv[1], param2);
		argc++;
	} else {
		argv[1] = NULL;
	}

	exp_func_struct = find_export_record(func, argc, 0, &mod_ver);
	if (!exp_func_struct || mod_ver < 1) {
		LM_ERR("function '%s' called, but not available.", func);
		*retval = -1;
		if (argv[0]) pkg_free(argv[0]);
		if (argv[1]) pkg_free(argv[1]);
		return -1;
	}

	act = mk_action(MODULE2_T, 4 /* number of (type, value) pairs */,
					MODEXP_ST, exp_func_struct, /* function */
					NUMBER_ST, 2,  /* parameter number */
					STRING_ST, argv[0], /* param. 1 */
					STRING_ST, argv[1]  /* param. 2 */
			);


	if (!act) {
		LM_ERR("action structure could not be created. Error.");
		if (argv[0]) pkg_free(argv[0]);
		if (argv[1]) pkg_free(argv[1]);
		return -1;
	}


	if (exp_func_struct->fixup) {
		if (!unsafemodfnc) {
			LM_ERR("Module function '%s' is unsafe. Call is refused.\n", func);
			if (argv[0]) pkg_free(argv[0]);
			if (argv[1]) pkg_free(argv[1]);
			*retval = -1;
			return -1;
		}

		if (argc>=2) {
			*retval = exp_func_struct->fixup(&(act->val[3].u.data), 2);
			if (*retval < 0) {
				LM_ERR("Error in fixup (2)\n");
				return -1;
			}
			act->val[3].type = MODFIXUP_ST;
		}
		if (argc>=1) {
			*retval = exp_func_struct->fixup(&(act->val[2].u.data), 1);
			if (*retval < 0) {
				LM_ERR("Error in fixup (1)\n");
				return -1;
			}
			act->val[2].type = MODFIXUP_ST;
		}
		if (argc==0) {
			*retval = exp_func_struct->fixup(0, 0);
			if (*retval < 0) {
				LM_ERR("Error in fixup (0)\n");
				return -1;
			}
		}
	}

	init_run_actions_ctx(&ra_ctx);
	*retval = do_action(&ra_ctx, act, m);

	if ((act->val[3].type == MODFIXUP_ST) && (act->val[3].u.data)) {
		/* pkg_free(act->elem[3].u.data); */
		LM_WARN("moduleFunction: A fixup function was called. "
				"This currently creates a memory leak.\n");
	}

	if ((act->val[2].type == MODFIXUP_ST) && (act->val[2].u.data)) {
		/* pkg_free(act->elem[2].u.data); */
		LM_WARN("moduleFunction: A fixup function was called. "
				"This currently creates a memory leak.\n");
	}

	if (argv[0]) pkg_free(argv[0]);
	if (argv[1]) pkg_free(argv[1]);

	pkg_free(act);
	
	return 1;
}


/**
 * Rewrite Request-URI
 */
static inline int rewrite_ruri(struct sip_msg* _m, char* _s)
{
	struct action act;
	struct run_act_ctx ra_ctx;

	act.type = SET_URI_T;
	act.val[0].type = STRING_ST;
	act.val[0].u.string = _s;
	act.next = 0;

	init_run_actions_ctx(&ra_ctx);	
	if (do_action(&ra_ctx, &act, _m) < 0)
	{
		LM_ERR("rewrite_ruri: Error in do_action\n");
		return -1;
	}
	return 0;
}


/**
 * Compile a string with pseudo variables substituted by their values.
 * A string buffer is allocated. Deallocate afterwards!
 */
char *pv_sprintf(struct sip_msg *m, char *fmt) {
	int buf_size = 4096;
	pv_elem_t *model;
	str s;
	char *out = (char *)pkg_malloc(buf_size);
	char *ret = NULL;

	if (!out) {
		LM_ERR("pv_sprintf: Memory exhausted!\n");
		return NULL;
	}

	s.s = fmt; s.len = strlen(s.s);
	if(pv_parse_format(&s, &model) < 0) {
		LM_ERR("pv_sprintf: ERROR: wrong format[%s]!\n",
			fmt);
		return NULL;
	}

	if(pv_printf(m, model, out, &buf_size) < 0) {
		ret = NULL;
	} else {
		ret = strdup(out);
	}

	pv_elem_free_all(model);
	pkg_free(out);

	return ret;
}

/**
 * Convert an SV to an int_str struct. Needed in AVP package.
 * - val: SV to convert.
 * - is: pointer to resulting int_str
 * - flags: pointer to flags to set
 * - strflag: flag mask to be or-applied for string match
 */

inline int sv2int_str(SV *val, int_str *is,
		      unsigned short *flags, unsigned short strflag) {
	char *s;
	STRLEN len;

	if (!SvOK(val)) {
		LM_ERR("AVP:sv2int_str: Invalid value "
			"(not a scalar).\n");
		return 0;
	}
	
	if (SvIOK(val)) { /* numerical name */
		is->n = SvIV(val);
		*flags = 0;
		return 1;
	} else if (SvPOK(val)) {
		s = SvPV(val, len);
		is->s.len = len;
		is->s.s = s;
		(*flags) |= strflag;
		return 1;
	} else {
		LM_ERR("AVP:sv2int_str: Invalid value "
			"(neither string nor integer).\n");
		return 0;
	}
}

/* ************************************************************************ */
/* Object methods begin here */

#if 0
  "Skipped embedded POD."
#endif
#line 440 "openserxs.xs"

#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#line 452 "openserxs.c"

XS(XS_OpenSER_log); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER_log)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::log", "level, log");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	int	level = (int)SvIV(ST(0));
	char *	log = (char *)SvPV_nolen(ST(1));
#line 470 "openserxs.xs"
#line 469 "openserxs.c"
#line 471 "openserxs.xs"
#line 471 "openserxs.c"
#line 472 "openserxs.xs"
	switch (level) {
	case L_ALERT:	LM_ALERT("%s", log); break;
	case L_CRIT:	LM_CRIT("%s", log); break;
	case L_ERR:	LM_ERR("%s", log); break;
	case L_WARN:	LM_WARN("%s", log); break;
	case L_NOTICE:	LM_NOTICE("%s", log); break;
	case L_INFO:	LM_INFO("%s", log); break;
	default:	LM_DBG("%s", log); break;
	}
#line 482 "openserxs.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_OpenSER__Message_getType); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_getType)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::Message::getType", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
#line 508 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
#line 503 "openserxs.c"
	int	RETVAL;
	dXSTARG;
#line 510 "openserxs.xs"
#line 507 "openserxs.c"
#line 511 "openserxs.xs"
  	RETVAL = getType(msg);
#line 510 "openserxs.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_getStatus); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_getStatus)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::Message::getStatus", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
#line 528 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
    str *ret;
#line 533 "openserxs.c"
	SV *	RETVAL;
#line 531 "openserxs.xs"
#line 536 "openserxs.c"
#line 532 "openserxs.xs"
	if (!msg) {
		LM_ERR("Invalid message reference\n");
		ST(0) = &PL_sv_undef;
	} else {
		if (getType(msg) != SIP_REPLY) {
			LM_ERR("getStatus: Status not available in"
				" non-reply messages.");
			ST(0) = &PL_sv_undef;
		} else {
			ret = &((msg->first_line).u.reply.status);
			ST(0) = sv_2mortal(newSVpv(ret->s, ret->len));
		}
	}
#line 551 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_getReason); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_getReason)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::Message::getReason", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
#line 558 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
    str *ret;
#line 573 "openserxs.c"
	SV *	RETVAL;
#line 561 "openserxs.xs"
#line 576 "openserxs.c"
#line 562 "openserxs.xs"
	if (!msg) {
		LM_ERR("Invalid message reference\n");
		ST(0) = &PL_sv_undef;
	} else {
		if (getType(msg) != SIP_REPLY) {
			LM_ERR("getReason: Reason not available in"
				" non-reply messages.");
			ST(0) = &PL_sv_undef;
		} else {
			ret = &((msg->first_line).u.reply.reason);
			ST(0) = sv_2mortal(newSVpv(ret->s, ret->len));
		}
	}
#line 591 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_getVersion); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_getVersion)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::Message::getVersion", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
#line 587 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
    str *ret;
#line 613 "openserxs.c"
	SV *	RETVAL;
#line 590 "openserxs.xs"
#line 616 "openserxs.c"
#line 591 "openserxs.xs"
	if (!msg) {
		LM_ERR("Invalid message reference\n");
		ST(0) = &PL_sv_undef;
	} else {
		if (getType(msg) == SIP_REQUEST) {
			ret = &((msg->first_line).u.request.version);
		} else { /* SIP_REPLY */
			ret = &((msg->first_line).u.reply.version);
		}
		ST(0) = sv_2mortal(newSVpv(ret->s, ret->len));
	}
#line 629 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_getRURI); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_getRURI)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::Message::getRURI", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
#line 621 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
    str *ret;
#line 651 "openserxs.c"
	SV *	RETVAL;
#line 624 "openserxs.xs"
#line 654 "openserxs.c"
#line 625 "openserxs.xs"
	if (!msg) {
		LM_ERR("Invalid message reference\n");
		ST(0) = &PL_sv_undef;
	} else {
		if (getType(msg) != SIP_REQUEST) {
			LM_ERR("Not a request message - "
				"no RURI available.\n");
			ST(0) = &PL_sv_undef;
		} else {
			ret = &((msg->first_line).u.request.uri);
			ST(0) = sv_2mortal(newSVpv(ret->s, ret->len));
		}
	}
#line 669 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_getMethod); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_getMethod)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::Message::getMethod", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
#line 654 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
    str *ret;
#line 691 "openserxs.c"
	char *	RETVAL;
	dXSTARG;
#line 657 "openserxs.xs"
#line 695 "openserxs.c"
#line 658 "openserxs.xs"
	if (!msg) {
		LM_ERR("Invalid message reference\n");
		ST(0) = &PL_sv_undef;
	} else {
		if (getType(msg) != SIP_REQUEST) {
			LM_ERR("Not a request message - "
				"no method available.\n");
			ST(0) = &PL_sv_undef;
		} else {
			ret = &((msg->first_line).u.request.method);
			ST(0) = sv_2mortal(newSVpv(ret->s, ret->len));
		}
	}
#line 710 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_getFullHeader); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_getFullHeader)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::Message::getFullHeader", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
#line 687 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
    char *firsttoken;
    long headerlen;
#line 733 "openserxs.c"
	SV *	RETVAL;
#line 691 "openserxs.xs"
#line 736 "openserxs.c"
#line 692 "openserxs.xs"
	if (!msg) {
		LM_ERR("Invalid message reference\n");
		ST(0) = &PL_sv_undef;
	} else {
		if (getType(msg) == SIP_INVALID) {
			LM_ERR("getFullHeader: Invalid message type.\n");
			ST(0)  = &PL_sv_undef;
		} else {
			parse_headers(msg, ~0, 0);
			if (getType(msg) == SIP_REQUEST) {
				firsttoken = (msg->first_line).u.request.method.s;
			} else { /* SIP_REPLY */
				firsttoken = (msg->first_line).u.reply.version.s;
			}

			if (msg->eoh == NULL)
				headerlen = 0;
			else
				headerlen = ((long)(msg->eoh))
						-((long)(firsttoken));

			if (headerlen > 0) {
				ST(0) = 
				    sv_2mortal(newSVpv(firsttoken, headerlen));
			} else {
				ST(0) = &PL_sv_undef;
			}
		}
	}
#line 767 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_getBody); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_getBody)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::Message::getBody", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
#line 733 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
#line 788 "openserxs.c"
	SV *	RETVAL;
#line 735 "openserxs.xs"
#line 791 "openserxs.c"
#line 736 "openserxs.xs"
	if (!msg) {
		LM_ERR("Invalid message reference\n");
		ST(0) = &PL_sv_undef;
	} else {
		parse_headers(msg, ~0, 0);
		ST(0) = sv_2mortal(newSVpv(get_body(msg), 0));
	}
#line 800 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_getMessage); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_getMessage)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::Message::getMessage", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
#line 755 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
#line 821 "openserxs.c"
	SV *	RETVAL;
#line 757 "openserxs.xs"
#line 824 "openserxs.c"
#line 758 "openserxs.xs"
	if (!msg) {
		LM_ERR("Invalid message reference\n");
		ST(0) = &PL_sv_undef;
	} else {
		ST(0) = sv_2mortal(newSVpv(msg->buf, 0));
	}
#line 832 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_getHeader); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_getHeader)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::Message::getHeader", "self, name");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	self = ST(0);
	char *	name = (char *)SvPV_nolen(ST(1));
#line 781 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
    str *body = NULL;
    struct hdr_field *hf;
    int found = 0;
    int namelen = strlen(name);
#line 860 "openserxs.c"
	SV *	RETVAL;
#line 787 "openserxs.xs"
#line 863 "openserxs.c"
#line 788 "openserxs.xs"
	LM_DBG("searching '%s'\n", name);

	if (!msg) {
		LM_ERR("Invalid message reference\n");
	} else {
		parse_headers(msg, ~0, 0);
		for (hf = msg->headers; hf; hf = hf->next) {
			if (namelen == hf->name.len) {
				if (strncmp(name, hf->name.s, namelen) == 0) {
					/* Found the right header. */
					found = 1;
					body = &(hf->body);
					XPUSHs(sv_2mortal(newSVpv(body->s,
								  body->len)));
				}
			}
		}
	}
	if (!found) {
		XPUSHs(&PL_sv_undef);
	}
#line 886 "openserxs.c"
	PUTBACK;
	return;
    }
}


XS(XS_OpenSER__Message_getHeaderNames); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_getHeaderNames)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::Message::getHeaderNames", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	self = ST(0);
#line 822 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
    struct hdr_field *hf = NULL;
    int found = 0;
#line 912 "openserxs.c"
	AV *	RETVAL;
#line 827 "openserxs.xs"
	if (!msg) {
		LM_ERR("Invalid message reference\n");
	} else {
		parse_headers(msg, ~0, 0);
		for (hf = msg->headers; hf; hf = hf->next) {
			found = 1;
			XPUSHs(sv_2mortal(newSVpv(hf->name.s, hf->name.len)));
		}
	}
	if (!found) {
		XPUSHs(&PL_sv_undef);
	}
#line 927 "openserxs.c"
	PUTBACK;
	return;
    }
}


XS(XS_OpenSER__Message_moduleFunction); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_moduleFunction)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 4)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::Message::moduleFunction", "self, func, string1 = NULL, string2 = NULL");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	char *	func = (char *)SvPV_nolen(ST(1));
	char *	string1;
	char *	string2;
#line 973 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
    int retval; /* Return value of called function */
    int ret;    /* Return value of moduleFunc - < 0 for "non existing function" and other errors */
#line 954 "openserxs.c"
	int	RETVAL;
	dXSTARG;

	if (items < 3)
	    string1 = NULL;
	else {
	    string1 = (char *)SvPV_nolen(ST(2));
	}

	if (items < 4)
	    string2 = NULL;
	else {
	    string2 = (char *)SvPV_nolen(ST(3));
	}
#line 977 "openserxs.xs"
#line 970 "openserxs.c"
#line 978 "openserxs.xs"
	LM_DBG("Calling exported func '%s', Param1 is '%s',"
		" Param2 is '%s'\n", func, string1, string2);

	ret = moduleFunc(msg, func, string1, string2, &retval);
	if (ret < 0) {
		LM_ERR("calling module function '%s' failed."
			" Missing loadmodule?\n", func);
		retval = -1;
	}
	RETVAL = retval;
#line 982 "openserxs.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_log); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_log)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::Message::log", "self, level, log");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	int	level = (int)SvIV(ST(1));
	char *	log = (char *)SvPV_nolen(ST(2));
#line 1017 "openserxs.xs"
#line 1005 "openserxs.c"
#line 1018 "openserxs.xs"
#line 1007 "openserxs.c"
#line 1019 "openserxs.xs"
	switch (level) {
	case L_ALERT:	LM_ALERT("%s", log); break;
	case L_CRIT:	LM_CRIT("%s", log); break;
	case L_ERR:	LM_ERR("%s", log); break;
	case L_WARN:	LM_WARN("%s", log); break;
	case L_NOTICE:	LM_NOTICE("%s", log); break;
	case L_INFO:	LM_INFO("%s", log); break;
	default:	LM_DBG("%s", log); break;
	}
#line 1018 "openserxs.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_OpenSER__Message_rewrite_ruri); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_rewrite_ruri)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::Message::rewrite_ruri", "self, newruri");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	char *	newruri = (char *)SvPV_nolen(ST(1));
#line 1047 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
#line 1040 "openserxs.c"
	int	RETVAL;
	dXSTARG;
#line 1049 "openserxs.xs"
#line 1044 "openserxs.c"
#line 1050 "openserxs.xs"
  	if (!msg) {
		LM_ERR("Invalid message reference\n");
		RETVAL = -1;
	} else {
		if (getType(msg) != SIP_REQUEST) {
			LM_ERR("Not a Request. RURI rewrite unavailable.\n");
			RETVAL = -1;
		} else {
			LM_DBG("New R-URI is [%s]\n", newruri);
			RETVAL = rewrite_ruri(msg, newruri);
		}
	}
#line 1058 "openserxs.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_setFlag); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_setFlag)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::Message::setFlag", "self, flag");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	unsigned int	flag = (unsigned int)SvUV(ST(1));
#line 1079 "openserxs.xs"
	struct sip_msg *msg = sv2msg(self);
#line 1081 "openserxs.c"
	int	RETVAL;
	dXSTARG;
#line 1081 "openserxs.xs"
#line 1085 "openserxs.c"
#line 1082 "openserxs.xs"
  	if (!msg) {
		LM_ERR("Invalid message reference\n");
		RETVAL = -1;
	} else {
		RETVAL = setflag(msg, flag);
	}
#line 1093 "openserxs.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_resetFlag); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_resetFlag)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::Message::resetFlag", "self, flag");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	unsigned int	flag = (unsigned int)SvUV(ST(1));
#line 1103 "openserxs.xs"
	struct sip_msg *msg = sv2msg(self);
#line 1116 "openserxs.c"
	int	RETVAL;
	dXSTARG;
#line 1105 "openserxs.xs"
#line 1120 "openserxs.c"
#line 1106 "openserxs.xs"
  	if (!msg) {
		LM_ERR("Invalid message reference\n");
		RETVAL = -1;
	} else {
		RETVAL = resetflag(msg, flag);
	}
#line 1128 "openserxs.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_isFlagSet); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_isFlagSet)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::Message::isFlagSet", "self, flag");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	unsigned int	flag = (unsigned int)SvUV(ST(1));
#line 1126 "openserxs.xs"
	struct sip_msg *msg = sv2msg(self);
#line 1151 "openserxs.c"
	int	RETVAL;
	dXSTARG;
#line 1128 "openserxs.xs"
#line 1155 "openserxs.c"
#line 1129 "openserxs.xs"
  	if (!msg) {
		LM_ERR("Invalid message reference\n");
		RETVAL = -1;
	} else {
		RETVAL = isflagset(msg, flag) == 1 ? 1 : 0;
	}
#line 1163 "openserxs.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_pseudoVar); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_pseudoVar)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::Message::pseudoVar", "self, varstring");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	char *	varstring = (char *)SvPV_nolen(ST(1));
#line 1153 "openserxs.xs"
	struct sip_msg *msg = sv2msg(self);
	char *ret;
#line 1187 "openserxs.c"
	SV *	RETVAL;
#line 1156 "openserxs.xs"
  	if (!msg) {
		LM_ERR("Invalid message reference\n");
		ST(0) = &PL_sv_undef;
	} else {
		ret = pv_sprintf(msg, varstring);
		if (ret) {
			ST(0) = sv_2mortal(newSVpv(ret, strlen(ret)));
			free(ret);
		} else {
			ST(0) = &PL_sv_undef;
		}
	}
#line 1202 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_append_branch); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_append_branch)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1 || items > 3)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::Message::append_branch", "self, branch = NULL, qval = NULL");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	char *	branch;
	char *	qval;
#line 1183 "openserxs.xs"
	struct sip_msg *msg = sv2msg(self);
	qvalue_t q = Q_UNSPECIFIED;
	str b = {0, 0};
#line 1227 "openserxs.c"
	int	RETVAL;
	dXSTARG;

	if (items < 2)
	    branch = NULL;
	else {
	    branch = (char *)SvPV_nolen(ST(1));
	}

	if (items < 3)
	    qval = NULL;
	else {
	    qval = (char *)SvPV_nolen(ST(2));
	}
#line 1187 "openserxs.xs"
#line 1243 "openserxs.c"
#line 1188 "openserxs.xs"
  	if (!msg) {
		LM_ERR("Invalid message reference\n");
		RETVAL = -1;
	} else {
		if (qval) {
			if (str2q(&q, qval, strlen(qval)) < 0) {
				LM_ERR("append_branch: Bad q value.");
			} else { /* branch and qval set */
				b.s = branch;
				b.len = strlen(branch);
			}
		} else {
			if (branch) { /* branch set, qval unset */
				b.s = branch;
				b.len = strlen(branch);
			}
		}

		RETVAL = km_append_branch(msg, (b.s!=0)?&b:0, 0, 0, q, 0, 0);
	}
#line 1265 "openserxs.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_OpenSER__Message_getParsedRURI); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__Message_getParsedRURI)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::Message::getParsedRURI", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
#line 1223 "openserxs.xs"
    struct sip_msg *msg = sv2msg(self);
    struct sip_uri *uri;
    SV *ret;
#line 1289 "openserxs.c"
	SV *	RETVAL;
#line 1227 "openserxs.xs"
#line 1292 "openserxs.c"
#line 1228 "openserxs.xs"
	if (!msg) {
		LM_ERR("Invalid message reference\n");
		ST(0) = NULL;
	} else {
		parse_sip_msg_uri(msg);
		parse_headers(msg, ~0, 0);

		uri = &(msg->parsed_uri);
		ret = sv_newmortal();
		sv_setref_pv(ret, "OpenSER::URI", (void *)uri);
		SvREADONLY_on(SvRV(ret));

		ST(0) = ret;
	}
#line 1308 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_user); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_user)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::URI::user", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1266 "openserxs.xs"
	ST(0) = getStringFromURI(self, XS_URI_USER);
#line 1330 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_host); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_host)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::URI::host", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1279 "openserxs.xs"
	ST(0) = getStringFromURI(self, XS_URI_HOST);
#line 1352 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_passwd); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_passwd)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::URI::passwd", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1292 "openserxs.xs"
	ST(0) = getStringFromURI(self, XS_URI_PASSWD);
#line 1374 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_port); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_port)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::URI::port", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1305 "openserxs.xs"
	ST(0) = getStringFromURI(self, XS_URI_PORT);
#line 1396 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_params); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_params)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::URI::params", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1318 "openserxs.xs"
	ST(0) = getStringFromURI(self, XS_URI_PARAMS);
#line 1418 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_headers); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_headers)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::URI::headers", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1331 "openserxs.xs"
	ST(0) = getStringFromURI(self, XS_URI_HEADERS);
#line 1440 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_transport); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_transport)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::URI::transport", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1344 "openserxs.xs"
	ST(0) = getStringFromURI(self, XS_URI_TRANSPORT);
#line 1462 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_ttl); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_ttl)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::URI::ttl", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1357 "openserxs.xs"
	ST(0) = getStringFromURI(self, XS_URI_TTL);
#line 1484 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_user_param); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_user_param)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::URI::user_param", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1370 "openserxs.xs"
	ST(0) = getStringFromURI(self, XS_URI_USER_PARAM);
#line 1506 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_maddr); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_maddr)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::URI::maddr", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1384 "openserxs.xs"
	ST(0) = getStringFromURI(self, XS_URI_MADDR);
#line 1528 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_method); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_method)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::URI::method", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1396 "openserxs.xs"
	ST(0) = getStringFromURI(self, XS_URI_METHOD);
#line 1550 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_lr); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_lr)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::URI::lr", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1409 "openserxs.xs"
	ST(0) = getStringFromURI(self, XS_URI_LR);
#line 1572 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_r2); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_r2)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::URI::r2", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1422 "openserxs.xs"
	ST(0) = getStringFromURI(self, XS_URI_R2);
#line 1594 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_transport_val); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_transport_val)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::URI::transport_val", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1435 "openserxs.xs"
	ST(0) = getStringFromURI(self, XS_URI_TRANSPORT_VAL);
#line 1616 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_ttl_val); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_ttl_val)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::URI::ttl_val", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1448 "openserxs.xs"
	ST(0) = getStringFromURI(self, XS_URI_TTL_VAL);
#line 1638 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_user_param_val); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_user_param_val)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::URI::user_param_val", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1461 "openserxs.xs"
	ST(0) = getStringFromURI(self, XS_URI_USER_PARAM_VAL);
#line 1660 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_maddr_val); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_maddr_val)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::URI::maddr_val", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1474 "openserxs.xs"
	ST(0) = getStringFromURI(self, XS_URI_MADDR_VAL);
#line 1682 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_method_val); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_method_val)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::URI::method_val", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1487 "openserxs.xs"
	ST(0) = getStringFromURI(self, XS_URI_METHOD_VAL);
#line 1704 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_lr_val); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_lr_val)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::URI::lr_val", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1500 "openserxs.xs"
	ST(0) = getStringFromURI(self, XS_URI_LR_VAL);
#line 1726 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__URI_r2_val); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__URI_r2_val)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::URI::r2_val", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	self = ST(0);
	SV *	RETVAL;
#line 1513 "openserxs.xs"
	ST(0) = getStringFromURI(self, XS_URI_R2_VAL);
#line 1748 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__AVP_add); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__AVP_add)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::AVP::add", "p_name, p_val");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	p_name = ST(0);
	SV *	p_val = ST(1);
#line 1557 "openserxs.xs"
	int_str name;
	int_str val;
	unsigned short flags = 0;
	char *s;
	STRLEN len;
#line 1774 "openserxs.c"
	int	RETVAL;
	dXSTARG;
#line 1563 "openserxs.xs"
  	RETVAL = 0;
	if (SvOK(p_name) && SvOK(p_val)) {
		if (!sv2int_str(p_name, &name, &flags, AVP_NAME_STR)) {
			RETVAL = -1;
		} else if (!sv2int_str(p_val, &val, &flags, AVP_VAL_STR)) {
			RETVAL = -1;
		}

		if (RETVAL == 0) {
			RETVAL = add_avp(flags, name, val);
		}
	}
#line 1790 "openserxs.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_OpenSER__AVP_get); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__AVP_get)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::AVP::get", "p_name");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	p_name = ST(0);
#line 1594 "openserxs.xs"
	struct usr_avp *first_avp;
	int_str name;
	int_str val;
	unsigned short flags = 0;
	SV *ret = &PL_sv_undef;
	int err = 0;
	char *s;
	STRLEN len;
#line 1819 "openserxs.c"
	int	RETVAL;
	dXSTARG;
#line 1603 "openserxs.xs"
	if (SvOK(p_name)) {
		if (!sv2int_str(p_name, &name, &flags, AVP_NAME_STR)) {
			LM_ERR("AVP:get: Invalid name.");
			err = 1;
		}
	} else {
		LM_ERR("AVP:get: Invalid name.");
		err = 1;
	}

	if (err == 0) {
		first_avp = search_first_avp(flags, name, &val, NULL);

		if (first_avp != NULL) { /* found correct AVP */
			if (is_avp_str_val(first_avp)) {
				ret = sv_2mortal(newSVpv(val.s.s, val.s.len));
			} else {
				ret = sv_2mortal(newSViv(val.n));
			}
		} else {
			/* Empty AVP requested. */
		}
	}

	ST(0) = ret;
#line 1848 "openserxs.c"
    }
    XSRETURN(1);
}


XS(XS_OpenSER__AVP_destroy); /* prototype to pass -Wmissing-prototypes */
XS(XS_OpenSER__AVP_destroy)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "OpenSER::AVP::destroy", "p_name");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	p_name = ST(0);
#line 1645 "openserxs.xs"
	struct usr_avp *first_avp;
	int_str name;
	int_str val;
	unsigned short flags = 0;
	SV *ret = &PL_sv_undef;
	char *s;
	STRLEN len;
#line 1875 "openserxs.c"
	int	RETVAL;
	dXSTARG;
#line 1653 "openserxs.xs"
	RETVAL = 1;
	if (SvOK(p_name)) {
		if (!sv2int_str(p_name, &name, &flags, AVP_NAME_STR)) {
			RETVAL = 0;
			LM_ERR("AVP:destroy: Invalid name.");
		}
	} else {
		RETVAL = 0;
		LM_ERR("VP:destroy: Invalid name.");
	}

	if (RETVAL == 1) {
		first_avp = search_first_avp(flags, name, &val, NULL);

		if (first_avp != NULL) { /* found correct AVP */
			destroy_avp(first_avp);
		} else {
			RETVAL = 0;
			/* Empty AVP requested. */
		}
	}

#line 1901 "openserxs.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_OpenSER); /* prototype to pass -Wmissing-prototypes */
XS(boot_OpenSER)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    char* file = __FILE__;

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    XS_VERSION_BOOTCHECK ;

        newXS("OpenSER::log", XS_OpenSER_log, file);
        newXSproto("OpenSER::Message::getType", XS_OpenSER__Message_getType, file, "$");
        newXSproto("OpenSER::Message::getStatus", XS_OpenSER__Message_getStatus, file, "$");
        newXSproto("OpenSER::Message::getReason", XS_OpenSER__Message_getReason, file, "$");
        newXSproto("OpenSER::Message::getVersion", XS_OpenSER__Message_getVersion, file, "$");
        newXSproto("OpenSER::Message::getRURI", XS_OpenSER__Message_getRURI, file, "$");
        newXSproto("OpenSER::Message::getMethod", XS_OpenSER__Message_getMethod, file, "$");
        newXSproto("OpenSER::Message::getFullHeader", XS_OpenSER__Message_getFullHeader, file, "$");
        newXSproto("OpenSER::Message::getBody", XS_OpenSER__Message_getBody, file, "$");
        newXSproto("OpenSER::Message::getMessage", XS_OpenSER__Message_getMessage, file, "$");
        newXSproto("OpenSER::Message::getHeader", XS_OpenSER__Message_getHeader, file, "$$");
        newXSproto("OpenSER::Message::getHeaderNames", XS_OpenSER__Message_getHeaderNames, file, "$");
        newXSproto("OpenSER::Message::moduleFunction", XS_OpenSER__Message_moduleFunction, file, "$$;$$");
        newXSproto("OpenSER::Message::log", XS_OpenSER__Message_log, file, "$$$");
        newXSproto("OpenSER::Message::rewrite_ruri", XS_OpenSER__Message_rewrite_ruri, file, "$$");
        newXSproto("OpenSER::Message::setFlag", XS_OpenSER__Message_setFlag, file, "$$");
        newXSproto("OpenSER::Message::resetFlag", XS_OpenSER__Message_resetFlag, file, "$$");
        newXSproto("OpenSER::Message::isFlagSet", XS_OpenSER__Message_isFlagSet, file, "$$");
        newXSproto("OpenSER::Message::pseudoVar", XS_OpenSER__Message_pseudoVar, file, "$$");
        newXSproto("OpenSER::Message::append_branch", XS_OpenSER__Message_append_branch, file, "$;$$");
        newXSproto("OpenSER::Message::getParsedRURI", XS_OpenSER__Message_getParsedRURI, file, "$");
        newXSproto("OpenSER::URI::user", XS_OpenSER__URI_user, file, "$");
        newXSproto("OpenSER::URI::host", XS_OpenSER__URI_host, file, "$");
        newXSproto("OpenSER::URI::passwd", XS_OpenSER__URI_passwd, file, "$");
        newXSproto("OpenSER::URI::port", XS_OpenSER__URI_port, file, "$");
        newXSproto("OpenSER::URI::params", XS_OpenSER__URI_params, file, "$");
        newXSproto("OpenSER::URI::headers", XS_OpenSER__URI_headers, file, "$");
        newXSproto("OpenSER::URI::transport", XS_OpenSER__URI_transport, file, "$");
        newXSproto("OpenSER::URI::ttl", XS_OpenSER__URI_ttl, file, "$");
        newXSproto("OpenSER::URI::user_param", XS_OpenSER__URI_user_param, file, "$");
        newXSproto("OpenSER::URI::maddr", XS_OpenSER__URI_maddr, file, "$");
        newXSproto("OpenSER::URI::method", XS_OpenSER__URI_method, file, "$");
        newXSproto("OpenSER::URI::lr", XS_OpenSER__URI_lr, file, "$");
        newXSproto("OpenSER::URI::r2", XS_OpenSER__URI_r2, file, "$");
        newXSproto("OpenSER::URI::transport_val", XS_OpenSER__URI_transport_val, file, "$");
        newXSproto("OpenSER::URI::ttl_val", XS_OpenSER__URI_ttl_val, file, "$");
        newXSproto("OpenSER::URI::user_param_val", XS_OpenSER__URI_user_param_val, file, "$");
        newXSproto("OpenSER::URI::maddr_val", XS_OpenSER__URI_maddr_val, file, "$");
        newXSproto("OpenSER::URI::method_val", XS_OpenSER__URI_method_val, file, "$");
        newXSproto("OpenSER::URI::lr_val", XS_OpenSER__URI_lr_val, file, "$");
        newXSproto("OpenSER::URI::r2_val", XS_OpenSER__URI_r2_val, file, "$");
        newXSproto("OpenSER::AVP::add", XS_OpenSER__AVP_add, file, "$$");
        newXSproto("OpenSER::AVP::get", XS_OpenSER__AVP_get, file, "$");
        newXSproto("OpenSER::AVP::destroy", XS_OpenSER__AVP_destroy, file, "$");
    if (PL_unitcheckav)
         call_list(PL_scopestack_ix, PL_unitcheckav);
    XSRETURN_YES;
}

