/*
    Copyright (C) 2005 by Ryan Schultz <schultz.ryan@gmail.com>
	GNU GPL v2 
*/

/* Translation data from kanjidic/edict */

#ifndef _KANJI_H_
#define _KANJI_H_

typedef struct {
  const char    * pKanji;
  const char	* pEnglish;
  const char	* pKun;
  const char	* pKunRomaji;
  const char	* pOn;
  const char	* pOnRomaji;
} kanjitransInfo;

static kanjitransInfo kanjitable_jlpt4[] =
{
{"半","half, middle, odd number, semi-, part-","なか.ば, は","","ハン",""},
{"南","south","みなみ, なみ, は, みな, みまみ","","ナン, ナ",""},
{"友","friend","とも, う, ど, ゆ","","ユウ",""},
{"口","mouth","くち","","コウ, ク",""},
{"古","old","ふる.い, ふる, ふる.す, ふゆ","","コ",""},
{"右","right","みぎ, あき, すけ","","ウ, ユウ",""},
{"名","name, noted, distinguished, reputation","な, な, と","","メイ, ミョウ",""},
{"四","four","よ, よ.つ, よっ.つ, よん, あ, つ, よつ","","シ",""},
{"国","country","くに, くな, こ","","コク",""},
{"土","soil, earth, ground, Turkey","つち, つ, つく, は, ひじ","","ド, ト",""},
{"外","outside","そと, ほか, はず.す, はず.れる, と, うい, け, ふか","","ガイ, ゲ",""},
{"多","many, frequent, much","おお.い, まさ.に, まさ.る","","タ",""},
{"大","large, big","おお, おお.きい, おお.いに, うふ, お, おう, た, たかし, とも, はじめ, ひろ, ひろし, まさ, まさる, もと, わ","","ダイ, タイ",""},
{"天","heavens, sky, imperial","あまつ, あめ, あま, あき, あも, た, たかし, て, なま","","テン",""},
{"女","woman, female","おんな, め, おな, た, つき, な","","ジョ, ニョ, ニョウ",""},
{"子","child, sign of the rat, 11PM-1AM, first sign of Chinese zodiac","こ, こ, ね, い, き, ぎ, く, け, ねっ","","シ, ス, ツ",""},
{"学","study, learning, science","まな.ぶ, たか, のり","","ガク",""},
{"安","relax, cheap, low, quiet, rested, contented, peaceful","やす.い, やす.まる, やす, やす.らか, あ, あす, あず, あっ, や","","アン",""},
{"小","little, small","ちい.さい, こ, お, さ, いさら, こう, さざ, しゃお, ちいさ","","ショウ",""},
{"少","few, little","すく.ない, すこ.し","","ショウ",""},
{"山","mountain","やま, さ, やの, やん","","サン, セン",""},
{"川","stream, river","かわ, か, こ, さわ, さんぼんがわ","","セン",""},
{"左","left","ひだり, そ","","サ, シャ",""},
{"年","year","とし, ね","","ネン",""},
{"店","store, shop","みせ, たな","","テン",""},
{"後","behind, back, later","のち, うし.ろ, うしろ, あと, おく.れる, こし, し, しい, しり","","ゴ, コウ",""},
{"手","hand","て, て, て, た","","シュ, ズ",""},
{"新","new","あたら.しい, あら.た, あら, にい, あせ, あたらし, し, に, にっ, につ, よし","","シン",""},
{"日","day, sun, Japan","ひ, び, か, あ, あき, いる, く, くさ, こう, す, たち, に, にっ, につ, へ","","ニチ, ジツ",""},
{"時","time, hour","とき, どき, と, とぎ","","ジ",""},
{"書","write","か.く, が.き, がき, かき","","ショ",""},
{"月","month, moon","つき, おと, がっ, す, ずき, もり","","ゲツ, ガツ",""},
{"木","tree, wood","き, こ, ぐ, も, もと","","ボク, モク",""},
{"本","book, present, main, true, real, counter for long things","もと, まと","","ホン",""},
{"来","come, due, next, cause, become","く.る, きた.る, きた.す, き.たす, き.たる, き, こ, くり, くる, ごろ, さ","","ライ, タイ",""},
{"東","east","ひがし, あい, あがり, あずま, あづま, こ, さき, しの, とお, はる, ひが, もと","","トウ",""},
{"校","exam, school, printing, proof, correction","めん","","コウ, キョウ",""},
{"母","mama, mother","はは, も","","ボ",""},
{"毎","every","ごと, ごと.に, つね","","マイ",""},
{"気","spirit, mind","いき","","キ, ケ",""},
{"水","water","みず, みず, うず, ずみ, つ, ど, み, みさ, みつ, みな, みん","","スイ",""},
{"火","fire","ひ, び, ほ","","カ",""},
{"父","father","ちち","","フ",""},
{"生","life, genuine, birth","い.きる, い.かす, い.ける, う.まれる, う.まれ, うまれ, う.む, お.う, は.える, は.やす, き, なま, なま, な.る, な.す, む.す, う, あさ, いき, いく, いけ, うぶ, うまい, え, おい, ぎゅう, くるみ, ごせ, さ, じょう, すぎ, そ, そう, ちる, なば, にう, にゅう, ふ, み, もう, よい, りゅう","","セイ, ショウ",""},
{"男","male","おとこ, お, み","","ダン, ナン",""},
{"白","white","しろ, しら, しろ.い, あき, か, はっ","","ハク, ビャク",""},
{"百","hundred","もも, お, ど, どう, なり, ひゃっ, ひゅく, も, もんど, ゆ","","ヒャク, ビャク",""},
{"目","eye, class, look, insight, experience, care, favor","め, め, ま, さかん, さがん, さっか, さつか","","モク, ボク",""},
{"社","company, firm, office, association, shrine","やしろ, こそ","","シャ",""},
{"空","empty, sky, void, vacant, vacuum","そら, あ.く, あ.き, あ.ける, から, す.く, す.かす, むな.しい, うつ, き, く","","クウ",""},
{"立","stand up","た.つ, た.つ, た.ち, た.てる, た.てる, た.て, たて, た.て, だ.て, だ.てる, たち, たっ, たつ, だて, つい","","リツ, リュウ, リットル",""},
{"耳","ear","みみ, がみ","","ジ",""},
{"聞","hear, ask, listen","き.く, き.こえる","","ブン, モン",""},
{"花","flower","はな, わ","","カ, ケ",""},
{"行","going, journey","い.く, ゆ.く, ゆ.き, ゆき, い.き, いき, おこな.う, おこ.なう, いく, なみ, なめ, みち, ゆき, ゆく","","コウ, ギョウ, アン",""},
{"西","west, Spain","にし, いり, ひし, むら","","セイ, サイ, ス",""},
{"見","see, hopes, chances, idea, opinion, look at, visible","み.る, み.える, み.せる","","ケン",""},
{"言","say","い.う, こと, とき","","ゲン, ゴン",""},
{"話","tale, talk","はな.す, はなし","","ワ",""},
{"語","word, speech, language","かた.る, かた.らう","","ゴ",""},
{"読","read","よ.む, よ.み, よみ","","ドク, トク, トウ",""},
{"買","buy","か.う","","バイ",""},
{"足","leg, foot, be sufficient, counter for pairs of footwear","あし, た.りる, た.る, た.す, あ, あす, おす, たらし","","ソク",""},
{"車","car","くるま, くら, くろま","","シャ",""},
{"週","week","","","シュウ",""},
{"道","road-way, street, district, journey, course, moral, teachings","みち, さ, じ, ど, みつ","","ドウ, トウ",""},
{"金","gold","かね, かな, がね, かん, きむ, こ, この, ん","","キン, コン, ゴン",""},
{"長","long, leader","なが.い, おさ, お, おしゃ, たかし, たけ, な, は, ひさ","","チョウ",""},
{"間","interval, space","あいだ, ま, あい","","カン, ケン",""},
{"雨","rain","あめ, あま, さめ","","ウ",""},
{"電","electricity","","","デン",""},
{"食","eat, food","く.う, く.らう, た.べる, は.む, ぐい","","ショク, ジキ",""},
{"飲","drink, smoke, take","の.む, の.み","","イン, オン",""},
{"駅","station","","","エキ",""},
{"高","tall, high, expensive","たか.い, たか, だか, たか.まる, たか.める, か, こ, じょい, た, はか","","コウ",""},
{"魚","fish","うお, さかな, ざかな, い","","ギョ",""}
};

static kanjitransInfo kanjitable_jlpt3[] = 
{
{"青","blue, green","あお, あお, あお.い, お","","セイ, ショウ",""},
{"赤","red","あか, あか, あか.い, あか.らむ, あか.らめる, あ, あこ, あま","","セキ, シャク",""},
{"明","bright, light","あ.かり, あか.るい, あか.るむ, あか.らむ, あき.らか, あ.ける, あ.け, あ.く, あ.くる, あ.かす, あきら, あけ, あす, きら, け, さや, さやか, とし, はる, み, め","","メイ, ミョウ, ミン",""},
{"秋","autumn","あき, とき, あい","","シュウ",""},
{"開","open, unfold, unseal","ひら.く, ひら.き, びら.き, ひら.ける, あ.く, あ.ける, はる, か","","カイ",""},
{"悪","bad, vice, rascal, false, evil, wrong","わる.い, わる, あ.し, にく.い, にく.い, ああ, いずくに, いずくんぞ, にく.む","","アク, オ",""},
{"朝","morning, dynasty, regime, epoch, period, (North) Korea","あさ, あ, あそ, ささ, ちか, とも","","チョウ",""},
{"字","character, letter, word, section of village","あざ, あざな, な","","ジ",""},
{"味","flavor, taste","あじ, あじ.わう","","ミ",""},
{"集","gather, meet, congregate, swarm, flock","あつ.まる, あつ.める, つど.う, あつまり, ず","","シュウ",""},
{"兄","elder brother, big brother","あに, え, せ, よし","","ケイ, キョウ",""},
{"姉","elder sister","あね, はは","","シ",""},
{"歩","walk, counter for steps","ある.く, あゆ.む, あ, ゆき, ゆみ","","ホ, ブ, フ",""},
{"有","possess, have, exist, happen, occur, approx","あ.る, あ, あら, あり, ある, くに, なお, ゆ","","ユウ, ウ",""},
{"医","doctor, medicine","い.やす, い.する, くすし","","イ",""},
{"意","idea, mind, heart, taste, thought, desire, care, liking","もと, よし","","イ",""},
{"以","by means of, because, in view of, compared with","もっ.て, もち","","イ",""},
{"家","house, home","いえ, や, うち, あり, え, く, つか, べ","","カ, ケ",""},
{"急","hurry, emergency, sudden, steep","いそ.ぐ, いそ.ぎ","","キュウ",""},
{"犬","dog","いぬ, いぬ","","ケン",""},
{"妹","younger sister","いもうと, す, せ, も","","マイ",""},
{"色","color","いろ, しか, しこ","","ショク, シキ",""},
{"音","sound, noise","おと, ね, お, と","","オン, イン, ノン",""},
{"員","employee, member, number, the one in charge","いな, かず","","イン",""},
{"院","Inst., institution, temple, mansion, school","","","イン",""},
{"動","move, motion, change, confusion, shift, shake","うご.く, うご.かす, るぎ","","ドウ",""},
{"牛","cow","うし, うじ, ご","","ギュウ",""},
{"歌","song, sing","うた, うた.う","","カ",""},
{"写","copy, be photographed, describe","うつ.す, うつ.る, うつ, うつ.し","","シャ, ジャ",""},
{"映","reflect, reflection, projection","うつ.る, うつ.す, は.える, ば.え, あきら, え, てる","","エイ",""},
{"海","sea, ocean","うみ, あ, あま, うな, うん, え, か, た, ひろ, ひろし, ぶ, まち, まま, み, め, わたる","","カイ",""},
{"売","sell","う.る, う.れる, うり, うる, め","","バイ",""},
{"運","carry, luck, destiny, fate, lot, transport, progress, advance","はこ.ぶ","","ウン",""},
{"重","heavy, heap up, pile up, nest of boxes, -fold","え, おも.い, おも.り, おも.なう, かさ.ねる, かさ.なる, おも, さね, しげ, しげる","","ジュウ, チョウ",""},
{"英","England, English","はなぶさ, あ, あい, え, すぐる, はな, ひ, ひで, よし, ら","","エイ",""},
{"終","end, finish","お.わる, お.わる, おわ.る, お.える, つい, つい.に, ばて","","シュウ",""},
{"起","rouse, wake up, get up","お.きる, お.こる, お.こす, おこ.す, た.つ","","キ",""},
{"屋","roof, house, shop, dealer, seller","や, た","","オク",""},
{"送","escort, send","おく.る","","ソウ",""},
{"教","teach, faith, doctrine","おし.える, おそ.わる, のり, ひさ","","キョウ",""},
{"弟","younger brother, faithful service to elders","おとうと, て","","テイ, ダイ, デ",""},
{"同","same, agree, equal","おな.じ","","ドウ",""},
{"主","lord, chief, master, main thing, principal","ぬし, おも, あるじ, かず, ず, もん","","シュ, ス, シュウ",""},
{"思","think","おも.う, おもえら.く, おぼ.す","","シ",""},
{"親","parent, intimacy, relative, familiarity, dealer (cards)","おや, おや, した.しい, した.しむ, ぎ, ちか, のり","","シン",""},
{"夏","summer","なつ","","カ, ガ, ゲ",""},
{"画","brush-stroke, picture","えが.く, かく.する, かぎ.る, はかりごと, はか.る","","ガ, カク, エ, カイ",""},
{"界","world","","","カイ",""},
{"帰","homecoming, arrive at, lead to, result in","かえ.る, かえ.す, おく.る, とつ.ぐ","","キ",""},
{"代","substitute, change, convert, replace, period, age, generation, charge, rate, fee","か.わる, かわ.る, かわ.り, がわ.り, か.える, よ, しろ, す","","ダイ, タイ",""},
{"楽","music, comfort, ease","たの.しい, たの.しむ, この.む, さ, た, やす, ら","","ガク, ラク, ゴウ",""},
{"風","wind, air, style, manner","かぜ, かざ, かぜ, い, え","","フウ, フ",""},
{"貸","lend","か.す, か.し, かし","","タイ",""},
{"方","direction, person, alternative","かた, かた, がた, から, な, なた, ふさ, まさ, みち, も, わ","","ホウ",""},
{"紙","paper","かみ","","シ",""},
{"通","traffic, pass through, avenue, commute, counter for letters","とお.る, とお.り, とお.り, どお.り, とお.す, とお.し, どお.し, かよ.う, とん, どうし, どおり, みち","","ツウ, ツ",""},
{"体","body, substance, object, reality, counter for images","からだ, かたち, なり","","タイ, テイ",""},
{"借","borrow, rent","か.りる","","シャク",""},
{"漢","Sino-, China","はん","","カン",""},
{"館","building, mansion, large building, palace","やかた, たて, たち","","カン",""},
{"元","beginning, former time, origin","もと, ちか, はじめ, はる, ゆき, よし","","ゲン, ガン",""},
{"考","consider, think over","かんが.える, かんが.え, たか","","コウ",""},
{"着","don, arrive, wear, counter for suits of clothing","き.る, ぎ, き.せる, き.せ, つ.く, つ.ける","","チャク, ジャク",""},
{"究","research, study","きわ.める, きゅ","","キュウ, ク",""},
{"去","gone, past, quit, leave, elapse, eliminate, divorce","さ.る, さ.る, い","","キョ, コ",""},
{"京","capital, 10**16","みやこ, たか","","キョウ, ケイ, キン",""},
{"強","strong","つよ.い, つよ.まる, つよ.める, し.いる, こわ.い, すね","","キョウ, ゴウ",""},
{"業","business, vocation, arts, performance","わざ, なり, のぶ","","ギョウ, ゴウ",""},
{"〆切","(n) closing, cut-off, end, deadline, Closed, No Entrance","","","しめきり",""},
{"切","cut, cutoff, be sharp","き.る, き.る, き.り, き.り, ぎ.り, き.れる, き.れる, き.れ, き.れ, ぎ.れ, きつ, きり, ぎり","","セツ, サイ",""},
{"近","near, early, akin, tantamount","ちか.い, おう, おお, この","","キン, コン",""},
{"銀","silver","しろがね, うん, かな, かね","","ギン",""},
{"工","craft, construction","もく, たくみ","","コウ, ク, グ",""},
{"黒","black","くろ, くろ.ずむ, くろ.い","","コク",""},
{"計","plot, plan, scheme, measure","はか.る, はか.らう, え, かず, け","","ケイ",""},
{"研","polish, study of, sharpen","と.ぐ, のり","","ケン",""},
{"建","build","た.てる, た.て, だ.て, た.つ, たけ, たつ, たて","","ケン, コン",""},
{"験","verification, effect, testing","あかし, しるし, ため.す, ためし","","ケン, ゲン",""},
{"広","wide, broad, spacious","ひろ.い, ひろ.まる, ひろ.める, ひろ.がる, ひろ.げる","","コウ",""},
{"心","heart, mind, spirit","こころ, ごころ, りっしんべん","","シン",""},
{"試","test, try, attempt, experiment, ordeal","こころ.みる, ため.す","","シ",""},
{"答","solution, answer","こた.える, こた.え, どう","","トウ",""},
{"事","matter, thing, fact, business, reason, possibly","こと, つか.う, つか.える, ろ","","ジ, ズ",""},
{"転","revolve, turn around, change","ころ.がる, ころ.げる, ころ.がす, ころ.ぶ, まろ.ぶ, うたた, うつ.る","","テン",""},
{"作","make, production, prepare, build","つく.る, つく.り, づく.り, くり, さか, さっ, づくり, とも, なお, はぎ, まさか","","サク, サ",""},
{"茶","tea","ちや","","チャ, サ",""},
{"早","early, fast","はや.い, はや, はや, はや.まる, はや.める, さ, さか, さわ, そ, わ","","ソウ, サッ",""},
{"止","stop, halt","と.まる, ど.まり, と.める, と.める, ど.め, とど.める, とど.め, とど.まる, や.める, や.む, や.む, よ.す, さ.す, さ.し, どめ","","シ",""},
{"自","oneself","みずか.ら, おの.ずから, おの.ずと, より","","ジ, シ",""},
{"仕","attend, doing, official, serve","つか.える","","シ, ジ",""},
{"死","death, die","し.ぬ, し.に","","シ",""},
{"始","commence, begin","はじ.める, はじ.める, はじ.まる, もと","","シ",""},
{"使","use","つか.う, つか.い, つか.い, づか.い","","シ",""},
{"私","private, I, me","わたくし, わたし","","シ",""},
{"地","ground, earth","どま","","チ, ジ",""},
{"持","hold, have","も.つ, も.ち, も.てる, もち, もつ","","ジ",""},
{"質","substance, quality, matter, temperament","たち, ただ.す, もと, わりふ","","シツ, シチ, チ",""},
{"室","room, apartment, chamber, greenhouse, cellar","むろ","","シツ",""},
{"品","goods, refinement, dignity, article, counter for meal courses","しな","","ヒン, ホン",""},
{"者","someone, person","もの","","シャ",""},
{"習","learn","なら.う, なら.い","","シュウ, ジュ",""},
{"住","dwell, reside, live, inhabit","す.む, す.まう, ず.まい, し, じゅ, すみ","","ジュウ, ヂュウ, チュウ",""},
{"春","springtime, spring (season)","はる, あずま, かす, すの, ひ, わら","","シュン",""},
{"正","correct, justice, righteous, 10**40","ただ.しい, ただ.す, まさ, まさ.に, おお, くに, ま, まさし, ただし","","セイ, ショウ",""},
{"場","location, place","ば","","ジョウ, チョウ",""},
{"知","know, wisdom","し.る, し.らせる, さと, さとる, しり, しれ, とも, のり","","チ",""},
{"真","true, reality, Buddhist sect","ま, ま, まこと, さな, さね, ただ, ただし, なお, のり, まあ, まこ, まさ, まっ, まど, まな, まゆ, みち, も","","シン",""},
{"図","map, drawing, plan, unexpected, accidentally","え, はか.る, づ","","ズ, ト",""},
{"世","generation, world, society, public","よ, さんじゅう, とし, ゆ, ゆき","","セイ, セ, ソウ",""},
{"夕","evening","ゆう, ゆ","","セキ",""},
{"走","run","はし.る, はしり","","ソウ",""},
{"族","tribe, family","つぎ","","ゾク",""},
{"注","pour, irrigate, shed (tears), flow into, concentrate on, notes, comment, annotate","そそ.ぐ, さ.す, つ.ぐ","","チュウ",""},
{"田","rice field, rice paddy","た, いなか, おか, たん, で, とう, や","","デン",""},
{"台","pedestal, a stand, counter for machines and vehicles","うてな, われ, つかさ","","ダイ, タイ",""},
{"待","wait, depend on","ま.つ, ま.ち, まち, まつ","","タイ",""},
{"題","topic, subject","","","ダイ",""},
{"度","degrees, occurrence, time, counter for occurrences","たび, た.い, のり","","ド, ト, タク",""},
{"旅","trip, travel","たび","","リョ",""},
{"力","power, strong, strain, bear up, exert","ちから, じから, つとむ","","リョク, リキ, リイ",""},
{"昼","daytime, noon","ひる","","チュウ",""},
{"町","village, town, block, street","まち","","チョウ",""},
{"鳥","bird, chicken","とり, か, と, とっ","","チョウ",""},
{"問","question, ask, problem","と.う, と.い, とん, はる","","モン",""},
{"冬","winter","ふゆ","","トウ",""},
{"堂","public chamber, hall","","","ドウ",""},
{"特","special","","","トク",""},
{"肉","meat","","","ニク",""},
{"野","plains, field, rustic, civilian life","の, の, ずけ, つけ, ぬ","","ヤ, ショ",""},
{"発","discharge, departure, publish, emit, start from, disclose","た.つ, あば.く, おこ.る, つか.わす, はな.つ, ば, わ","","ハツ, ホツ",""},
{"飯","meal, boiled rice","めし, い, いい, いり, え","","ハン",""},
{"病","ill, sick","や.む, や.み, やまい","","ビョウ, ヘイ",""},
{"不","negative, non-, bad, ugly, clumsy","","","フ, ブ",""},
{"服","clothing, admit, obey, discharge","はっ, はつ, はら","","フク",""},
{"物","thing, object, matter","もの, もの","","ブツ, モツ",""},
{"文","sentence, literature, style, art, decoration, figures, plan","ふみ, あや, かざり, ふ, も, ぶんにょう","","ブン, モン",""},
{"別","separate, branch off, diverge, fork, another, extra, specially","わか.れる, わ.ける, べっ","","ベツ",""},
{"勉","exertion","つと.める, ひこ, やつ","","ベン",""},
{"用","utilize, business, service, use, employ","もち.いる, たから","","ヨウ",""},
{"夜","night, evening","よ, よる","","ヤ",""},
{"曜","weekday","てる","","ヨウ",""},
{"洋","ocean, western style","なだ, ひろ, ひろし, よ, よし","","ヨウ",""},
{"理","logic, arrangement, reason, justice, truth","ことわり, あや, おさむ, さと, さとる, ただ, ただし, とおる, に, のり, ひ, まこと, まさ, まさし, まろ, みち, よし","","リ",""},
{"料","fee, materials","","","リョウ",""},
{"暗","darkness, disappear, shade, informal, grow dark, be blinded","くら.い","","アン",""},
{"引","pull, tug, jerk, admit, install, quote, refer to","ひ.く, ひ.き, ひ.き, び.き, ひ.ける, いな, ひき, ひけ, びき","","イン",""},
{"遠","distant, far","とお.い, お, おに, ど, どお","","エン, オン",""},
{"回","-times, round, game, revolve, counter for occurrences","まわ.る, まわ.る, まわ.り, まわ.す, まわ.す, まわ.し, まわ.し, もとお.る, か.える","","カイ, エ",""},
{"寒","cold","さむ.い, さ, さん","","カン",""},
{"顔","face, expression","かお","","ガン",""},
{"区","ward, district","","","ク, オウ, コウ",""},
{"軽","lightly, trifling, unimportant","かる.い, かろ.やか, かろ.んじる","","ケイ",""},
{"県","prefecture","か.ける, あがた, がた","","ケン",""},
{"光","ray, light","ひか.る, ひかり, あき, あきら, こお, てる, ひこ, み, みつ","","コウ",""},
{"好","fond, pleasing, like something","この.む, す.く, よ.い, い.い, こ, たか, とし, よし","","コウ",""},
{"合","fit, suit, join, 0.1","あ.う, あ.う, あ.い, あい, あ.い, あい, あ.わす, あ.わせる, あ.わせる, あう, あん, い, か, こう, ごお, に, ね, や, り, わい","","ゴウ, ガッ, カッ",""},
{"菜","vegetable, side dish, greens","な, よう","","サイ",""},
{"産","products, bear, give birth, yield, childbirth, native, property","う.む, う.まれる, うぶ, む.す, もと","","サン",""},
{"市","market, city, town","いち, い, ち","","シ",""},
{"弱","weak, frail","よわ.い, よわ.る, よわ.まる, よわ.める","","ジャク",""},
{"首","neck","くび, おびと, こべ, す","","シュ",""},
{"暑","sultry, hot, summer heat","あつ.い","","ショ",""},
{"所","place","ところ, ところ, どころ, とこ, せ","","ショ",""},
{"乗","ride, power, multiplication, record, counter for vehicles, board, mount, join","の.る, の.り, の.せる, のり","","ジョウ, ショウ",""},
{"森","forest, woods","もり, もと","","シン",""},
{"進","advance, proceed, progress, promote","すす.む, すす.める, のぶ","","シン",""},
{"声","voice","こえ, こわ","","セイ, ショウ",""},
{"説","rumor, opinion, theory","と.く, さとし, とき","","セツ, ゼイ",""},
{"洗","wash, inquire into, probe","あら.う, あらい, らい","","セン",""},
{"村","town, village","むら, え, むた, ら","","ソン",""},
{"太","plump, thick, big around","ふと.い, ふと.る, おお, たか, ひろ","","タイ, タ",""},
{"短","short, brevity, fault, defect, weak point","みじか.い","","タン",""},
{"池","pond, cistern, pool, reservoir","いけ","","チ",""},
{"低","lower, short, humble","ひく.い, ひく.める, ひく.まる","","テイ",""},
{"都","metropolis, capital","みやこ, くに, ず, ち, づめ, みや","","ト, ツ",""},
{"便","convenience","たよ.り","","ベン, ビン",""},
{"民","people, nation, subjects","たみ, ひと, み","","ミン",""},
{"門","gates","かど, と, じょう, も","","モン",""},
{"薬","medicine, chemical, enamel, gunpowder, benefit","くすり, み","","ヤク",""},
{"林","grove, forest","はやし, し","","リン",""}
};

static kanjitransInfo kanjitable_jlpt2[] = 
{
{"相","inter-, mutual, together, each other, minister of state, councillor, aspect, phase, physiognomy","あい, あ, い, おう, さ, さが, すけ","","ソウ, ショウ",""},
{"愛","love, affection, favourite","いと.しい, あ, あし, え, かな, まな, めぐ, めぐみ, よし","","アイ",""},
{"商","make a deal, selling, dealing in, merchant","あきな.う, あき","","ショウ",""},
{"浅","shallow, superficial, frivolous, wretched, shameful","あさ.い, あざ, さ","","セン",""},
{"預","deposit, custody, leave with, entrust to","あず.ける, あず.かる","","ヨ",""},
{"汗","sweat, perspire","あせ","","カン",""},
{"遊","play","あそ.ぶ, あそ.ばす, あす, う","","ユウ, ユ",""},
{"値","price, cost, value","ね, あたい, じ","","チ",""},
{"与","bestow, participate in, give, award, impart, provide, cause, gift, godsend","あた.える, あずか.る, くみ.する, ともに, とも, ゆ","","ヨ",""},
{"温","warm","あたた.か, あたた.かい, あたた.まる, あたた.める, ぬく, あつ, あつし, なお, はる, ゆ, ゆたか","","オン",""},
{"暖","warmth","あたた.か, あたた.かい, あたた.まる, あたた.める","","ダン, ノン",""},
{"頭","head, counter for large animals","あたま, かしら, がしら, かぶり, かみ, がみ, ちゃん, つむり, づ","","トウ, ズ, ト",""},
{"辺","environs, boundary, border, vicinity","あた.り, ほと.り, べ, なべ","","ヘン",""},
{"当","hit, right, appropriate, himself","あ.たる, あ.たり, あ.てる, あ.て, まさ.に, まさ.にべし, たい","","トウ",""},
{"圧","pressure, push, overwhelm, oppress, dominate","お.す, へ.す, おさ.える, お.さえる","","アツ, エン, オウ",""},
{"暑","sultry, hot, summer heat","あつ.い","","ショ",""},
{"熱","heat, temperature, fever, mania, passion","あつ.い, あた","","ネツ",""},
{"厚","thick, heavy, rich, kind, cordial, brazen, shameless","あつ.い, あか, あ, あっ","","コウ",""},
{"跡","tracks, mark, print, impression","あと","","セキ",""},
{"暴","outburst, rave, fret, force, violence, cruelty, outrage","あば.く, あば.れる","","ボウ, バク",""},
{"浴","bathe, be favored with, bask in","あ.びる, あ.びせる, えき, さこ","","ヨク",""},
{"危","dangerous, fear, uneasy","あぶ.ない, あや.うい, あや.ぶむ","","キ",""},
{"油","oil, fat","あぶら","","ユ, ユウ",""},
{"脂","fat, grease, tallow, lard, rosin, gum, tar","あぶら","","シ",""},
{"甘","sweet, coax, pamper, be content, sugary","あま.い, あま.える, あま.やかす, うま.い, かも","","カン",""},
{"余","too much, myself, surplus, other, remainder","あま.る, あま.り, あま.す, あまる","","ヨ",""},
{"編","compilation, knit, plait, braid, twist, editing, completed poem, part of a book","あ.む, あ.み","","ヘン",""},
{"過","overdo, exceed, go beyond, error","す.ぎる, す.ぎる, す.ぎ, す.ごす, あやま.つ, あやま.ち","","カ",""},
{"誤","mistake, err, do wrong, mislead","あやま.る, あやま.る","","ゴ",""},
{"荒","laid waste, rough, rude, wild","あら.い, あら, あ.れる, あ.らす, あ.らし, すさ.む, ら","","コウ",""},
{"洗","wash, inquire into, probe","あら.う, あらい, らい","","セン",""},
{"争","contend, dispute, argue","あらそ.う, いか.でか","","ソウ",""},
{"改","reformation, change, modify, mend, renew, examine, inspect, search","あらた.める, あらた.まる","","カイ",""},
{"表","surface, table, chart, diagram","おもて, おもて, あらわ.す, あらわ.れる, あら.わす","","ヒョウ",""},
{"現","present, existing, actual","あらわ.れる, あらわ.す, あきら, きら","","ゲン",""},
{"著","renowned, publish, write, remarkable, phenomenal, put on, don, wear, arrival, finish (race), counter for suits of clothing, literary work","あらわ.す, いちじる.しい","","チョ, チャク",""},
{"在","exist, outskirts, suburbs, located in","あ.る, あり","","ザイ",""},
{"暗","darkness, disappear, shade, informal, grow dark, be blinded","くら.い","","アン",""},
{"委","committee, entrust to, leave to, devote, discard","ゆだ.ねる, まかせ","","イ",""},
{"衣","garment, clothes, dressing","ころも, きぬ, ぎ","","イ, エ",""},
{"囲","surround, besiege, store, paling, enclosure, encircle, preserve, keep","かこ.む, かこ.う, かこ.い","","イ",""},
{"位","rank, grade, throne, crown, about, some","くらい, ぐらい, ぞき","","イ",""},
{"胃","stomach, paunch, crop, craw","","","イ",""},
{"易","easy, ready to, simple, fortune-telling, divination","やさ.しい, やす.い","","エキ, イ",""},
{"移","shift, move, change, drift, catch (cold, fire), pass into","うつ.る, うつ.す","","イ",""},
{"依","reliant, depend on, consequently, therefore, due to","よ.る, よ, より","","イ, エ",""},
{"偉","admirable, greatness, remarkable, conceited, famous, excellent","えら.い, ひで","","イ",""},
{"違","difference, differ","ちが.う, ちが.い, ちが.える, ちが.える, たが.う, たが.える","","イ",""},
{"怒","angry, be offended","いか.る, おこ.る","","ド, ヌ",""},
{"息","breath, respiration, son, interest (on money)","いき","","ソク",""},
{"域","range, region, limits, stage, level","","","イキ",""},
{"勢","forces, energy, military strength","いきお.い, はずみ, せ","","セイ, ゼイ",""},
{"幾","how many, how much, how far, how long","いく, いく.つ, いく.ら, い, く","","キ",""},
{"育","bring up, grow up, raise, rear","そだ.つ, そだ.ち, そだ.てる, はぐく.む, やす","","イク",""},
{"戦","war, battle, match","いくさ, たたか.う, おのの.く, そよぐ, わなな.く, せ","","セン",""},
{"池","pond, cistern, pool, reservoir","いけ","","チ",""},
{"勇","courage, cheer up, be in high spirits, bravery, heroism","いさ.む, お, はや","","ユウ",""},
{"石","stone","いし, いさ, いす, いわ, し, せっく, と","","セキ, シャク, コク",""},
{"泉","spring, fountain","いずみ, いず, ずい, ずみ, ぜい, ぜん, の","","セン",""},
{"忙","busy, occupied, restless","いそが.しい, せわ.しい, おそ.れる, うれえるさま","","ボウ, モウ",""},
{"板","plank, board, plate, stage","いた","","ハン, バン",""},
{"痛","pain, hurt, damage, bruise","いた.い, いた.む, いた.ましい, いた.める","","ツウ",""},
{"抱","embrace, hug, hold in arms","だ.く, いだ.く, かか.える, たば","","ホウ",""},
{"頂","place on the head, receive, top of head, top, summit, peak","いただ.く, いただき","","チョウ",""},
{"市","market, city, town","いち, い, ち","","シ",""},
{"糸","thread","いと","","シ",""},
{"営","occupation, camp, perform, build, conduct (business)","いとな.む, いとな.み","","エイ",""},
{"否","negate, no, noes, refuse, decline, deny","いな, いや","","ヒ",""},
{"命","fate, command, decree, destiny, life, appoint","いのち","","メイ, ミョウ",""},
{"祈","pray, wish","いの.る, のり, れい","","キ",""},
{"要","need, main point, essence, pivot, key to","い.る, かなめ, とし","","ヨウ",""},
{"居","reside, to be, exist, live with","い.る, い, お.る, おき, ぐ, すえ","","キョ, コ",""},
{"岩","boulder, rock, cliff","いわ","","ガン",""},
{"祝","celebrate, congratulate","いわ.う, のり, ほぎ, ゆわい","","シュク, シュウ",""},
{"引","pull, tug, jerk, admit, install, quote, refer to","ひ.く, ひ.き, ひ.き, び.き, ひ.ける, いな, ひき, ひけ, びき","","イン",""},
{"印","stamp, seal, mark, imprint, symbol, emblem, trademark, evidence, souvenir, India","しるし, じるし, しる.す","","イン",""},
{"因","cause, factor, be associated with, depend on, be limited to","よ.る, ちな.む, て","","イン",""},
{"羽","feathers, counter for birds, rabbits","は, わ, はね, しゅう, ば","","ウ",""},
{"宇","eaves, roof, house, heaven","いえ, たか, ひろ, ひろし","","ウ",""},
{"初","first time, beginning","はじ.め, はじ.めて, はつ, はつ, うい, そ.める, ぞ.め, し, はっ","","ショ",""},
{"植","plant","う.える, う.わる, うえ, え, げ","","ショク",""},
{"伺","pay respects, visit, ask, inquire, question, implore","うかが.う","","シ",""},
{"浮","floating, float, rise to surface","う.く, う.かれる, う.かぶ, む, う.かべる, うき","","フ",""},
{"受","accept, undergo, answer (phone), take, get, catch, receive","う.ける, う.け, う.かる, じょ","","ジュ",""},
{"承","acquiesce, hear, listen to, be informed, receive","うけたまわ.る, う.ける, つぐ","","ショウ",""},
{"失","lose, error, fault, disadvantage, loss","うしな.う, う.せる","","シツ",""},
{"薄","dilute, thin, weak (tea)","うす.い, うす, うす, うす.める, うす.まる, うす.らぐ, うす.ら, うす.れる, すすき","","ハク",""},
{"疑","doubt, distrust, be suspicious, question","うたが.う","","ギ",""},
{"内","inside, within, between, among, house, home","うち, いと, ただ, ち, のち","","ナイ, ダイ",""},
{"打","strike, hit, knock, pound, dozen","う.つ, う.ち, ぶ.つ, うち","","ダ, ダアス",""},
{"美","beauty, beautiful","うつく.しい, はる, よし, よしみ, り","","ビ, ミ",""},
{"器","utensil, vessel, receptacle, implement, instrument, ability, container, tool, set","うつわ","","キ",""},
{"腕","arm, ability, talent","うで","","ワン",""},
{"産","products, bear, give birth, yield, childbirth, native, property","う.む, う.まれる, うぶ, む.す, もと","","サン",""},
{"馬","horse","うま, うま, ま, た, ばん, め, も","","バ",""},
{"埋","bury, be filled up, embedded","う.める, う.まる, う.もれる, うず.める, うず.まる, い.ける","","マイ",""},
{"敬","awe, respect, honor, revere","うやま.う, け, たか, たかし, たけ, とし, のり, ひろ, ゆき, よし","","ケイ, キョウ",""},
{"裏","back, amidst, in, reverse, inside, palm, sole, rear, lining, wrong side","うら","","リ",""},
{"占","fortune-telling, divining, forecasting, occupy, hold, have, get, take","し.める, うらな.う, うら, しむ, じめ","","セン",""},
{"得","gain, get, find, earn, acquire, can, may, able to, profit, advantage, benefit","え.る, う.る, あつ, てろ","","トク",""},
{"絵","picture, drawing, painting, sketch","","","カイ, エ",""},
{"回","-times, round, game, revolve, counter for occurrences","まわ.る, まわ.る, まわ.り, まわ.す, まわ.す, まわ.し, まわ.し, もとお.る, か.える","","カイ, エ",""},
{"泳","swim","およ.ぐ","","エイ",""},
{"栄","flourish, prosperity, honor, glory, splendor","さか.える, は.え, ば.え, は.える, え, さかえ, しげ, てる, なが, ひで, よし","","エイ, ヨウ",""},
{"永","eternity, long, lengthy","なが.い, え, と, のり, ひさ, ひさし","","エイ",""},
{"鋭","pointed, sharpness, edge, weapon, sharp, violent","するど.い, とし","","エイ",""},
{"役","duty, war, campaign, drafted labor, office, service, role","ちゃく","","ヤク, エキ",""},
{"液","fluid, liquid, juice, sap, secretion","","","エキ",""},
{"枝","bough, branch, twig, limb","えだ, え, ぐさ","","シ",""},
{"越","surpass, cross over, move to, exceed, Vietnam","こ.す, こ.す, ご.し, こ.える, ご.え, えち, えっ, お, こえ, こし, ごえ, ごし, ごや","","エツ, オツ",""},
{"笑","laugh","わら.う, え.む, えみ","","ショウ",""},
{"選","elect, select, choose, prefer","えら.ぶ","","セン",""},
{"園","park, garden, yard, farm","その, おん, ぞの","","エン",""},
{"遠","distant, far","とお.い, お, おに, ど, どお","","エン, オン",""},
{"塩","salt","しお","","エン",""},
{"演","performance, act, play, render, stage","","","エン",""},
{"延","prolong, stretching","の.びる, の.べる, の.べ, の.ばす, たか, のぶ, のべ","","エン",""},
{"煙","smoke","けむ.る, けむり, けむ.い, たば","","エン",""},
{"緒","thong, beginning, inception, end, cord, strap","お, いとぐち, ほ","","ショ, チョ",""},
{"汚","dirty, pollute, disgrace, rape, defile","けが.す, けが.れる, けが.らわしい, よご.す, よご.れる, きたな.い","","オ",""},
{"和","harmony, Japanese style, peace, soften, Japan","やわ.らぐ, やわ.らげる, なご.む, なご.やか, あい, いず, かず, かつ, かつり, かづ, たけ, ち, とも, な, にぎ, まさ, やす, よし, より, わだこ, わっ","","ワ, オ, カ",""},
{"老","old man, old age, grow old","お.いる, ふ.ける, えび, おい, び","","ロウ",""},
{"負","defeat, negative, -, minus, bear, owe, assume a responsibility","ま.ける, ま.かす, お.う","","フ",""},
{"追","chase, drive away, follow, pursue, meanwhile","お.う, おい","","ツイ",""},
{"王","king, rule, magnate","おお, おおきみ, わ","","オウ, ノウ",""},
{"黄","yellow","き, こ, うい, れい","","コウ, オウ",""},
{"央","center, middle","あきら, え, お, さと, ちか, てる, なか, ひさ, ひろ, や","","オウ",""},
{"横","sideways, side, horizontal, width, woof","よこ","","オウ",""},
{"欧","Europe","うた.う, は.く, おお, ひろ","","オウ",""},
{"押","push, stop, check, subdue, attach, seize, weight, shove, press, seal, do in spite of","お.す, お.し, お.っ, お.さえる, おさ.える, おし, おす, おや","","オウ",""},
{"奥","heart, interior","おく.まる, くま, お, おお, おん, つ, のく","","オウ, オク",""},
{"犯","crime, sin, offense","おか.す","","ハン, ボン",""},
{"拝","worship, adore, pray to","おが.む, おろが.む","","ハイ",""},
{"補","supplement, supply, make good, offset, compensate, assistant, learner","おぎな.う","","ホ",""},
{"置","placement, put, set, deposit, leave behind, keep, employ, pawn","お.く, お.き, おき, おけ, き","","チ",""},
{"億","hundred million, 10**8","お","","オク",""},
{"遅","slow, late, back, later","おく.れる, おく.らす, おそ.い, じ","","チ",""},
{"贈","presents, send, give to, award to, confer on, presenting something","おく.る","","ゾウ, ソウ",""},
{"幼","infancy, childhood","おさな.い, うぶ, わか","","ヨウ",""},
{"治","reign, be at peace, calm down, subdue, quell, govt, cure, heal, rule, conserve","おさ.める, おさ.まる, なお.る, なお.す, し, ぢ, はり, はる, みち","","ジ, チ",""},
{"収","income, obtain, reap, pay, supply, store","おさ.める, おさ.まる, のぶ","","シュウ",""},
{"恐","fear, dread, awe","おそ.れる, おそ.る, おそ.ろしい, こわ.い, こわ.がる","","キョウ",""},
{"落","fall, drop, come down","お.ちる, お.ち, お.とす, おち","","ラク",""},
{"夫","husband, man","おっと, そ.れ, お, と, ゆう, よ","","フ, フウ, ブ",""},
{"訪","call on, visit, look up, offer sympathy","おとず.れる, たず.ねる, と.う, わ","","ホウ",""},
{"踊","jump, dance, leap, skip","おど.る","","ヨウ",""},
{"各","each, every, either","おのおの, かか, かが","","カク",""},
{"帯","sash, belt, obi, zone, region","お.びる, おび, たて","","タイ",""},
{"覚","memorize, learn, remember, awake, sober up","おぼ.える, さ.ます, さ.める, さと.る","","カク",""},
{"面","mask, face, features, surface","おも, おもて, つら, お, ずら, ほおつき, も","","メン, ベン",""},
{"折","fold, break, fracture, bend, yield, submit","お.る, おり, お.り, お.り, お.れる, せき","","セツ",""},
{"降","descend, precipitate, fall, surrender","お.りる, お.ろす, ふ.る, ふ.り, くだ.る, くだ.す, ふり, ふる","","コウ, ゴ",""},
{"御","honorable, manipulate, govern","おん, お, み, う","","ギョ, ゴ",""},
{"香","incense, smell, perfume","か, かお.り, かお.る, こ, こお, ひゃん, よし","","コウ, キョウ",""},
{"科","department, course, section","しな","","カ",""},
{"化","change, take the form of, influence, enchant, delude, -ization","ば.ける, ば.かす, ふ.ける, け.する","","カ, ケ",""},
{"荷","baggage, shoulder-pole load, bear (a burden), shoulder (a gun), load, cargo, freight","に, はす, り","","カ",""},
{"加","add, addition, increase, join, include, Canada","くわ.える, くわ.わる","","カ",""},
{"果","fruit, reward, carry out, achieve, complete, end, finish, succeed","は.たす, はた.す, は.たす, は.てる, は.てる, は.て, み","","カ",""},
{"貨","freight, goods, property","","","カ",""},
{"課","chapter, lesson, section, department, division, counter for chapters (of a book)","","","カ",""},
{"可","can, passable, mustn't, should not, do not","べ.き, べ.し, よし","","カ, コク",""},
{"河","river","かわ, かっ, こ, こう","","カ",""},
{"菓","candy, cakes, fruit","","","カ",""},
{"靴","shoes","くつ","","カ",""},
{"貝","shellfish","かい","","バイ",""},
{"階","storey, stair, counter for storeys of a building","きざはし, しな, と, はし","","カイ",""},
{"械","contraption, fetter, machine, instrument","かせ","","カイ",""},
{"快","cheerful, pleasant, agreeable, comfortable","こころよ.い, よし","","カイ",""},
{"解","unravel, notes, key, explanation, understanding, untie, undo, solve, answer, cancel, absolve, explain, minute","と.く, と.かす, と.ける, ほど.く, ほど.ける, わか.る, さと.る, さとる, とけ","","カイ, ゲ",""},
{"灰","ashes, puckery juice, cremate","はい","","カイ",""},
{"介","jammed in, shellfish, mediate, concern oneself with","すけ, ゆき","","カイ",""},
{"皆","all, everything","みな, みんな, むな","","カイ",""},
{"害","harm, injury","","","ガイ",""},
{"交","mingle, mixing, association, coming & going","まじ.わる, まじ.える, ま.じる, まじ.る, ま.ざる, ま.ぜる, か.う, か.わす, かわ.す, こもごも, かた","","コウ",""},
{"返","return, answer, fade, repay","かえ.す, かえ.す, かえ.る, かえ.る","","ヘン",""},
{"省","focus, government ministry, conserve","かえり.みる, はぶ.く, さとし, み","","セイ, ショウ",""},
{"変","unusual, change, strange","か.わる, か.わり, か.える","","ヘン",""},
{"替","exchange, spare, substitute, per-","か.える, か.え, か.わる, かえ","","タイ",""},
{"換","interchange, period, charge, change?","か.える, か.える, か.わる","","カン",""},
{"係","person in charge, connection, duty, concern oneself","かか.る, かかり, がかり, かか.わる","","ケイ",""},
{"掛","hang, suspend, depend, arrive at, tax, pour","か.ける, か.ける, か.け, か.け, が.け, か.かる, か.かる, が.かる, か.かり, が.かり, かかり, がかり, かけ","","カイ, ケイ",""},
{"限","limit, restrict, to best of ability","かぎ.る, かぎ.り, かぎ.り","","ゲン",""},
{"欠","lack, gap, fail","か.ける, か.く, あくび","","ケツ, ケン",""},
{"角","angle, corner, square, horn, antlers","かど, つの, い, す, すみ, ずみ, ふさ","","カク",""},
{"客","guest, visitor, customer, client","","","キャク, カク",""},
{"格","status, rank, capacity, character, case (law, grammar)","いたる, のり","","カク, コウ, キャク, ゴウ",""},
{"確","assurance, firm, tight, hard, solid, confirm, clear, evident","たし.か, たし.かめる","","カク, コウ",""},
{"革","leather, become serious, skin, hide, pelt","かわ","","カク",""},
{"額","forehead, tablet, plaque, framed picture, sum, amount, volume","ひたい, ぬか","","ガク",""},
{"賢","intelligent, wise, wisdom, cleverness","かしこ.い, かた, さか, さと, さとし, たか, たて, のり, まこと, まさ, まさる","","ケン",""},
{"数","number, strength, fate, law, figures","かず, かぞ.える, しばしば, せ.める, わずらわ.しい, じゅ","","スウ, ス, サク, ソク, シュ",""},
{"形","shape, form, style","かた, がた, かたち, なり, ち","","ケイ, ギョウ",""},
{"型","mould, type, model","かた, がた","","ケイ",""},
{"片","one-sided, leaf, sheet","かた, かた","","ヘン",""},
{"肩","shoulder","かた","","ケン",""},
{"固","harden, set, clot, curdle","かた.める, かた.まる, かた.まり, かた.い","","コ",""},
{"難","difficult, impossible, trouble, accident, defect","かた.い, がた.い, むずか.しい, むづか.しい, むつか.しい, にく.い, な, なに","","ナン",""},
{"硬","stiff, hard","かた.い","","コウ",""},
{"堅","strict, hard, solid, tough, tight, reliable","かた.い, がた.い, きん","","ケン",""},
{"傾","lean, incline, tilt, trend, wane, sink, ruin, bias","かたむ.く, かたむ.ける, かたぶ.く, かた.げる, かし.げる","","ケイ",""},
{"勝","victory, win, prevail, excel","か.つ, が.ち, まさ.る, すぐ.れる, かつ, かち, と, よし","","ショウ",""},
{"活","lively, resuscitation, being helped, living","い.きる, い.かす, い.ける","","カツ",""},
{"割","proportion, comparatively, divide, cut, separate, split","わ.る, わり, わ.り, わ.れる, さ.く","","カツ",""},
{"担","shouldering, carry, raise, bear","かつ.ぐ, にな.う","","タン",""},
{"門","gates","かど, と, じょう, も","","モン",""},
{"悲","jail cell, grieve, sad, deplore, regret","かな.しい, かな.しむ","","ヒ",""},
{"必","invariably, certain, inevitable","かなら.ず","","ヒツ",""},
{"彼","he, that, the","かれ, かの, か.の, その","","ヒ",""},
{"構","posture, build, pretend","かま.える, かま.う, とち","","コウ",""},
{"神","gods, mind, soul","かみ, かん, こう, か, かぐ, かな, かも, くま, こ, こは, だま, み","","シン, ジン",""},
{"髪","hair of the head","かみ, がた, ひげ","","ハツ",""},
{"辛","spicy, bitter, hot, acrid","から.い, つら.い, づら.い, かのと","","シン",""},
{"枯","wither, die, dry up, be seasoned","か.れる, か.らす","","コ",""},
{"絡","entwine, coil around, get caught in","から.む, から.まる","","ラク",""},
{"軽","lightly, trifling, unimportant","かる.い, かろ.やか, かろ.んじる","","ケイ",""},
{"皮","pelt, skin, hide, leather","かわ, けがわ","","ヒ",""},
{"側","side, lean, oppose, regret","かわ, がわ, そば","","ソク",""},
{"乾","drought, dry, dessicate, drink up, heaven, emperor","かわ.く, かわ.かす, ほ.す, ひ.る, いぬい","","カン, ケン",""},
{"寒","cold","さむ.い, さ, さん","","カン",""},
{"感","emotion, feeling, sensation","","","カン",""},
{"完","perfect, completion, end","","","カン",""},
{"官","bureaucrat, the government","","","カン",""},
{"管","pipe, tube, wind instrument, drunken talk","くだ, すが","","カン",""},
{"関","connection, barrier, gateway, involve, concerning","せき, ぜき, かか.わる, からくり, かんぬき","","カン",""},
{"観","outlook, look, appearance, condition, view","み.る, しめ.す","","カン",""},
{"刊","publish, carve, engrave","","","カン",""},
{"慣","accustomed, get used to, become experienced","な.れる, な.らす","","カン",""},
{"干","dry, parch","ほ.す, ほ.し, ぼ.し, ひ.る, ほし","","カン",""},
{"巻","scroll, volume, book, part, roll up, wind up, tie, coil, counter for texts (or book scrolls)","ま.く, まき, ま.き","","カン, ケン",""},
{"簡","simplicity, brevity","","","カン",""},
{"缶","tin can, container","かま, ふ, べ, ほとぎ","","カン",""},
{"患","afflicted, disease, suffer from, be ill","わずら.う, くろ","","カン",""},
{"丸","round, full, month, perfection, -ship, pills, make round, roll up, curl up, seduce, explain away","まる, まる.める, まる.い, ま, わ, わに","","ガン",""},
{"岸","beach","きし, けし","","ガン",""},
{"願","petition, request, vow, wish, hope","ねが.う, ねがい, ら","","ガン",""},
{"含","include, bear in mind, understand, cherish","ふく.む, ふく.める","","ガン",""},
{"記","scribe, account, narrative","しる.す, のり","","キ",""},
{"期","period, time, date, term","","","キ, ゴ",""},
{"希","hope, beg, request, pray, beseech, Greece, dilute (acid), rare, few, phenomenal","まれ, のぞ, のぞみ","","キ, ケ",""},
{"季","seasons","すえ, とし","","キ",""},
{"喜","rejoice, take pleasure in","よろこ.ぶ, よろこ.ばす, あき, きゅ, のぶ, ゆき, よし","","キ",""},
{"機","mechanism, opportunity, occasion, machine, airplane","はた","","キ",""},
{"規","standard, measure","すのり, ただし, のり, み","","キ",""},
{"寄","draw near, stop in, bring near, gather, collect, send, forward","よ.る, よ.り, よ.せる, よせ, より, よろ","","キ",""},
{"机","desk, table","つくえ","","キ",""},
{"議","deliberation, consultation, debate, consideration","かた, のり","","ギ",""},
{"技","skill, art, craft, ability, feat, performance, vocation, arts","わざ","","ギ",""},
{"消","extinguish, blow out, turn off, neutralize, cancel","き.える, け.す","","ショウ",""},
{"利","profit, advantage, benefit","き.く, かが, と, とし, のり, み, りい","","リ",""},
{"効","merit, efficacy, efficiency, benefit","き.く, ききめ, なら.う","","コウ",""},
{"兆","portent, 10**12, trillion, sign, omen, symptoms","きざ.す, きざ.し","","チョウ",""},
{"刻","engrave, cut fine, chop, hash, mince, time, carving","きざ.む, きざ.み","","コク",""},
{"築","fabricate, build, construct","きず.く, つい, つき, つく, づき","","チク",""},
{"競","emulate, compete with, bid, sell at auction, bout, contest, race","きそ.う, せ.る, かい, わたなべ","","キョウ, ケイ",""},
{"喫","consume, eat, drink, smoke, receive (a blow)","","","キツ",""},
{"詰","packed, close, pressed, reprove, rebuke, blame","つ.める, つ.め, づ.め, つ.まる, つ.む, ずめ, づめ","","キツ, キチ",""},
{"決","decide, fix, agree upon, appoint","き.める, ぎ.め, き.まる, さ.く","","ケツ",""},
{"君","old boy, name-suffix","きみ, ぎみ, み","","クン",""},
{"客","guest, visitor, customer, client","","","キャク, カク",""},
{"逆","inverted, reverse, opposite, wicked","さか, さか.さ, さか.らう","","ギャク, ゲキ",""},
{"級","class, rank, grade","しな","","キュウ",""},
{"球","ball, sphere","たま, く","","キュウ",""},
{"求","request, want, wish for, require, demand","もと.める","","キュウ, グ",""},
{"泣","cry, weep, moan","な.く","","キュウ",""},
{"救","salvation, save, help, rescue, reclaim","すく.う","","キュウ",""},
{"給","salary, wage, gift, allow, grant, bestow on","たま.う, たも.う, たま.え, きい","","キュウ",""},
{"久","long time, old story","ひさ.しい, きゅ, わ","","キュウ, ク",""},
{"旧","old times, old things, old friend, former, ex-","ふる.い, もと","","キュウ",""},
{"吸","suck, imbibe, inhale, sip","す.う","","キュウ",""},
{"許","permit, approve","ゆる.す, もと","","キョ",""},
{"魚","fish","うお, さかな, ざかな, い","","ギョ",""},
{"清","pure, purify, cleanse, exorcise, Manchu dynasty","きよ.い, きよ.まる, きよ.める, あき, さや, し, すが, すみ, せ, ちん","","セイ, ショウ, シン",""},
{"橋","bridge","はし, ばせ","","キョウ",""},
{"共","together, both, neither, all, and, alike, with","とも, とも.に, ども","","キョウ",""},
{"協","co-, cooperation","","","キョウ",""},
{"経","sutra, longitude, pass thru, expire, warp","へ.る, た.つ, たていと, はか.る, のり, つね, のぶ","","ケイ, キョウ",""},
{"境","boundary, border, region","さかい, さか, じき","","キョウ, ケイ",""},
{"供","submit, offer, present, serve (meal), accompany","そな.える, とも, ども","","キョウ, ク, クウ, グ",""},
{"胸","bosom, breast, chest, heart, feelings","むね, むな","","キョウ",""},
{"叫","shout, exclaim, yell","さけ.ぶ","","キョウ",""},
{"況","condition, situation","まし.て, いわ.んや, おもむき","","キョウ",""},
{"狭","cramped, narrow, contract, tight","せま.い, せば.める, せば.まる, さ, はざ","","キョウ, コウ",""},
{"挟","pinch, between","はさ.む, はさ.まる, わきばさ.む, さしはさ.む","","キョウ, ショウ",""},
{"曲","bend, music, melody, composition, pleasure, injustice, fault, curve, crooked, perverse, lean","ま.がる, ま.げる, まがた","","キョク",""},
{"局","bureau, board, office, affair, conclusion, court lady, lady-in-waiting, her apartment","つぼね","","キョク",""},
{"極","poles, settlement, conclusion, end, highest rank, electric poles, very, extremely, most, highly, 10**48","きわ.める, きわ.まる, きわ.まり, きわ.み, き.める, ぎ.め, き.まる","","キョク, ゴク",""},
{"玉","jewel, ball","たま, たま, だま, おう, だん","","ギョク",""},
{"際","occasion, side, edge, verge, dangerous, adventurous, indecent, time, when","きわ, ぎわ, わ","","サイ",""},
{"均","level, average","なら.す, ひとし","","キン",""},
{"禁","prohibition, ban, forbid","","","キン",""},
{"勤","diligence, become employed, serve","つと.める, づと.め, つと.まる, いそ.しむ","","キン, ゴン",""},
{"区","ward, district","","","ク, オウ, コウ",""},
{"苦","suffering, trial, worry, hardship, feel bitter, scowl","くる.しい, ぐる.しい, くる.しむ, くる.しめる, にが.い, にが.る","","ク",""},
{"庫","warehouse, storehouse","くら","","コ, ク",""},
{"紅","crimson, deep red","べに, くれない, あか.い, くれ, もみ","","コウ, ク",""},
{"具","tool, utensil, means, possess, ingredients, counter for armor, suits, sets of furniture","そな.える, つぶさ.に, とも","","グ",""},
{"偶","accidentally, even number, couple, man & wife, same kind","たま","","グウ",""},
{"隅","corner, nook","すみ","","グウ",""},
{"草","grass, weeds, herbs, pasture, write, draft","くさ, くさ, ぐさ, そ, や","","ソウ",""},
{"薬","medicine, chemical, enamel, gunpowder, benefit","くすり, み","","ヤク",""},
{"掘","dig, delve, excavate","ほ.る, ぼり","","クツ",""},
{"配","distribute, spouse, exile, rationing","くば.る","","ハイ",""},
{"首","neck","くび, おびと, こべ, す","","シュ",""},
{"組","association, braid, plait, construct, assemble, unite, cooperate, grapple","く.む, くみ, ぐみ","","ソ",""},
{"曇","cloudy weather, cloud up","くも.る, ど, ずみ","","ドン",""},
{"蔵","storehouse, hide, own, have, possess","くら, おさ.める, かく.れる, くらし, くらん, くろう, さし, ざ, ろう","","ゾウ, ソウ",""},
{"暮","livelihood, make a living, spend time","く.れる, く.らす, ぐらし, ぐれ, ぽ","","ボ",""},
{"比","compare, race, ratio, Philipines","くら.べる, い, ぴっ","","ヒ",""},
{"訓","instruction, Japanese character reading, explanation, read","おし.える, よ.む, くん.ずる, く, くに, くの, さとし, のり, ふみ","","クン, キン",""},
{"軍","army, force, troops, war, battle","","","グン",""},
{"群","flock, group, crowd, herd, swarm, cluster","む.れる, む.れ, むら, むら.がる, ぐり, ぐ, こお, こおり, ごうり","","グン",""},
{"毛","fur, hair, feather, down","け, めん, も","","モウ",""},
{"景","scenery, view","かげ","","ケイ",""},
{"警","admonish, commandment","いまし.める","","ケイ",""},
{"芸","technique, art, craft, performance, acting, trick, stunt","う.える, のり, わざ, き, げ, なり","","ゲイ, ウン",""},
{"迎","welcome, meet, greet","むか.える, むかえ","","ゲイ",""},
{"劇","drama, play","","","ゲキ",""},
{"血","blood","ち","","ケツ",""},
{"結","tie, bind, contract, join, organize, do up hair, fasten","むす.ぶ, ゆ.う, ゆ.わえる, ゆい, ゆう","","ケツ, ケチ",""},
{"険","precipitous, inaccessible place, impregnable position, steep place, sharp eyes","けわ.しい","","ケン",""},
{"県","prefecture","か.ける, あがた, がた","","ケン",""},
{"件","affair, case, matter, item","くだん","","ケン",""},
{"券","ticket","","","ケン",""},
{"検","examination, investigate","しら.べる","","ケン",""},
{"権","authority, power, rights","おもり, かり, はか.る","","ケン, ゴン",""},
{"軒","flats, counter for houses, eaves","のき","","ケン",""},
{"原","meadow, original, primitive, field, plain, prairie, tundra, wilderness","はら, た, ばる, ら, わた, わら","","ゲン",""},
{"減","dwindle, decrease, reduce, decline, curtail, get hungry","へ.る, へ.らす","","ゲン",""},
{"粉","flour, powder, dust","こ, こな","","フン, デシメートル",""},
{"戸","door","と, え, へ, とびらのと","","コ",""},
{"湖","lake","みずうみ, うみ, み","","コ",""},
{"個","individual, counter for articles and military units","","","コ, カ",""},
{"呼","call, call out to, invite","よ.ぶ, よぶ","","コ",""},
{"雇","employ, hire","やと.う","","コ",""},
{"互","mutually, reciprocally, together","たが.い, かたみ.に","","ゴ",""},
{"恋","romance, in love, yearn for, miss, darling","こ.う, こい, こい.しい","","レン",""},
{"濃","concentrated, thick, dark, undiluted","こ.い, の","","ノウ",""},
{"光","ray, light","ひか.る, ひかり, あき, あきら, こお, てる, ひこ, み, みつ","","コウ",""},
{"向","yonder, facing, beyond, confront, defy, tend toward, approach","む.く, む.い, む.き, む.ける, む.け, む.かう, む.かい, む.こう, む.こう, むこ, むか.い, こお, た, な, むか, むかい, むこう","","コウ",""},
{"幸","happiness, blessing, fortune","さいわ.い, さち, しあわ.せ, こ, さき, さし, さっ, とも, ひろ, みゆき, ゆ, ゆき, よし","","コウ",""},
{"港","harbor","みなと","","コウ",""},
{"好","fond, pleasing, like something","この.む, す.く, よ.い, い.い, こ, たか, とし, よし","","コウ",""},
{"航","navigate, sail, cruise, fly","わたる","","コウ",""},
{"候","climate, season, weather","そうろう","","コウ",""},
{"耕","till, plow, cultivate","たがや.す, こお","","コウ",""},
{"鉱","mineral, ore","あらがね","","コウ",""},
{"講","lecture, club, association","","","コウ",""},
{"更","grow late, night watch, sit up late, of course","さら, さら.に, ふ.ける, ふ.かす","","コウ",""},
{"肯","agreement, consent, comply with","がえんじ.る","","コウ",""},
{"郊","outskirts, suburbs, rural area","","","コウ",""},
{"号","nickname, number, item, title, pseudonym, name, call","さけ.ぶ, よびな","","ゴウ",""},
{"被","incur, cover, veil, brood over, shelter, wear, put on, be exposed (film), receiving","こうむ.る, おお.う, かぶ.る, かぶ.せる, ぎぬ","","ヒ",""},
{"声","voice","こえ, こわ","","セイ, ショウ",""},
{"超","transcend, super-, ultra-","こ.える, こ.す, まさる, わたる","","チョウ",""},
{"氷","icicle, ice, hail, freeze, congeal","こおり, ひ, こお.る, すい","","ヒョウ",""},
{"凍","frozen, congeal, refrigerate","こお.る, こご.える, こご.る, い.てる, し.みる, こおり","","トウ",""},
{"谷","valley","たに, きわ.まる, がい, がえ, がや, せ, たり, たん, や","","コク",""},
{"告","revelation, tell, inform, announce","つ.げる, い","","コク",""},
{"腰","loins, hips, waist, low wainscoting","こし, うすぐ","","ヨウ",""},
{"骨","skeleton, bone, remains, frame","ほね","","コツ",""},
{"断","severance, decline, refuse, apologize, warn, dismiss, prohibit, decision, judgement, cutting","た.つ, ことわ.る, さだ.める","","ダン",""},
{"細","dainty, get thin, taper, slender, narrow","ほそ.い, ほそ.る, こま.か, こま.かい","","サイ",""},
{"困","quandary, become distressed, annoyed","こま.る","","コン",""},
{"込","crowded, mixture, in bulk, included, (kokuji)","","","こ.む, こ.む, こ.み, こ.み, こ.める, こみ, ごめ",""},
{"米","rice, USA, metre","こめ, よね, は, べ, まべ, め, よ, よな, よの, よま","","ベイ, マイ, メエトル",""},
{"殺","kill, murder, butcher, slice off, split, diminish, reduce, spoil","ころ.す, ごろ.し, そ.ぐ","","サツ, サイ, セツ",""},
{"怖","dreadful, be frightened, fearful","こわ.い, こわ.がる, お.じる, おそ.れる","","フ, ホ",""},
{"根","root, radical, head (pimple)","ね, ね","","コン",""},
{"混","mix, blend, confuse","ま.じる, ま.じり, ま.ざる, ま.ぜる, こ.む","","コン",""},
{"婚","marriage","","","コン",""},
{"差","distinction, difference, variation, discrepancy, margin, balance","さ.す, さ.し","","サ",""},
{"査","investigate","","","サ",""},
{"砂","sand","すな, いさ, ご","","サ, シャ",""},
{"再","again, twice, second time","ふたた.び, ふた","","サイ, サ",""},
{"座","squat, seat, cushion, gathering, sit","すわ.る","","ザ",""},
{"才","genius, years old, cubic shaku","","","サイ",""},
{"祭","ritual, offer prayers, celebrate, deify, enshrine, worship","まつ.る, まつ.り, まつり","","サイ",""},
{"菜","vegetable, side dish, greens","な, よう","","サイ",""},
{"最","utmost, most, extreme","もっと.も, つま, も","","サイ, シュ",""},
{"妻","wife, spouse","つま, ずま, め","","サイ",""},
{"採","pick, take, fetch, take up","と.る","","サイ",""},
{"済","finish, come to an end, excusable, need not","す.む, ず.み, ずみ, す.まない, す.ます, す.ます, すく.う, な.す, わたし, わた.る, すむ, なり, わたる","","サイ, セイ",""},
{"歳","year-end, age, occasion, opportunity","とし, とせ, よわい","","サイ, セイ",""},
{"財","property, money, wealth, assets","たから","","ザイ, サイ, ゾク",""},
{"材","lumber, log, timber, wood, talent","き, さい","","ザイ",""},
{"罪","guilt, sin, crime, fault, blame, offense","つみ","","ザイ",""},
{"坂","slope, incline, hill","さか, か, ざ","","ハン",""},
{"酒","sake, alcohol","さけ, さか, き, さ, し","","シュ",""},
{"探","grope, search, look for","さぐ.る, さが.す","","タン",""},
{"捜","search, look for, locate","さが.す","","ソウ, シュ, シュウ",""},
{"杯","counter for cupfuls, wine glass, glass, toast","さかずき","","ハイ",""},
{"咲","blossom, bloom","さ.く, ざき, さ, さき","","ショウ",""},
{"昨","yesterday, previous","","","サク",""},
{"冊","tome, counter for books, volume","ふみ","","サツ, サク",""},
{"支","branch, support, sustain","ささ.える, つか.える, か.う, しんよう, じゅうまた","","シ",""},
{"刺","thorn, pierce, stab, prick, sting, calling card","さ.す, さ.さる, さ.し, さし, とげ","","シ",""},
{"指","finger, point to, indicate, put into, play (chess), measure (ruler)","ゆび, さ.す, さ.し, い, いぶ, さし, さす","","シ",""},
{"定","determine, fix, establish, decide","さだ.める, さだ.まる, さだ.か, さた","","テイ, ジョウ",""},
{"札","tag, paper money, counter for bonds, placard, bid","ふだ, さっ","","サツ",""},
{"刷","printing, print","す.る, ず.り, ずり, は.く","","サツ",""},
{"察","guess, presume, surmise, judge, understand","","","サツ",""},
{"雑","miscellaneous","まじ.える, まじ.る","","ザツ, ゾウ",""},
{"様","Esq., way, manner, situation, polite suffix","さま, さん","","ヨウ, ショウ",""},
{"冷","cool, cold (beer, person), chill","つめ.たい, ひ.える, ひ.や, ひ.ややか, ひ.やす, ひ.やかす, さ.める, さ.ます","","レイ",""},
{"皿","dish, a helping, plate","さら","","ベイ",""},
{"触","contact, touch, feel, hit, proclaim, announce, conflict","ふ.れる, さわ.る, さわ","","ショク",""},
{"算","calculate, divining, number, abacus, probability","そろ","","サン",""},
{"参","nonplussed, three, going, coming, visiting, visit, be defeated, die, be madly in love","まい.る, まい, まじわる, みつ, み","","サン, シン",""},
{"散","scatter, disperse, spend, squander","ち.る, ち.らす, ち.らす, ち.らかす, ち.らかる, ばら, ちる","","サン",""},
{"賛","approve, praise, title or inscription on picture, assist, agree with","たす.ける, たた.える","","サン",""},
{"残","remainder, leftover, balance","のこ.る, のこ.す, そこな.う, のこ.り","","ザン, サン",""},
{"次","next, order, sequence","つ.ぐ, つぎ, き, すき, つぐ, よし","","ジ, シ",""},
{"歯","tooth, cog","よわい, は, よわ.い, よわい.する","","シ",""},
{"史","history, chronicle","あきら, あや, お, こ, ちか, とし, なか, のぶ, ひさ, ひと, ふみ","","シ",""},
{"示","show, indicate, point out, express, display","しめ.す","","ジ, シ",""},
{"師","expert, teacher, master, army, war","のし, のり, もろ","","シ",""},
{"資","assets, resources, capital, funds, data, be conducive to, contribute to","すけ, もと","","シ",""},
{"詞","part of speech, words, poetry","","","シ",""},
{"誌","document, records","","","シ",""},
{"路","path, route, road, distance","じ, みち","","ロ, ル",""},
{"耳","ear","みみ, がみ","","ジ",""},
{"寺","Buddhist temple","てら","","ジ",""},
{"児","newborn babe, child, young of animals","こ, こ, っこ, る","","ジ, ニ, ゲイ",""},
{"辞","resign, word, term, expression","や.める, いな.む","","ジ",""},
{"似","becoming, resemble, counterfeit, imitate, suitable","に.る, ひ.る, にた","","ジ",""},
{"除","exclude, division (x/3), remove, abolish, cancel, except","のぞ.く, よ.け","","ジョ, ジ",""},
{"式","style, ceremony, rite, function, method, system, form, expression","のり","","シキ",""},
{"識","discriminating, know, write","さと, さとる","","シキ",""},
{"直","straightaway, honesty, frankness, fix, repair","ただ.ちに, なお.す, なお.す, なお.る, なお.き, す.ぐ, すぐ, なお, のう, のお","","チョク, ジキ, ジカ",""},
{"静","quiet","しず, しず.か, しず.まる, しず.める, しづ","","セイ, ジョウ",""},
{"滴","drip, drop","しずく, したた.る","","テキ",""},
{"沈","sink, be submerged, subside, be depressed, aloes","しず.む, しず.める, しん","","チン, ジン",""},
{"湿","damp, wet, moist","しめ.る, しめ.す, うるお.う, うるお.す","","シツ, シュウ",""},
{"実","reality, truth","み, みの.る, まこと, まことに, みの, みち.る, ぐみ, さね","","ジツ, シツ",""},
{"島","island","しま","","トウ",""},
{"閉","closed, shut","と.じる, と.ざす, し.める, し.まる, た.てる, へ","","ヘイ",""},
{"捨","discard, throw away, abandon, resign, reject, sacrifice","す.てる","","シャ",""},
{"昔","once upon a time, antiquity, old times","むかし","","セキ, シャク",""},
{"弱","weak, frail","よわ.い, よわ.る, よわ.まる, よわ.める","","ジャク",""},
{"若","young, if, perhaps, possibly, low number, immature","わか.い, わか, も.しくわ, も.し, も.しくは, わく, わこ","","ジャク, ニャク, ニャ",""},
{"守","guard, protect, defend, obey","まも.る, まも.り, もり, もり, かみ, う, し, も, て","","シュ, ス",""},
{"取","take, fetch, take up","と.る, と.り, と.り, とり, ど.り, どる","","シュ",""},
{"種","species, kind, class, variety, seed","たね, ぐさ, おい, くさ, た, ほ","","シュ",""},
{"州","state, province","す, くに","","シュウ, ス",""},
{"拾","pick up, gather, find, go on foot, ten","ひろ.う","","シュウ, ジュウ",""},
{"周","circumference, circuit, lap","まわ.り, あまね, しゅ, す, ちか, のり, ひろ, びび, まこと","","シュウ",""},
{"船","ship, boat","ふね, ふな, ふ","","セン",""},
{"柔","tender, weakness, gentleness, softness","やわ.らか, やわ.らかい, やわ, やわ.ら, とお","","ジュウ, ニュウ",""},
{"宿","inn, lodging, relay station, dwell, lodge, be pregnant, home, dwelling","やど, やど.る, やど.す, すく, ぶすき, やけ","","シュク",""},
{"述","mention, state, speak, relate","の.べる","","ジュツ",""},
{"術","art, technique, skill, means, trick, resources, magic","すべ","","ジュツ",""},
{"順","obey, order, turn, right, docility, occasion","あや, あり, おき, おさむ, しげ, したがう, とし, なお, のぶ, のり, まさ, むね, もと, ゆき, よし, より","","ジュン",""},
{"準","semi-, correspond to, proportionate to, conform, imitate","じゅん.じる, じゅん.ずる, なぞら.える, のり, ひと.しい, みずもり","","ジュン",""},
{"純","genuine, purity, innocence, net (profit)","あつ, すみ, み, やすし, よし","","ジュン",""},
{"所","place","ところ, ところ, どころ, とこ, せ","","ショ",""},
{"処","dispose, manage, deal with, sentence, condemn, act, behave, place","ところ, こ, お.る","","ショ",""},
{"署","signature, govt office, police station","","","ショ",""},
{"諸","various, many, several, together","もろ","","ショ",""},
{"助","help, rescue, assist","たす.ける, たす.かる, す.ける, すけ","","ジョ",""},
{"章","badge, chapter, composition, poem, design","あき, あきら, あや, ふみ","","ショウ",""},
{"焼","bake, burning","や.く, や.き, や.き, や.き, や.ける, やい, やき","","ショウ",""},
{"象","elephant, pattern after, imitate, image, shape, sign (of the times)","かたど.る, きさ","","ショウ, ゾウ",""},
{"照","illuminate, shine, compare, bashful","て.る, て.らす, て.れる, あき, てる","","ショウ",""},
{"賞","prize, reward, praise","ほ.める","","ショウ",""},
{"招","beckon, invite, summon, engage","まね.く","","ショウ",""},
{"性","sex, gender, nature","さが","","セイ, ショウ",""},
{"将","leader, commander, general, admiral, or, and again, soon, from now on, just about","まさ.に, はた, まさ, ひきい.る, もって, かつ, かつり, すすむ, たか, ゆき","","ショウ, ソウ",""},
{"装","attire, dress, pretend, disguise, profess","よそお.う, よそお.い","","ソウ, ショウ",""},
{"召","seduce, call, send for, wear, put on, ride in, buy, eat, drink, catch (cold)","め.す","","ショウ",""},
{"床","bed, floor, padding, tatami","とこ, ゆか","","ショウ",""},
{"姓","surname","","","セイ, ショウ",""},
{"昇","rise up","のぼ.る, しゅう, のり","","ショウ",""},
{"紹","introduce, inherit, help","つぐ","","ショウ",""},
{"星","star, spot, dot, mark","ほし, ぼし","","セイ, ショウ",""},
{"政","politics, government","まつりごと, まん, ただ, まさ","","セイ, ショウ",""},
{"精","refined, ghost, fairy, energy, vitality, semen, excellence, purity, skill","きよ","","セイ, ショウ, シヤウ",""},
{"乗","ride, power, multiplication, record, counter for vehicles, board, mount, join","の.る, の.り, の.せる, のり","","ジョウ, ショウ",""},
{"状","status quo, conditions, circumstances, form, appearance","","","ジョウ",""},
{"常","usual, ordinary, normal, regular","つね, とこ, とき, のぶ, ひ, ひた","","ジョウ",""},
{"情","feelings, emotion, passion, sympathy, circumstances, facts","なさ.け","","ジョウ, セイ",""},
{"城","castle","しろ, いく, がき, き, くに, ぐしく, ぐすく, しき, すく, ぜい, たち, なり","","ジョウ",""},
{"蒸","steam, heat, sultry, foment, get musty","む.す, む.れる, む.らす","","ジョウ, セイ",""},
{"畳","tatami mat, counter for tatami mats, fold, shut up, do away with","たた.む, たたみ, かさ.なる","","ジョウ, チョウ",""},
{"成","turn into, become, get, grow, elapse, reach","な.る, な.す, な.す, あき, あきら, しげ, そん, たえ, なお, なり, なる, のり, ひら, まさ, よし, り","","セイ, ジョウ",""},
{"職","post, employment, work","もと","","ショク, ソク",""},
{"調","tune, tone, meter, key (music), writing style, prepare, exorcise, investigate","しら.べる, しら.べ, ととの.う, ととの.える, ぎ, つぎ","","チョウ",""},
{"退","retreat, withdraw, retire, resign, repel, expel, reject","しりぞ.く, しりぞ.ける, ひ.く, の.く, の.ける, ど.く","","タイ",""},
{"森","forest, woods","もり, もと","","シン",""},
{"申","have the honor to, sign of the monkey, 3-5PM, ninth sign of Chinese zodiac","もう.す, もう.し, さる","","シン",""},
{"身","somebody, person, one's station in life","み","","シン",""},
{"深","deep, heighten, intensify, strengthen","ふか.い, ぶか.い, ふか.まる, ふか.める, み","","シン",""},
{"進","advance, proceed, progress, promote","すす.む, すす.める, のぶ","","シン",""},
{"臣","retainer, subject","おみ, たか, と, とみ, み","","シン, ジン",""},
{"信","faith, truth, fidelity, trust","し, しが, しな, しの, しぶ, とき, のび, のぶ, まこと","","シン",""},
{"針","needle, pin, staple, stinger","はり, は","","シン",""},
{"伸","expand, stretch, extend, lengthen, increase","の.びる, の.ばす, の.べる, の.す, のぶ, よぼる","","シン",""},
{"寝","lie down, sleep, rest, bed, remain unsold","ね.る, ね.かす, い.ぬ, みたまや, や.める","","シン",""},
{"震","quake, shake, tremble, quiver, shiver","ふる.う, ふる.える","","シン",""},
{"吹","blow, breathe, puff, emit, smoke","ふ.く, ふき","","スイ",""},
{"末","end, close, tip, powder, posterity","すえ","","マツ, バツ",""},
{"優","tenderness, excel, surpass, actor, superiority, gentleness","やさ.しい, すぐ.れる, まさ.る, ゆ, よし","","ユウ, ウ",""},
{"涼","refreshing, nice and cool","すず.しい, すず.む, すず.やか, うす.い, ひや.す, まことに, りょ","","リョウ",""},
{"炭","charcoal, coal","すみ","","タン",""},
{"速","quick, fast","はや.い, はや, はや.める, すみ.やか, わ","","ソク",""},
{"背","stature, height, back, behind, disobey, defy, go back on, rebel","せ, せい, そむ.く, そむ.ける","","ハイ",""},
{"晴","clear up","は.れる, は.れ, は.れ, ば.れ, は.らす, はる, はれ","","セイ",""},
{"制","system, law, rule","","","セイ",""},
{"製","made in..., manufacture","...","","セイ..",""},
{"税","tax, duty","さい","","ゼイ",""},
{"説","rumor, opinion, theory","と.く, さとし, とき","","セツ, ゼイ",""},
{"席","seat, mat, occasion, place","むしろ","","セキ",""},
{"積","volume, product (x*y), acreage, contents, pile up, stack, load, amass","つ.む, づ.み, つ.もる, つ.もり, か, さか, しゃこ, ずみ, つみ","","セキ",""},
{"責","blame, condemn, censure","せ.める","","セキ",""},
{"績","exploits, unreeling cocoons","み","","セキ",""},
{"隻","vessels, counter for ships, fish, birds, arrows, one of a pair","","","セキ",""},
{"籍","enroll, domiciliary register, membership","","","セキ",""},
{"雪","snow","ゆき, せっ, ぶき","","セツ",""},
{"設","establishment, provision, prepare","もう.ける, した","","セツ",""},
{"接","touch, contact, adjoin, piece together","つ.ぐ","","セツ, ショウ",""},
{"絶","discontinue, beyond, sever, cut off, abstain, interrupt, suppress","た.える, た.やす, た.つ","","ゼツ",""},
{"線","line, track","すじ","","セン",""},
{"専","specialty, exclusive, mainly, solely","もっぱ.ら","","セン",""},
{"全","whole, entire, all, complete, fulfill","まった.く, すべ.て, たけ, まさ","","ゼン",""},
{"然","sort of thing, so, if so, in that case, well","しか, しか.り, しか.し, さ","","ゼン, ネン",""},
{"祖","ancestor, pioneer, founder","い","","ソ",""},
{"想","concept, think, idea, thought","おも.う","","ソウ, ソ",""},
{"総","general, whole, all, full, total","す.べて, すべ.て, ふさ, うさ, ずさ","","ソウ",""},
{"窓","window, pane","まど, てんまど, けむだし","","ソウ, ス",""},
{"層","stratum, social class, layer, story, floor","","","ソウ",""},
{"双","pair, set, comparison, counter for pairs","ふた, たぐい, ならぶ, ふたつ, ふ","","ソウ",""},
{"掃","sweep, brush","は.く, か","","ソウ, シュ",""},
{"燥","parch, dry up","はしゃ.ぐ","","ソウ",""},
{"造","create, make, structure, physique","つく.る, つく.り, づく.り, ずくり, づくり, み","","ゾウ",""},
{"増","increase, add, augment, gain, promote","ま.す, ま.し, ふ.える, ふ.やす, まし, ます","","ゾウ",""},
{"像","statue, picture, image, figure, portrait","かた","","ゾウ",""},
{"臓","entrails, viscera, bowels","はらわた","","ゾウ",""},
{"憎","hate, detest","にく.む, にく.い, にく.らしい, にく.しみ","","ゾウ",""},
{"束","bundle, sheaf, ream, tie in bundles, govern, manage, control","たば, たば.ねる, つか, つか.ねる","","ソク",""},
{"則","rule, follow, based on, model after","のっと.る, のり","","ソク",""},
{"測","fathom, plan, scheme, measure","はか.る","","ソク",""},
{"続","continue, series, sequel","つづ.く, つづ.ける, つぐ.ない, つぐ","","ゾク, ショク, コウ, キョウ",""},
{"底","bottom, sole, depth, bottom price, base, kind, sort","そこ","","テイ",""},
{"損","damage, loss, disadvantage, hurt, injure","そこ.なう, そこな.う, そこ.なう, そこ.ねる, そこ.ねる","","ソン",""},
{"卒","graduate, soldier, private, die","そっ.する, お.える, お.わる, ついに, にわか","","ソツ, シュツ",""},
{"率","ratio, rate, proportion, %, coefficient, factor","ひき.いる","","ソツ, リツ, シュツ",""},
{"備","equip, provision, preparation","そな.える, そな.わる, つぶさ.に, びっ, びん","","ビ",""},
{"反","anti-","そ.る, そ.らす, かえ.す, かえ.る, かえ.る, そり, た","","ハン, ホン, タン, ホ",""},
{"村","town, village","むら, え, むた, ら","","ソン",""},
{"孫","grandchild, descendants","まご, ひ","","ソン",""},
{"存","suppose, be aware of, believe, feel","まさ","","ソン, ゾン",""},
{"尊","revered, valuable, precious, noble, exalted","たっと.い, とうと.い, たっと.ぶ, とうと.ぶ, さだ, たか, たけ, みこと","","ソン",""},
{"太","plump, thick, big around","ふと.い, ふと.る, おお, たか, ひろ","","タイ, タ",""},
{"袋","sack, bag, pouch","ふくろ, てい, ない, ぶく","","タイ, ダイ",""},
{"第","No., residence","","","ダイ, テイ",""},
{"平","even, flat, peace","たい.ら, だいら, ひら, ひら, たいら, たら, はち, ひ, ひとし, へ, へん","","ヘイ, ビョウ, ヒョウ",""},
{"倒","overthrow, fall, collapse, drop, break down","たお.れる, だお.れ, たお.す","","トウ",""},
{"宝","treasure, wealth, valuables","たから, ほ","","ホウ",""},
{"宅","home, house, residence, our house, my husband","け, たか, たけ, や, やけ","","タク",""},
{"濯","laundry, wash, pour on, rinse","すす.ぐ, ゆす.ぐ","","タク",""},
{"竹","bamboo","たけ, たか","","チク",""},
{"達","accomplished, reach, arrive, attain","たち, かつ, さと, て, てつ, とおる, みち","","タツ, ダ",""},
{"例","example, custom, usage, precedent","たと.える","","レイ",""},
{"頼","trust, request","たの.む, たの.もしい, たよ.る, よち, より","","ライ",""},
{"卵","egg, ovum, spawn, roe","たまご","","ラン",""},
{"民","people, nation, subjects","たみ, ひと, み","","ミン",""},
{"便","convenience","たよ.り","","ベン, ビン",""},
{"短","short, brevity, fault, defect, weak point","みじか.い","","タン",""},
{"単","simple, one, single, merely","ひとえ","","タン",""},
{"談","discuss, talk","","","ダン",""},
{"段","grade, steps, stairs","","","ダン, タン",""},
{"乳","milk, breasts","ちち, ち","","ニュウ",""},
{"恥","shame, dishonor","は.じる, はじ, は.じらう, は.ずかしい","","チ",""},
{"畜","livestock, domestic fowl and animals","","","チク",""},
{"虫","insect, bug, temper","むし, む","","チュウ, キ",""},
{"柱","pillar, post, cylinder, support","はしら","","チュウ",""},
{"仲","go-between, relationship","なか, ちゅん, つづき, なかつ","","チュウ",""},
{"宙","mid-air, air, space, sky, memorization, interval of time","ひろ, ゆ","","チュウ",""},
{"駐","stop-over, reside in, resident","","","チュウ",""},
{"貯","savings, store, lay in, keep, wear mustache","た.める, たくわ.える","","チョ",""},
{"庁","government office","やくしょ","","チョウ, テイ",""},
{"珍","rare, curious, strange","めずら.しい, たから, じん","","チン",""},
{"都","metropolis, capital","みやこ, くに, ず, ち, づめ, みや","","ト, ツ",""},
{"費","expense, cost, spend, consume, waste","つい.やす, つい.える","","ヒ",""},
{"捕","catch, capture","と.らえる, と.らわれる, と.る, とら.える, とら.われる, つか.まえる, つか.まる","","ホ",""},
{"疲","exhausted, tire, weary","つか.れる, づか.れ, つか.らす","","ヒ",""},
{"付","adhere, attach, refer to, append","つ.ける, つ.ける, づ.ける, つ.け, つ.け, つ.け, づ.け, づけ, つ.く, づ.く, つ.き, つ.き, つき, づ.き, づき, つけ","","フ",""},
{"突","stab, protruding, thrusting, thrust, pierce, prick","つ.く","","トツ, カ",""},
{"包","wrap, pack up, cover, conceal","つつ.む, くる.む, お, かね","","ホウ",""},
{"努","toil, diligent, as much as possible","つと.める","","ド",""},
{"務","task, duties","つと.める, つかさ, み","","ム",""},
{"募","recruit, campaign, gather (contributions), enlist, grow violent","つの.る","","ボ",""},
{"粒","grains, drop, counter for tiny particles","つぶ","","リュウ",""},
{"連","take along, lead, join, connect, party, gang, clique","つら.なる, つら.ねる, つ.れる, づ.れ, ずれ, つれ, むらじ, れ","","レン",""},
{"庭","courtyard, garden, yard","にわ, ば","","テイ",""},
{"低","lower, short, humble","ひく.い, ひく.める, ひく.まる","","テイ",""},
{"停","halt, stopping","と.める, と.まる","","テイ",""},
{"程","extent, degree, law, formula, distance, limits, amount","ほど, ほど, ほと","","テイ",""},
{"泥","mud, mire, adhere to, be attached to","どろ, ひじ","","デイ, ナイ, デ, ニ",""},
{"的","bull's eye, mark, target, object, adjective ending","まと, いくは, ゆくは","","テキ",""},
{"適","suitable, occasional, rare, qualified, capable","かな.う","","テキ",""},
{"鉄","iron","くろがね, けん, てっ","","テツ",""},
{"点","spot, point, mark, speck, decimal point","つ.ける, つ.く, た.てる, さ.す, とぼ.す, とも.す, ぼち","","テン",""},
{"殿","Mr., hall, mansion, palace, temple, lord","との, どの, て, どん","","デン, テン",""},
{"登","ascend, climb up","のぼ.る, あ.がる, たか, のぼし, のぼり, のり","","トウ, ト, ドウ, ショウ, チョウ",""},
{"徒","junior, emptiness, vanity, futility, uselessness, ephemeral thing, gang, set, party, people","いたずら, あだ, かち","","ト",""},
{"途","route, way, road","みち","","ト",""},
{"渡","transit, ford, ferry, cross, import, deliver, diameter, migrate","わた.る, わた.る, わた.す, お, たり, わたな, わたら, わたり","","ト",""},
{"塗","paint, plaster, daub, smear, coating","ぬ.る, ぬ.り, まみ.れる","","ト",""},
{"投","throw, discard, abandon, launch into, join, invest in, hurl, give up, sell at a loss","な.げる, な.げ","","トウ",""},
{"等","etc., and so forth, class (first), quality, equal, similar","ひと.しい, など, ら, と, ひ","","トウ",""},
{"湯","hot water, bath, hot spring","ゆ","","トウ",""},
{"灯","lamp, a light, light, counter for lights","ひ, ほ, ともしび, とも.す, あかり","","トウ",""},
{"党","party, faction, clique","なかま, むら","","トウ",""},
{"到","arrival, proceed, reach, attain, result in","いた.る","","トウ",""},
{"逃","escape, flee, shirk, evade, set free","に.げる, に.がす, のが.す, のが.れる","","トウ",""},
{"盗","steal, rob, pilfer","ぬす.む, ぬす.み","","トウ",""},
{"筒","cylinder, pipe, tube, gun barrel, sleeve","つつ","","トウ",""},
{"塔","pagoda, tower, steeple","","","トウ",""},
{"童","juvenile, child","わらべ, ぱ","","ドウ",""},
{"働","work, (kokuji)","はたら.く","","ドウ, リュク, リキ, ロク, リョク",""},
{"銅","copper","あかがね","","ドウ",""},
{"導","guidance, leading, conduct, usher","みちび.く, みち","","ドウ",""},
{"溶","melt, dissolve, thaw","と.ける, と.かす, と.く","","ヨウ",""},
{"毒","poison, virus, venom, germ, harm, injury, spite","","","ドク",""},
{"独","single, alone, spontaneously, Germany","ひと.り, どいつ, どっ","","ドク, トク",""},
{"届","deliver, reach, arrive, report, notify, forward","とど.ける, とど.け, とど.く","","カイ",""},
{"飛","fly, skip (pages), scatter","と.ぶ, と.ばす, と.ばす, あす, とび","","ヒ",""},
{"留","detain, fasten, halt, stop","と.める, と.まる, とど.める, とど.まる, るうぶる, とめ","","リュウ, ル",""},
{"泊","overnight, put up at, ride at anchor, 3-day stay","と.まる, と.める, とまり, はつ","","ハク",""},
{"富","wealth, enrich, abundant","と.む, とみ, と, とん, ふっ","","フ, フウ",""},
{"鈍","dull, slow, foolish, blunt","にぶ.い, にぶ.る, にぶ, なま.る, なまく.ら","","ドン",""},
{"無","nothingness, none, ain't, nothing, nil, not","な.い","","ム, ブ",""},
{"亡","deceased, the late, dying, perish","な.い, な.き, ほろ.びる, ほろ.ぶ, ほろ.ぼす","","ボウ, モウ",""},
{"流","current, a sink, flow, forfeit","なが.れる, なが.れ, なが.す, なが.す, な, ながれ, めぐる","","リュウ, ル",""},
{"鳴","chirp, cry, bark, sound, ring, echo, honk","な.く, な.る, な.らす, なり, なる","","メイ",""},
{"波","waves, billows, Poland","なみ, ひら, みな, みなみ, わ","","ハ",""},
{"並","row, and, besides, as well as, line up, rank with, rival, equal","な.み, なら.べる, なら.ぶ, なら.びに, なび","","ヘイ, ホウ",""},
{"涙","tears, sympathy","なみだ","","ルイ, レイ",""},
{"悩","trouble, worry, in pain, distress, illness","なや.む, なや.ます, なや.ましい, なやみ","","ノウ",""},
{"軟","soft","やわ.らか, やわ.らかい","","ナン",""},
{"任","responsibility, duty, term, entrust to, appoint","まか.せる, まか.す, さ, とう, ひで","","ニン",""},
{"認","acknowledge, witness, discern, recognize, appreciate, believe","みと.める, したた.める","","ニン",""},
{"抜","slip out, extract, pull out, pilfer, quote, remove, omit","ぬ.く, ぬ.く, ぬ.き, ぬ.ける, ぬ.かす, ぬ.かる, ぬき","","バツ, ハツ, ハイ",""},
{"布","linen, cloth","ぬの, う, の, ほ","","フ",""},
{"猫","cat","ねこ","","ビョウ",""},
{"眠","sleep, die, sleepy","ねむ.る, ねむ.い, ね","","ミン",""},
{"練","practice, gloss, train, drill, polish, refine","ね.る, ね.り, ねり","","レン",""},
{"念","wish, sense, idea, thought, feeling, desire, attention","","","ネン",""},
{"燃","burn, blaze, glow","も.える, も.やす, も.す","","ネン",""},
{"農","agriculture, farmers","な, の, み","","ノウ",""},
{"能","ability, talent, skill, capacity","よ.く, たか, の, のり, よし","","ノウ",""},
{"脳","brain, memory","のうずる","","ノウ, ドウ",""},
{"望","ambition, full moon, hope, desire, aspire to, expect","のぞ.む, もち, み, も","","ボウ, モウ",""},
{"葉","leaf, plane, lobe, needle, blade, spear, counter for flat things, fragment, piece","は, よ, わ","","ヨウ",""},
{"破","rend, rip, tear, break, destroy, defeat, frustrate","やぶ.る, やぶ.れる, わ","","ハ",""},
{"敗","failure, defeat, reversal","やぶ.れる","","ハイ",""},
{"倍","double, twice, times, fold","べ, ます","","バイ",""},
{"量","quantity, measure, weight, amount, consider, estimate, surmise","はか.る, かず","","リョウ",""},
{"麦","barley, wheat","むぎ","","バク",""},
{"爆","bomb, burst open, pop, split","は.ぜる","","バク",""},
{"箱","box, chest, case, bin, railway car","はこ","","ソウ",""},
{"畑","farm, field, garden, one's specialty, (kokuji)","","","はた, はたけ, ばたけ, かま, まま",""},
{"肌","texture, skin, body, grain","はだ","","キ",""},
{"法","method, law, rule, principle, model, system","のり, ほ","","ホウ, ハッ, ホッ, フラン",""},
{"鼻","nose, snout","はな","","ビ",""},
{"放","set free, release, fire, shoot, emit, banish, liberate","はな.す, っぱな.し, はな.つ, はな.れる, こ.く, ほう.る, はなれ","","ホウ",""},
{"幅","hanging scroll, width","はば","","フク",""},
{"林","grove, forest","はやし, し","","リン",""},
{"腹","abdomen, belly, stomach","はら","","フク",""},
{"払","pay, clear out, prune, banish, dispose of","はら.う, はら.い, ばら.い, はらい","","フツ, ヒツ, ホツ",""},
{"判","judgement, signature, stamp, seal","わか.る","","ハン, バン",""},
{"版","printing block, printing plate, edition, impression, label","","","ハン",""},
{"般","carrier, carry, all","","","ハン",""},
{"販","marketing, sell, trade","","","ハン",""},
{"番","turn, number in a series","つが.い, は, ま","","バン",""},
{"晩","nightfall, night","","","バン",""},
{"非","un-, mistake, negative, injustice, non-","あら.ず","","ヒ",""},
{"匹","equal, head, counter for small animals, roll of cloth","ひき","","ヒツ",""},
{"筆","writing brush, writing, painting brush, handwriting","ふで, くし","","ヒツ",""},
{"兵","soldier, private, troops, army, warfare, strategy, tactics","つわもの, へ","","ヘイ, ヒョウ",""},
{"秒","second (1/60 minute)","","","ビョウ",""},
{"貧","poverty, poor","まず.しい","","ヒン, ビン",""},
{"瓶","flower pot, bottle, vial, jar, jug, vat, urn","かめ, へい, べ, ぺ","","ビン",""},
{"府","borough, urban prefecture, govt office, representative body, storehouse","い, う, お, はん","","フ",""},
{"婦","lady, woman, wife, bride","ね","","フ",""},
{"符","token, sign, mark, tally, charm","","","フ",""},
{"普","universal, wide(ly), generally, Prussia","あまね.く, あまねし, しん, ひろ","","フ",""},
{"膚","skin, body, grain, texture, disposition","はだ","","フ",""},
{"部","section, bureau, dept, class, copy, part, portion, counter for copies of a newspaper or magazine","べ, とり, ふ, ぺ, ま","","ブ",""},
{"武","warrior, military, chivalry, arms","たけ.し, う, お, たけし, たけん, ん","","ブ, ム",""},
{"舞","dance, flit, circle, wheel","ま.う, ま.う, まい","","ブ",""},
{"封","seal, closing","","","フウ, ホウ",""},
{"福","blessing, fortune, luck, wealth","とし, とみ, ふ, ふき, ふっ, ぼく, よし","","フク",""},
{"副","vice-, duplicate, copy","そい, そえ","","フク",""},
{"復","restore, return to, revert, resume","また","","フク",""},
{"複","duplicate, double, compound, multiple","","","フク",""},
{"防","ward off, defend, protect, resist","ふせ.ぐ, あた, う, ほう","","ボウ",""},
{"沸","seethe, boil, ferment, uproar, breed","わ.く, わ.かす","","フツ",""},
{"仏","Buddha, the dead, France","ほとけ","","ブツ, フツ",""},
{"報","report, news, reward, retribution","むく.いる","","ホウ",""},
{"豊","bountiful, excellent, rich","ゆた.か, とよ, て, で, と, ひろし, ふう, ぶん, ほ, ゆたか","","ホウ, ブ",""},
{"貿","trade, exchange","","","ボウ",""},
{"忘","forget","わす.れる","","ボウ",""},
{"棒","rod, stick, cane, pole, club, line","","","ボウ",""},
{"坊","boy, priest's residence, priest","","","ボウ, ボッ",""},
{"帽","cap, headgear","ずきん, おお.う","","ボウ, モウ",""},
{"欲","longing, covetousness, greed, passion, desire, craving","ほっ.する, ほ.しい","","ヨク",""},
{"磨","grind, polish, scour, improve, brush (teeth)","みが.く, す.る, おさむ","","マ",""},
{"枚","sheet of..., counter for flat thin objects or sheets","ひら..","","マイ, バイ..",""},
{"迷","astray, be perplexed, in doubt, lost, err, illusion","まよ.う","","メイ",""},
{"満","full, enough, pride, satisfy","み.ちる, み.つ, み.たす, ま, みち, みつ, みつる","","マン, バン",""},
{"未","un-, not yet, hitherto, still, even now, sign of the ram, 1-3PM, eighth sign of Chinese zodiac","いま.だ, ま.だ, ひつじ","","ミ, ビ",""},
{"乱","riot, war, disorder, disturb","みだ.れる, みだ.る, みだ.す, みだ, おさ.める, わた.る, ら","","ラン, ロン",""},
{"緑","green","みどり","","リョク, ロク",""},
{"夢","dream, vision, illusion","ゆめ, ゆめ.みる, くら.い","","ム, ボウ",""},
{"娘","daughter, girl","むすめ, こ","","ジョウ",""},
{"綿","cotton","わた, う","","メン",""},
{"戻","re-, return, revert, resume, restore, go backwards","もど.す, もど.る","","レイ",""},
{"約","promise, approximately, shrink","","","ヤク",""},
{"由","wherefore, a reason","よし, よ.る","","ユ, ユウ, ユイ",""},
{"輸","transport, send, be inferior","","","ユ, シュ",""},
{"郵","mail, stagecoach stop","","","ユウ",""},
{"予","beforehand, previous, myself, I","あらかじ.め","","ヨ, シャ",""},
{"良","good, pleasing, skilled","よ.い, よ.い, い.い, い.い, じ, なが, まこと, よし, ら, りょ, ろう","","リョウ",""},
{"陽","sunshine, yang principle, positive, male, heaven, daytime","ひ, あき, あきら, あけ, はる, ひろ, やん, よ","","ヨウ",""},
{"容","contain, form, looks","い.れる, かた, ひろ, まさ","","ヨウ",""},
{"翌","the following, next","","","ヨク",""},
{"礼","salute, bow, ceremony, thanks, remuneration","あや, なり, のり, ひろし, れ","","レイ, ライ",""},
{"陸","land, six","おか, くが, たち, みち, む, むつ","","リク, ロク",""},
{"律","rhythm, law, regulation, gauge, control","たかし, のり","","リツ, リチ, レツ",""},
{"略","abbreviation, omission, outline, shorten, capture, plunder","ほぼ, おか.す, おさ.める, はかりごと, はか.る, はぶ.く, りゃく.す, りゃく.する","","リャク",""},
{"両","both, old Japanese coin, counter for vehicles, two","てる, ふたつ, もろ","","リョウ",""},
{"領","jurisdiction, dominion, territory, fief, reign","よう, よし","","リョウ",""},
{"了","complete, finish","さとる","","リョウ",""},
{"療","heal, cure","","","リョウ",""},
{"輪","wheel, ring, circle, link, loop, counter for wheels and flowers","わ, なわ, も","","リン",""},
{"類","sort, kind, variety, class, genus","たぐ.い","","ルイ",""},
{"令","orders, ancient laws, command, decree","のり, りょう, れ","","レイ",""},
{"零","zero, spill, overflow, nothing, cipher","ぜろ, こぼ.す, こぼ.れる","","レイ",""},
{"齢","age","よわ.い, とし","","レイ",""},
{"歴","curriculum, continuation, passage of time","","","レキ, レッキ",""},
{"列","file, row, rank, tier, column","れっ","","レツ, レ",""},
{"他","other, another, the others","ほか","","タ",""},
{"伝","transmit, go along, walk along, follow, report, communicate, legend, tradition","つた.わる, つた.える, つた.う, つだ.う, づた.い, つて, つたえ","","デン, テン",""},
{"顔","face, expression","かお","","ガン",""},
{"団","group, association","かたまり, まる.い","","ダン, トン",""},
{"対","vis-a-vis, opposite, even, equal, versus, anti-, compare","あいて, こた.える, そろ.い, つれあ.い, なら.ぶ, むか.う, つし","","タイ, ツイ",""},
{"舟","boat, ship","ふね, ふな, ぶね","","シュウ",""},
{"雲","cloud","くも, ぐも, き, ずも, のめ","","ウン",""},
{"労","labor, thank for, reward for, toil, trouble","ろう.する, いたわ.る, いた.ずき, ねぎら, つか.れる, ねぎら.う","","ロウ",""},
{"録","record","","","ロク",""},
{"論","argument, discourse","","","ロン",""},
{"湾","gulf, bay, inlet","いりえ","","ワン",""}
};

static kanjitransInfo kanjitable_jlpt1[] = 
{
{"亜","Asia, rank next, come after, -ous","つ.ぐ, や, つぎ, つぐ","","ア, アシア",""},
{"哀","pathetic, grief, sorrow, pathos, pity, sympathize","あわ.れ, あわ.れむ, かな.しい","","アイ",""},
{"挨","push open","ひら.く","","アイ",""},
{"垢","dirt, grime, earwax","あか, はじ","","コウ, ク",""},
{"握","grip, hold, mould sushi, bribe","にぎ.る","","アク",""},
{"憧","yearn after, long for, aspire to, admire, adore","あこが.れる","","ショウ, トウ, ドウ",""},
{"扱","handle, entertain, thresh, strip","あつか.る, あつか.い, あつか.う","","ショウ",""},
{"或","some, one, or, possibly, a certain","あ.る, あるい, あるいは","","ワク, コク, イキ",""},
{"案","plan, suggestion, draft, ponder, fear, proposition, idea, expectation, bill, worry","つくえ","","アン",""},
{"異","uncommon, queerness, strangeness, wonderful, curious, unusual","こと, こと.なる, け","","イ",""},
{"遺","bequeath, leave behind, reserve","","","イ, ユイ",""},
{"緯","horizontal, woof, left & right, latitude","よこいと, ぬき","","イ",""},
{"威","intimidate, dignity, majesty, menace, threaten","おど.す, おど.し, おど.かす, いさ, たけ, たけし","","イ",""},
{"維","fiber, tie, rope","これ, たもつ, つぐ, ゆい, ゆき","","イ",""},
{"尉","military officer, jailer, old man, rank","","","イ, ジョウ",""},
{"為","do, change, make, benefit, welfare, be of use, reach to, try, practice, cost, serve as, good, advantage, as a result of","ため, な.る, な.す, す.る, たり, つく.る, なり, びい","","イ",""},
{"椅","chair","","","イ",""},
{"炒","broil, parch, roast, fry","い.る, いた.める","","ソウ, ショウ",""},
{"壱","I, one","ひとつ, い, かず","","イチ, イツ",""},
{"逸","deviate, idleness, leisure, miss the mark, evade, elude, parry, diverge","そ.れる, そ.らす, はぐ.れる, いっ, はや, へん","","イツ",""},
{"芋","potato","いも","","ウ",""},
{"隠","conceal, hide, cover","かく.す, かく.し, かく.れる, かか.す, よ.る, お, がくし","","イン, オン",""},
{"陰","shade, yin, negative, sex organs, secret, shadow","かげ, かげ.る","","イン",""},
{"姻","matrimony, marry","","","イン",""},
{"韻","rhyme, elegance, tone","","","イン",""},
{"嘘","lie, falsehood","うそ, ふ.く","","キョ, コ",""},
{"嬉","glad, pleased, rejoice","うれ.しい, たの.しむ, うらし, うれし","","キ",""},
{"噂","rumor, gossip, hearsay","うわさ","","ソン",""},
{"衛","defense, protection","もり, い, まもる","","エイ, エ",""},
{"影","shadow, silhouette, phantom","かげ","","エイ",""},
{"詠","recitation, poem, song, composing","よ.む, うた.う, うた, え, ええ","","エイ",""},
{"益","benefit, gain, profit, advantage","ま.す, まし, ます","","エキ, ヤク",""},
{"疫","epidemic","","","エキ, ヤク",""},
{"餌","food, bait, prey, tempting profit","え, えば, えさ, もち","","ジ, ニ",""},
{"閲","review, inspection, revision","けみ.する","","エツ",""},
{"悦","ecstasy, joy, rapture","よろこ.ぶ, よろこ.ばす, や, よし","","エツ",""},
{"謁","audience, audience (with king)","","","エツ",""},
{"沿","run alongside, follow along, run along, lie along","そ.う, ぞ.い","","エン",""},
{"宴","banquet, feast, party","うたげ, うた, やす","","エン",""},
{"炎","inflammation, flame, blaze","ほのお, ぬく","","エン",""},
{"縁","affinity, relation, connection, edge, border, verge, brink","ふち, ふちど.る, ゆかり, よすが, へり, えにし","","エン, ネン",""},
{"鉛","lead","なまり","","エン",""},
{"猿","monkey","さる, さ, さわ, ざる, まし","","エン",""},
{"援","abet, help, save","","","エン",""},
{"宛","address, just like, fortunately","あ.てる, あて, づつ, あたか.も","","エン",""},
{"於","at, in, on, as for","おい.て, お.ける, ああ, より","","オ, ヨ",""},
{"桜","cherry","さくら, さ, ろう","","オウ, ヨウ",""},
{"応","apply, answer, yes, OK, reply, accept","あた.る, まさに, こた.える, お, たか, まさ","","オウ, ヨウ, ノウ",""},
{"往","journey, chase away, let go, going, travel","い.く, いにしえ, さき.に, ゆ.く, みち","","オウ",""},
{"凹","concave, hollow, sunken","くぼ.む, へこ.む, ぼこ","","オウ",""},
{"殴","assault, hit, beat, thrash","なぐ.る","","オウ",""},
{"憶","recollection, think, remember","","","オク",""},
{"乙","the latter, duplicate, strange, witty","おと, きのと","","オツ, イツ",""},
{"俺","I, myself","おれ, われ","","エン",""},
{"卸","wholesale","おろ.す, おろし, おろ.し","","シャ",""},
{"恩","grace, kindness, goodness, favor, mercy, blessing, benefit","めぐみ","","オン",""},
{"穏","calm, quiet, moderation","おだ.やか","","オン",""},
{"蚊","mosquito","か","","ブン",""},
{"仮","sham, temporary, interim, assumed (name), informal","かり, かり","","カ, ケ",""},
{"価","value, price","あたい","","カ, ケ",""},
{"華","splendor, flower, petal, shine, luster, ostentatious, showy, gay, gorgeous","はな, わ","","カ, ケ",""},
{"禍","calamity, misfortune, evil, curse","わざわい","","カ",""},
{"渦","whirlpool, eddy, vortex","","","カ",""},
{"佳","excellent, beautiful, good, pleasing, skilled","けい, よし","","カ",""},
{"寡","widow, minority, few","","","カ",""},
{"箇","counters for things","","","カ, コ",""},
{"嫁","marry into, bride","よめ, とつ.ぐ","","カ",""},
{"稼","earnings, work, earn money","かせ.ぐ","","カ",""},
{"架","erect, frame, mount, support, shelf, construct","か.ける, か.かる","","カ",""},
{"概","outline, condition, approximation, generally","おうむ.ね","","ガイ",""},
{"該","above-stated, the said, that specific","","","ガイ",""},
{"涯","horizon, shore","はて","","ガイ",""},
{"暇","spare time, rest, leisure, time, leave of absence","ひま, いとま","","カ",""},
{"霞","be hazy, grow dim, blurred","かすみ, かす.む","","カ, ゲ",""},
{"慨","rue, be sad, sigh, lament","","","ガイ",""},
{"嘩","noisy","かまびす.しい","","カ, ケ",""},
{"戒","commandment","いまし.める","","カイ",""},
{"懐","pocket, feelings, heart, yearn, miss someone, become attached to, bosom, breast","ふところ, なつ.かしい, なつ.かしむ, なつ.く, なつ.ける, なず.ける, いだ.く, おも.う, かね","","カイ, エ",""},
{"劾","censure, criminal investigation","","","ガイ",""},
{"街","boulevard, street, town","まち, また","","ガイ, カイ",""},
{"芽","bud, sprout, spear, germ","め, じ, めぐ","","ガ",""},
{"賀","congratulations, joy","か, のり, よし, より","","ガ",""},
{"我","ego, I, selfish, our, oneself","われ, わ, わ.が, わが, あ, あが, か","","ガ",""},
{"雅","gracious, elegant, graceful, refined","みや.び, う, お, か, ただし, のり, まさ, まさし, よし","","ガ",""},
{"餓","starve, hungry, thirst","う.える","","ガ",""},
{"壊","demolition, break, destroy","こわ.す, こわ.れる, やぶ.る","","カイ, エ",""},
{"悔","repent, regret","く.いる, く.やむ, くや.しい","","カイ",""},
{"拐","kidnap, falsify","","","カイ",""},
{"怪","suspicious, mystery, apparition","あや.しい, あや.しむ","","カイ, ケ",""},
{"塊","clod, lump, chink, clot, mass","かたまり, つちくれ","","カイ, ケ",""},
{"垣","hedge, fence, wall","かき, がい","","エン",""},
{"拡","broaden, extend, expand, enlarge","ひろ.がる, ひろ.げる, ひろ.める","","カク, コウ",""},
{"閣","tower, tall building, palace","","","カク",""},
{"核","nucleus, core, kernel","","","カク",""},
{"殻","husk, nut shell","から, がら","","カク, コク, バイ",""},
{"穫","harvest, reap","","","カク",""},
{"獲","seize, get, find, earn, acquire, can, may, able to","え.る","","カク",""},
{"隔","isolate, alternate, distance, separate, gulf","へだ.てる, へだ.たる","","カク",""},
{"較","contrast, compare","くら.べる","","カク, コウ",""},
{"郭","enclosure, quarters, fortification, red-light district","くるわ, ひろ","","カク",""},
{"岳","point, peak, mountain","たけ, おか, たか, たけん","","ガク",""},
{"崖","cliff, bluff, precipice","がけ, きし, はて","","ガイ, ゲ, ギ",""},
{"籠","basket, devote oneself, seclude oneself, cage, coop, implied","かご, こ.める, こも.る, こ.む, ごめ, もり","","ロウ, ル",""},
{"潟","lagoon","かた, がた, がら","","セキ",""},
{"括","fasten, tie up, arrest, constrict","くく.る","","カツ",""},
{"喝","hoarse, scold","","","カツ",""},
{"褐","brown, woollen kimono","","","カツ",""},
{"轄","control, wedge","くさび","","カツ",""},
{"滑","slippery, slide, slip, flunk","すべ.る, なめ.らか, かり, なめり","","カツ, コツ",""},
{"渇","thirst, dry up, parch","かわ.く","","カツ",""},
{"鞄","suitcase, bag, briefcase","かばん","","ハク, ホウ, ビョウ",""},
{"株","stocks, stump, shares, stock, counter for small plants","かぶ","","シュ",""},
{"釜","kettle, cauldron, iron pot","かま","","フ",""},
{"噛","chew, bite, gnaw","か.む, か.じる","","コウ, ゴウ",""},
{"刈","reap, cut, clip, trim, prune","か.る, かっ, かり","","ガイ, カイ",""},
{"瓦","tile, gram","かわら, ぐらむ","","ガ",""},
{"幹","tree trunk","みき, つよし, まさ, もと","","カン",""},
{"看","watch over, see","み.る","","カン",""},
{"憾","remorse, regret, be sorry","うら.む","","カン",""},
{"還","send back, return","かえ.る","","カン",""}
};

#endif

