#ifndef    __kfish_h__
#define    __kfish_h__

#include <qstring.h>

#include <kpanelapplet.h>
class QTimer;
class QCanvas;
class KAboutData;
class kfishCanvasView;
class kfishManager;
class kfishBubbleManager;
class configDlg;
class kfish;

extern kfish *kfishApp;
 
class kfish : public KPanelApplet
{
  Q_OBJECT

public:
    kfish(const QString& configFile, Type t = Stretch, int actions = 0, QWidget *parent = 0, const char *name = 0 );

    ~kfish(void);

    // Methods reimplemented from KPanelApplet
  
    int widthForHeight( int height ) const;
    int heightForWidth( int width ) const;
    void orientationChange(Orientation orient);

    void about(void);
    void preferences(void);
    
    QCanvas *getCanvas() const { return m_canvas; };
  
signals:
    void signalSettingsChanged();
  
protected slots:
    void slotSettingsChanged();
  
    void slotAbout();
    void slotPreferences();

    void slotConfigDlgDestroy();

private:
    int m_oldwidth;

    kfishCanvasView    *m_canvasview;
    kfishManager       *m_fish;
    kfishBubbleManager *m_bubble;
    QCanvas            *m_canvas;
    configDlg          *confDlg;

};

#endif
