/***************************************************************************
 *   Copyright (C) 2003 by Hans Karlsson                                   *
 *   karlsson.h@home.se                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "datesensor.h"
DateSensor::DateSensor( int interval ) : Sensor( interval )
{

}
DateSensor::~DateSensor()
{
}

void DateSensor::update()
{
    QDateTime qdt  =  QDateTime::currentDateTime();
    QString format;
    SensorParams *sp;
    Meter *meter;

    QObjectListIt it( *objList );
    while (it != 0)
    {
        sp = (SensorParams*)(*it);
        meter = sp->getMeter();
        format = sp->getParam("FORMAT");

        if (format.length() == 0 )
        {
	   format = "hh:mm";
        }
        meter->setValue(qdt.toString(format));
        ++it;
    }
}
