/***************************************************************************
                          cpreferences.cpp  -  description
                             -------------------
    begin                : Sat Jul 1 2000
    copyright            : (C) 2000 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cpreferences.h"
#include "cchoixfichier.h"

#include <kglobalsettings.h>
#include <kmessagebox.h>
#include <kprocess.h>
#include <kdebug.h>

CPreferences::CPreferences(QWidget *parent, const char *name) :KDialogBase( IconList, i18n("Configure"), Help|Default|Ok|Apply|Cancel,
		Ok, parent, name, true, true ) {

  setHelp( "karchiver/index.html", QString::null );

  setMiscOptions();
  setCompressorsOptions();
  setTarOptions();
  setPreferedArchiveType();
  setTipofDayOptions();
  setDirectoriesOptions();
  setIconSizeOptions();
  setDateOptions();
  setFontOptions();
  setArchiveReadingOptions();

  //Aditionnal init
  setCaption(i18n("Configure"));
  
  connect(this, SIGNAL(okClicked()), this, SLOT(slotOk()));
  connect(this, SIGNAL(applyClicked()), this, SLOT(slotSauver()));
  connect(this, SIGNAL(cancelClicked()), this, SLOT(slotAnnuler()));
  connect(this, SIGNAL(defaultClicked()), this, SLOT(slotDefault()));
  
  connect(cbOGZEcrase, SIGNAL(clicked()), this, SLOT(slotDisplayWarningOverwrite()));
  
  readOptions();
  compresseursDispo();
}

CPreferences::~CPreferences(){
}

/*Read the config file and set the propper values for all widgets*/
void CPreferences::readOptions()
{
  KConfig *config = kapp->config();
  QString preferedArchive;

  config->setGroup("OPTIONS");
  cbOTAbsolutePath->setChecked(config->readBoolEntry("CheminAbsolu",false));
  cbOTWholePath->setChecked(config->readBoolEntry("ToutChemin",false));
  cbOTRecursif->setChecked(config->readBoolEntry("Recursif",true));
  cbOGZEcrase->setChecked(config->readBoolEntry("OverwriteWhenExtracting",false));
  cmbOGZTauxCompression->setCurrentItem(config->readNumEntry("TauxCompression",9)-1);
  cbAlternateBackground->setChecked(config->readBoolEntry("AlternateBackground",true));
  cbReadByDir->setChecked(config->readBoolEntry("ReadByDirs",true));
  preferedArchive=config->readEntry("PreferedArchiveType",".tar.gz");
  cbDefaultDropBehaviour->setChecked(config->readBoolEntry("DefaultDropBehaviour",false));
  
	switch(config->readNumEntry("LectureParFlot",1))
	{
		case 0:
			rbOLLent->setChecked(true);//Too many problems with stream reading -->out
			break;
		case 1:
			rbOLLent->setChecked(true);
			break;
		case 2:
			rbOLVeryFast->setChecked(true);
			break;
	}
	
	switch(config->readNumEntry("SelectionMode",0))
	{
		case 0:
			rbMOSMMulti->setChecked(true);
			break;
		case 1:
			rbMOSMExtended->setChecked(true);
			break;
	}
		
	config->setGroup("LASTDIRS");

	switch(config->readNumEntry("OptionExtraction",1))
	{
		case 0:
			rbDDEDDernier->setChecked(true);
			break;
		case 1:
			rbDDEDMaison->setChecked(true);
			break;
		case 2:
			rbDDEDShell->setChecked(true);
			break;
	}
	switch(config->readNumEntry("OptionOuverture",1))
	{
		case 0:
			rbDDODDernier->setChecked(true);
			break;
		case 1:
			rbDDODMaison->setChecked(true);
			break;
		case 2:
			rbDDODShell->setChecked(true);
			break;
	}
	
	config->setGroup("ICONES");

	switch(config->readNumEntry("TailleIconesListe",0))
	{
		case 0:
			rbISFPetit->setChecked(true);
			break;
		case 1:
			rbISFMoyen->setChecked(true);
			break;
		case 2:
			rbISFGrand->setChecked(true);
			break;
	}
		
	config->setGroup("FONT");
	
	QFont font( KGlobalSettings::generalFont() );
	mFont->setFont(config->readFontEntry("Font", &font));
	
	config->setGroup("DATE");

	switch(config->readNumEntry("KindOfDate",0))
	{
		case 0:
			rbDDStandard->setChecked(true);
			break;
		case 1:
			rbDDLocalisedSmall->setChecked(true);
			break;
		case 2:
			rbDDLocalisedLarge->setChecked(true);
			break;
	}
	
	config->setGroup("TipOfTheDay");
	cbOTDDisplayTipofDay->setChecked(config->readBoolEntry("show_tod",true));

 config->setGroup("Notification Messages");
 QString lookforAutoconfSoftware;
 lookforAutoconfSoftware=config->readEntry("Don't look for source softwares again");
 if(lookforAutoconfSoftware.isNull())
   rbLFASAlwaysAsk->setChecked(true);
 else if(lookforAutoconfSoftware=="yes")
   rbLFASAlwaysYes->setChecked(true);
 else
   rbLFASAlwaysNo->setChecked(true);
 
 if(preferedArchive==".tar.gz")
    radiotargz->setChecked(true);
  else if(preferedArchive==".tar.bz2")
    radiotarbz2->setChecked(true);
  else if(preferedArchive==".tar")
    radiotar->setChecked(true);
  else if(preferedArchive==".zip")
    radiozip->setChecked(true);
  else if(preferedArchive==".rar")
    radiorar->setChecked(true);
  else if(preferedArchive==".lha")
    radiolha->setChecked(true);
  else if(preferedArchive==".gz")
    radiogz->setChecked(true);
  else if(preferedArchive==".bz2")
    radiobz2->setChecked(true);
  else if(preferedArchive==".arj")
    radioarj->setChecked(true);
  else if(preferedArchive==".7z")
    radio7z->setChecked(true);
  else if(preferedArchive==".sit")
    radiosit->setChecked(true);
  else if(preferedArchive==".hqx")
    radiohqx->setChecked(true);
}

/*Save those options*/
void CPreferences::Sauver()
{
  KConfig *config = kapp->config();


  config->setGroup("OPTIONS");
	config->writeEntry("CheminAbsolu",getCheminAbsolu());
  config->writeEntry("ToutChemin",getWholePath());
  config->writeEntry("Recursif",getRecursif());
	config->writeEntry("OverwriteWhenExtracting",getOverwriteWhenExtracting());
	config->writeEntry("TauxCompression",getCompressLevel());
	config->writeEntry("LectureParFlot",getLitParFlot());
	config->writeEntry("SelectionMode",getSelectionMode());
  config->writeEntry("AlternateBackground",getAlternateBackground());
  config->writeEntry("ReadByDirs",getReadByDirs());
  config->writeEntry("PreferedArchiveType", getPreferedArchiveType());
  config->writeEntry("DefaultDropBehaviour", getDefaultDropBehaviour());
	
	config->setGroup("LASTDIRS");
	config->writeEntry("OptionExtraction",getKindofExtractionDirectory());
	config->writeEntry("OptionOuverture",getKindofOpeningDirectory());

	config->setGroup("ICONES");
	config->writeEntry("TailleIconesListe",getSizeofIconListe());
	
	config->setGroup("FONT");
	config->writeEntry("Font",mFont->font());
	
	config->setGroup("DATE");
	config->writeEntry("KindOfDate",getKindOfDate());
	
	config->setGroup("TipOfTheDay");
	config->writeEntry("show_tod",cbOTDDisplayTipofDay->isChecked());

 config->setGroup("Notification Messages");
 QString lookforAutoconfSoftware;
 lookforAutoconfSoftware=config->readEntry("Don't look for source softwares again");
 if(rbLFASAlwaysAsk->isChecked())
   config->deleteEntry("Don't look for source softwares again");
 else if(rbLFASAlwaysYes->isChecked())
   config->writeEntry("Don't look for source softwares again", "yes");
 else
   config->writeEntry("Don't look for source softwares again", "no");
}


/** returns true if we will use an absolute path
 * for files added to the archive */
bool CPreferences::getCheminAbsolu(){
	return cbOTAbsolutePath->isChecked();
}

/** return true if we will include the absoute path
	* and not the relative when dropping */
bool CPreferences::getWholePath(){
	return cbOTWholePath->isChecked();
}

/** return true if we will recurse folders when dropping */
bool CPreferences::getRecursif(){
	return cbOTRecursif->isChecked();
}

/** return the compress rate for gzip ans bzip2
1 = min, 9 = max */
int CPreferences::getCompressLevel(){
	return cmbOGZTauxCompression->currentItem()+1;
}

/** return 0 if we'll open the last dir, 1 for home dir,
and 2 for shell's one */
int CPreferences::getKindofExtractionDirectory(){
	if(rbDDEDDernier->isChecked())
		return 0;
	else if(rbDDEDMaison->isChecked())
		return 1;
	else if(rbDDEDShell->isChecked())
		return 2;
	return 1;
}

/** return 0 for last dir, 1 for home dir, 2 for shell's one
==>set the default directory when OPENING files */
int CPreferences::getKindofOpeningDirectory(){
	if(rbDDODDernier->isChecked())
		return 0;
	else if(rbDDODMaison->isChecked())
		return 1;
	else if(rbDDODShell->isChecked())
		return 2;
	return 1;
}

/** return 0 if we'll display small icons, 1 for medium,
2 for large */
int CPreferences::getSizeofIconListe(){
	if(rbISFPetit->isChecked())
		return 0;
	else if(rbISFMoyen->isChecked())
		return 1;
	else if(rbISFGrand->isChecked())
		return 2;
	return 1;
}

/** close the dialog box and use the changes */
void CPreferences::slotOk(){
	Sauver();
	accept();
}

/** Save the changes */
void CPreferences::slotSauver(){
	Sauver();
}

/** close the dialog box, and forget the changes */
void CPreferences::slotAnnuler(){
	reject();
}

/** return true if we'll read archive using streams,
false if we'll read using signal/slot mechanism */
int CPreferences::getLitParFlot(){
	if(rbOLRapide->isChecked())
		return 0;
	else if(rbOLLent->isChecked())
		return 1;
	else
		return 2;
}

/** return true if files will be overwritten when
they are extracted */
bool CPreferences::getOverwriteWhenExtracting(){
	return cbOGZEcrase->isChecked();
}

/** set the widgets for the TAR tab */
void CPreferences::setTarOptions(){
  QLabel* label;
  QFrame *page = addPage( i18n("Compressors"), i18n("Compressors options"),
			  BarIcon("tgz", KIcon::SizeMedium ) );
  QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );

  QGridLayout *gbox = new QGridLayout( 6, 1 );
  topLayout->addLayout( gbox );

  cbOTAbsolutePath= new QCheckBox(page,"NoName");
  QToolTip::add(cbOTAbsolutePath,i18n("Store files as /home/toto/files\ninstead of home/toto/files"));
  cbOTAbsolutePath->setText(i18n("Absolute path: add / to the paths of files"));
  gbox->addWidget(cbOTAbsolutePath , 0, 0 );

  cbOTWholePath= new QCheckBox(page,"NoName");
  QToolTip::add(cbOTWholePath,i18n("If checked, the base path of the dropped folder will be\n home/toto/dropped_dir instead of drop_dir"));
  cbOTWholePath->setText(i18n("Add the base path when dropping"));
  gbox->addWidget(cbOTWholePath , 1, 0 );

  cbOTRecursif= new QCheckBox(page,"NoName");
  cbOTRecursif->setText(i18n("Recurse folders when dropping"));
  gbox->addWidget(cbOTRecursif , 2, 0 );

  cbOGZEcrase= new QCheckBox(page,"cb_overwrite_files");
  cbOGZEcrase->setText(i18n("Always overwrite files when extracting"));
  cbOGZEcrase->setChecked(false);
  gbox->addWidget(cbOGZEcrase , 6, 0 );

  label = new QLabel( i18n("Compress rate"), page, "compress rate label" );
  gbox->addWidget( label, 4, 0 );
  label = new QLabel( i18n("9 = compress better, 1 = compress faster"), page, "compress_rate_label" );
  gbox->addWidget( label, 5, 0 );
  cmbOGZTauxCompression = new QComboBox( false, page );
  cmbOGZTauxCompression->insertItem(i18n("1"));
  cmbOGZTauxCompression->insertItem(i18n("2"));
  cmbOGZTauxCompression->insertItem(i18n("3"));
  cmbOGZTauxCompression->insertItem(i18n("4"));
  cmbOGZTauxCompression->insertItem(i18n("5"));
  cmbOGZTauxCompression->insertItem(i18n("6"));
  cmbOGZTauxCompression->insertItem(i18n("7"));
  cmbOGZTauxCompression->insertItem(i18n("8"));
  cmbOGZTauxCompression->insertItem(i18n("9"));
  cmbOGZTauxCompression->setCurrentItem(8);
  gbox->addWidget(cmbOGZTauxCompression , 5, 1 );
  
  topLayout->addStretch(10);
}

/** set the widgets for default directories */
void CPreferences::setDirectoriesOptions(){
  QFrame *page = addPage( i18n("Folders"), i18n("Default folders"),
			  BarIcon("folder", KIcon::SizeMedium ) );

  QGridLayout *gbox = new QGridLayout( page, 4, 4, 5 );

  gbDDExtraction= new QButtonGroup(page,"to extract");
  gbDDExtraction->setTitle(i18n("For Extracting"));
  gbox->addMultiCellWidget(gbDDExtraction,0, 4, 0, 1);

  QGridLayout *grid1 = new QGridLayout( gbDDExtraction, 3, 1, 15,1 );

  rbDDEDDernier= new QRadioButton(gbDDExtraction,"NoName");
  rbDDEDDernier->setText(i18n("Last folder"));
  grid1->addWidget( rbDDEDDernier, 0, 0);

  rbDDEDMaison= new QRadioButton(gbDDExtraction,"NoName");
  rbDDEDMaison->setText(i18n("Home folder (~/)"));
  grid1->addWidget( rbDDEDMaison, 1, 0);

  rbDDEDShell= new QRadioButton(gbDDExtraction,"NoName");
  rbDDEDShell->setText(i18n("Shell's one"));
  grid1->addWidget( rbDDEDShell, 2, 0);

  gbDDOuverture= new QButtonGroup(page,"to open");
  gbDDOuverture->setTitle(i18n("For Opening"));
  gbox->addMultiCellWidget(gbDDOuverture, 0, 4, 2, 3);

  grid1 = new QGridLayout( gbDDOuverture, 3, 1, 15,1 );

  rbDDODDernier= new QRadioButton(gbDDOuverture,"NoName");
  rbDDODDernier->setText(i18n("Last folder"));
  grid1->addWidget( rbDDODDernier, 0, 0);

  rbDDODMaison= new QRadioButton(gbDDOuverture,"NoName");
  rbDDODMaison->setText(i18n("Home folder (~/)"));
  grid1->addWidget( rbDDODMaison, 1, 0);

  rbDDODShell= new QRadioButton(gbDDOuverture,"NoName");
  rbDDODShell->setText(i18n("Shell's one"));
  grid1->addWidget(rbDDODShell , 2, 0);

}

/** set the widgets for Icon size options tab */
void CPreferences::setIconSizeOptions(){
  QFrame *page = addPage( i18n("Icons"), i18n("Icon size"),
			  BarIcon("image", KIcon::SizeMedium ) );

  QGridLayout *gbox = new QGridLayout( page, 6, 4, 5 );

  gbISFichiers= new QButtonGroup(page,"NoName");
  gbISFichiers->setTitle(i18n("Files in Archive"));
  gbox->addMultiCellWidget(gbISFichiers, 0, 6, 0, 1);
  
  QGridLayout *grid1 = new QGridLayout(gbISFichiers , 3, 1, 15,7 );

  
  rbISFPetit= new QRadioButton(gbISFichiers,"NoName");
  rbISFPetit->setText(i18n("Small"));
  grid1->addWidget(rbISFPetit, 0, 0);

  rbISFMoyen= new QRadioButton(gbISFichiers,"NoName");
  rbISFMoyen->setText(i18n("Medium"));
  grid1->addWidget(rbISFMoyen, 1, 0);

  rbISFGrand= new QRadioButton(gbISFichiers,"NoName");
  rbISFGrand->setText(i18n("Large"));
  grid1->addWidget(rbISFGrand, 2, 0);

}

/** set the widgets for reading archive options */
void CPreferences::setArchiveReadingOptions(){
  QFrame *page = addPage( i18n("Reading"), i18n("Method for reading archive"),
			  BarIcon("document", KIcon::SizeMedium ) );

  QGridLayout *gbox = new QGridLayout( page, 4, 1, 5 );

  bgLectureArchive= new QButtonGroup(page, "Lecture archive");
  bgLectureArchive->setTitle(i18n("Read:"));
  gbox->addMultiCellWidget(bgLectureArchive, 0, 4, 0, 1);

  QGridLayout *grid1 = new QGridLayout( bgLectureArchive, 3, 1, 15,7 );

  rbOLVeryFast= new QRadioButton(bgLectureArchive,"NoName");
  rbOLVeryFast->setText(i18n("Fastest but don't use icons"));
  grid1->addWidget(rbOLVeryFast, 0, 0);

  rbOLRapide= new QRadioButton(bgLectureArchive,"NoName");
  rbOLRapide->setText(i18n("Faster but freeze kar's interface"));
  rbOLRapide->setEnabled(false);
  grid1->addWidget(rbOLRapide, 1, 0);

  rbOLLent= new QRadioButton(bgLectureArchive,"NoName");
  rbOLLent->setText(i18n("Normally, but the reading can be interrupted"));
  grid1->addWidget(rbOLLent, 2, 0);

}

/** set the widgets for available compressors */
void CPreferences::setCompressorsOptions(){
  QFrame *page = addPage( i18n("Plugins"), i18n("Available compressors on your system"),
			  BarIcon("info", KIcon::SizeMedium ) );

  QGridLayout *gbox = new QGridLayout( page, 11, 2, 3 );

  QLabel_5= new QLabel(page,"NoName");
  QLabel_5->setText(i18n("The TAR compressor..."));
  gbox->addWidget(QLabel_5, 0, 0);
  lTarDispo= new KLed(page,"NoName");
  lTarDispo->setState(KLed::On);
  gbox->addWidget(lTarDispo, 0, 1);

  lGzipDispo= new KLed(page,"NoName");
  lGzipDispo->setState(KLed::On);
  gbox->addWidget(lGzipDispo, 1, 1);
  QLabel_7= new QLabel(page,"NoName");
  QLabel_7->setText(i18n("The GZIP compressor..."));
  gbox->addWidget(QLabel_7, 1, 0);

  lBzip2Dispo= new KLed(page,"NoName");
  lBzip2Dispo->setState(KLed::On);
  gbox->addWidget(lBzip2Dispo, 2, 1);
  QLabel_8= new QLabel(page,"NoName");
  QLabel_8->setText(i18n("The BZIP2 compressor..."));
  gbox->addWidget(QLabel_8, 2, 0);

  lRarDispo= new KLed(page,"NoName");
  lRarDispo->setState(KLed::On);
  gbox->addWidget(lRarDispo, 3, 1);
  QLabel_9= new QLabel(page,"NoName");
  QLabel_9->setText(i18n("The RAR compressor..."));
  gbox->addWidget(QLabel_9, 3, 0);

  KURLLabel* QLabel_getrar= new KURLLabel(page,"NoName");
  QLabel_getrar->setURL("http://www.rarlabs.com");
  QLabel_getrar->setText(i18n("download it"));
  gbox->addWidget(QLabel_getrar, 3, 2);
  connect(QLabel_getrar, SIGNAL(leftClickedURL(const QString&)), SLOT(processMyURL(const QString&)));
  
  lUnRarDispo= new KLed(page,"NoName");
  lUnRarDispo->setState(KLed::On);
  gbox->addWidget(lUnRarDispo, 4, 1);
  QLabel_un9= new QLabel(page,"NoName");
  QLabel_un9->setText(i18n("The RAR reader..."));
  gbox->addWidget(QLabel_un9, 4, 0);

  lLhaDispo= new KLed(page,"NoName");
  lLhaDispo->setState(KLed::On);
  gbox->addWidget(lLhaDispo, 5, 1);
  QLabel_10= new QLabel(page,"NoName");
  QLabel_10->setText(i18n("The LHA compressor..."));
  gbox->addWidget(QLabel_10, 5, 0);

  QLabel_15= new QLabel(page,"NoName");
  QLabel_15->setText(i18n("The Zip reader..."));
  gbox->addWidget(QLabel_15, 6, 0);
  lUnzipDispo= new KLed(page,"NoName");
  lUnzipDispo->setState(KLed::On);
  gbox->addWidget(lUnzipDispo, 6, 1);

  lZipDispo= new KLed(page,"NoName");
  lZipDispo->setState(KLed::On);
  gbox->addWidget(lZipDispo, 7, 1);
  QLabel_17= new QLabel(page,"NoName");
  QLabel_17->setText(i18n("The Zip compressor..."));
  gbox->addWidget(QLabel_17, 7, 0);

  KURLLabel* QLabel_getzip= new KURLLabel(page,"NoName");
  QLabel_getzip->setText(i18n("download it"));
  QLabel_getzip->setURL("http://www.info-zip.org");
  gbox->addWidget(QLabel_getzip, 7, 2);
  connect(QLabel_getzip, SIGNAL(leftClickedURL(const QString&)), SLOT(processMyURL(const QString&)));
  
  QLbl_16= new QLabel(page,"NoName");
  QLbl_16->setText(i18n("The Arj reader..."));
  gbox->addWidget(QLbl_16, 8, 0);
  lUnarjDispo= new KLed(page,"NoName");
  lUnarjDispo->setState(KLed::On);
  gbox->addWidget(lUnarjDispo, 8, 1);

  KURLLabel* QLabel_getarj= new KURLLabel(page,"NoName");
  QLabel_getarj->setText(i18n("download it"));
  QLabel_getarj->setURL("http://arj.sourceforge.net");
  gbox->addWidget(QLabel_getarj, 8, 2);
  connect(QLabel_getarj, SIGNAL(leftClickedURL(const QString&)), SLOT(processMyURL(const QString&)));
  
  QLabel* QLbl_18= new QLabel(page,"NoName");
  QLbl_18->setText(i18n("The 7z compressor..."));
  gbox->addWidget(QLbl_18, 9, 0);
  l7zDispo= new KLed(page,"NoName");
  l7zDispo->setState(KLed::On);
  gbox->addWidget(l7zDispo, 9, 1);

  KURLLabel* QLabel_get7z= new KURLLabel(page,"NoName");
  QLabel_get7z->setText(i18n("download it"));
  QLabel_get7z->setURL("http://7-zip.org");
  gbox->addWidget(QLabel_get7z, 9, 2);
  connect(QLabel_get7z, SIGNAL(leftClickedURL(const QString&)), SLOT(processMyURL(const QString&)));
  
  QLabel* QLbl_19= new QLabel(page,"NoName");
  QLbl_19->setText(i18n("The ar/deb compressor..."));
  gbox->addWidget(QLbl_19, 10, 0);
  lArDispo= new KLed(page,"NoName");
  lArDispo->setState(KLed::On);
  gbox->addWidget(lArDispo, 10, 1);

  QLabel* QLbl_20= new QLabel(page,"NoName");
  QLbl_20->setText(i18n("The sit/hqx compressor..."));
  gbox->addWidget(QLbl_20, 11, 0);
  lSitDispo= new KLed(page,"NoName");
  lSitDispo->setState(KLed::On);
  gbox->addWidget(lSitDispo, 11, 1);

  KURLLabel* QLabel_getSit= new KURLLabel(page,"NoName");
  QLabel_getSit->setText(i18n("download it"));
  QLabel_getSit->setURL("http://www.stuffit.com");
  gbox->addWidget(QLabel_getSit, 11, 2);
  connect(QLabel_getSit, SIGNAL(leftClickedURL(const QString&)), SLOT(processMyURL(const QString&)));
}

/** check which compressors are available */
void CPreferences::compresseursDispo(){
  int installedcompressors=CArchiveChoice::getInstalledCompressors();
  
  if((installedcompressors&TAR)==0)
    lTarDispo->setState(KLed::Off);
  if((installedcompressors&GZIP)==0)
    lGzipDispo->setState(KLed::Off);
  if((installedcompressors&BZIP2)==0)
    lBzip2Dispo->setState(KLed::Off);
  if((installedcompressors&LHA)==0)
    lLhaDispo->setState(KLed::Off);
  if((installedcompressors&RAR)==0)
    lRarDispo->setState(KLed::Off);
  if(KStandardDirs::findExe("unrar")==NULL)
    lUnRarDispo->setState(KLed::Off);
  if((installedcompressors&ZIP)==0)
    lUnzipDispo->setState(KLed::Off);
  if(KStandardDirs::findExe("zip")==NULL)
    lZipDispo->setState(KLed::Off);
  if((installedcompressors&ARJ)==0)
    lUnarjDispo->setState(KLed::Off);
  if((installedcompressors&SEVENZ)==0)
    l7zDispo->setState(KLed::Off);
  if((installedcompressors&AR)==0)
    lArDispo->setState(KLed::Off);
  if((installedcompressors&SIT)==0)
    lSitDispo->setState(KLed::Off);
}

/** set all widgets to default settings */
void CPreferences::slotDefault(){
	//Gzip panel
	cmbOGZTauxCompression->setCurrentItem(0);
	cbOGZEcrase->setChecked(true);
	
	//Tar panel
	cbOTAbsolutePath->setChecked(false);
	cbOTWholePath->setChecked(false);
	cbOTRecursif->setChecked(true);
//	cbOTEcrase->setChecked(true);
	
	//Directories panel
	rbDDEDMaison->setChecked(true);
	rbDDODMaison->setChecked(true);
	
	//Icon size panel
	rbISFPetit->setChecked(true);
	
	//Reading panel
	rbOLLent->setChecked(true);
	
	//Font panel
	mFont->setFont(KGlobalSettings::generalFont());
	
	//Date panel
	rbDDLocalisedSmall->setChecked(true);
	
	//Tip of the day panel
	cbOTDDisplayTipofDay->setChecked(true);
	
	//Misc options
	rbMOSMMulti->setChecked(true);
}

/** allow user to select a font for the listview */
void CPreferences::setFontOptions(){
  QVBox *page = addVBoxPage( i18n("Font"), i18n("List font" ),
			     BarIcon("fonts", KIcon::SizeMedium ) );

  QString txt(i18n("font"));
  mFont = new KFontChooser( page,txt,false,QStringList(),false,6 );
  mFont->setSampleText( i18n("Sample Text") );
}

/** return the font for the listview */
QFont CPreferences::getFont(){
	return mFont->font();
}

/** set the widgets for the date displayed on the
  * listview */
void CPreferences::setDateOptions(){
  QFrame *page = addPage( i18n("Date"), i18n("Display date"),
			  BarIcon("date", KIcon::SizeMedium ) );

  QGridLayout *gbox = new QGridLayout( page, 6, 4, 5 );

  bgDateDisplay= new QButtonGroup(page,"dateGroupbox");
  bgDateDisplay->setTitle("");
  gbox->addMultiCellWidget(bgDateDisplay, 0, 6, 0, 1);

  QGridLayout *grid1 = new QGridLayout(bgDateDisplay, 3, 0, 15,7 );
  rbDDStandard= new QRadioButton(bgDateDisplay,"NoName");
  rbDDStandard->setText(i18n("Compressors' one"));
  grid1->addWidget(rbDDStandard, 0, 0);

  rbDDLocalisedSmall= new QRadioButton(bgDateDisplay,"NoName");
  rbDDLocalisedSmall->setText(i18n("Localized: 5/20/2000"));
  grid1->addWidget(rbDDLocalisedSmall, 1, 0);

  rbDDLocalisedLarge= new QRadioButton(bgDateDisplay,"NoName");
  rbDDLocalisedLarge->setText(i18n("Localized: Saturday May 20 2000"));
  grid1->addWidget(rbDDLocalisedLarge, 2, 0);
}

/** return the kind of date that will be displayed in
the listview:
0: standard one (compressor's one)
1: localised 1/1/2000
2: localised: Saturday May 2000 */
int CPreferences::getKindOfDate(){
  if(rbDDStandard->isChecked())
    return 0;
  else if(rbDDLocalisedSmall->isChecked())
    return 1;
  else if(rbDDLocalisedLarge->isChecked())
    return 2;
  return 0;
}

/** set the widgets for the TipofDay tab */
void CPreferences::setTipofDayOptions(){
  QFrame *page = addPage( i18n("Tips"), i18n("Tips"),
			  BarIcon("help", KIcon::SizeMedium ) );
  QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );

  QVBoxLayout *gbox = new QVBoxLayout( this, 4 );
  topLayout->addLayout( gbox );

  cbOTDDisplayTipofDay= new QCheckBox(page,"NoName");
  cbOTDDisplayTipofDay->setText(i18n("Display the tip of the day at startup"));
  gbox->addWidget(cbOTDDisplayTipofDay );

  
  QButtonGroup* bgLookForAutoConfSoftware = new QButtonGroup(page, "bgautoconf");
  bgLookForAutoConfSoftware->setTitle(i18n("Compile and Install for me any source software"));
  gbox->addWidget( bgLookForAutoConfSoftware );
  QVBoxLayout *bgsubLayout = new QVBoxLayout(bgLookForAutoConfSoftware, 20, 4);
  
  rbLFASAlwaysAsk=new QRadioButton("rbLFASAlwaysAsk", bgLookForAutoConfSoftware);
  rbLFASAlwaysAsk->setText(i18n("Always ask me"));
  bgsubLayout->addWidget(rbLFASAlwaysAsk);
  
  rbLFASAlwaysYes=new QRadioButton("rbLFASAlwaysYes", bgLookForAutoConfSoftware);
  rbLFASAlwaysYes->setText(i18n("Yes, always"));
  bgsubLayout->addWidget(rbLFASAlwaysYes);
  
  rbLFASAlwaysNo=new QRadioButton("rbLFASAlwaysNo", bgLookForAutoConfSoftware);
  rbLFASAlwaysNo->setText(i18n("No, never"));
  bgsubLayout->addWidget(rbLFASAlwaysNo);
  
  topLayout->addStretch(10);
}

/** return true if we'll display the tip of the day
at startup */
bool CPreferences::getDisplayTipofDay(){
	return cbOTDDisplayTipofDay->isChecked();
}

/** set misc options for karchiveur */
void CPreferences::setMiscOptions(){
  QFrame *page = addPage( i18n("Misc"), i18n("Misc options"),
			  BarIcon("configure", KIcon::SizeMedium ) );

  QGridLayout *gbox = new QGridLayout( page, 6, 4, 5 );

  gbMOSelectionMode= new QButtonGroup(page,"NoName");
  gbMOSelectionMode->setTitle(i18n("Selection of List's Items"));
  gbox->addMultiCellWidget(gbMOSelectionMode, 0, 6, 0, 1);

  QGridLayout *grid1 = new QGridLayout(gbMOSelectionMode, 2, 0, 15,7 );

  rbMOSMMulti= new QRadioButton(gbMOSelectionMode,"NoName");
  rbMOSMMulti->setText(i18n("Click to add to selection"));
  grid1->addWidget(rbMOSMMulti, 0, 0);

  rbMOSMExtended= new QRadioButton(gbMOSelectionMode,"NoName");
  rbMOSMExtended->setText(i18n("Ctrl+click to add to selection"));
  grid1->addWidget(rbMOSMExtended, 1, 0);

  cbReadByDir = new QCheckBox(gbMOSelectionMode,"CheckReadByDirs");
  cbReadByDir->setText(i18n("Display archive content using folders (like in Konqueror)"));
  grid1->addWidget(cbReadByDir, 2, 0);

  cbAlternateBackground = new QCheckBox(gbMOSelectionMode,"CheckBoxAlternateBackground");
  cbAlternateBackground->setText(i18n("Alternate background (white/blue/white...)"));
  grid1->addWidget(cbAlternateBackground, 3, 0);

  cbDefaultDropBehaviour = new QCheckBox(gbMOSelectionMode,"CheckBoxDropBehaviour");
  cbDefaultDropBehaviour->setText(i18n("Always add dropped files (no prompt dialog)"));
  grid1->addWidget(cbDefaultDropBehaviour, 4, 0);
}

/** return 0 if we're in standard Multi selection mode
1 for extended selection mode
(i.e. ctrl+click to select) */
int CPreferences::getSelectionMode(){
	if(rbMOSMMulti->isChecked())
		return 0;
	else
		return 1;
}

/* return true if one whises to get an alternate background */
bool CPreferences::getAlternateBackground(){
  return cbAlternateBackground->isChecked();
}

/* return true if one whises to always add dropped files */
bool CPreferences::getDefaultDropBehaviour(){
  return cbDefaultDropBehaviour->isChecked();
}

/* return true if one whises to list archive content dir. by dir. */
bool CPreferences::getReadByDirs(){
  return cbReadByDir->isChecked();
}

/*Set the default archive type, when creating archives*/
void CPreferences::setPreferedArchiveType()
{
  QFrame *page = addPage( i18n("Default Compressor"), i18n("Default compressor"),
			  BarIcon("tgz", KIcon::SizeMedium ) );

  QGridLayout *gbox = new QGridLayout( page, 1, 1, 3 );
  bgPreferedCompressor= new QButtonGroup(page,"NoName");
  bgPreferedCompressor->setTitle(i18n("Preferred Compressor:"));
  gbox->addWidget(bgPreferedCompressor, 0, 0);
  QGridLayout *box=new QGridLayout(bgPreferedCompressor, 4, 2, 16, 8);

      radiotar= new QRadioButton(bgPreferedCompressor,"rbtar");
      radiotar->setText(".tar");
      QToolTip::add(radiotar,i18n("Uncompressed"));
      box->addWidget(radiotar, 0, 0);

      radiotargz= new QRadioButton(bgPreferedCompressor,"rbtargz");
      QToolTip::add(radiotargz,i18n("Default unix format"));
      radiotargz->setText(".tar.gz");
      box->addWidget(radiotargz, 1, 0);

      radiotarbz2= new QRadioButton(bgPreferedCompressor,"rbtarbz2");
      QToolTip::add(radiotarbz2,i18n("Best compress rate"));
      radiotarbz2->setText(".tar.bz2");
      radiotarbz2->setChecked(true);
      box->addWidget(radiotarbz2, 2, 0);

      radiozip= new QRadioButton(bgPreferedCompressor,"rbzip");
      QToolTip::add(radiozip,"Windows default format");
      radiozip->setText(i18n(".zip"));
      box->addWidget(radiozip, 3, 0);

      radiogz= new QRadioButton(bgPreferedCompressor,"rbgz");
      QToolTip::add(radiogz,i18n("only for patches or single file"));
      radiogz->setText(".gz");
      box->addWidget(radiogz, 0, 1);

      radiobz2= new QRadioButton(bgPreferedCompressor,"rbbz2");
      QToolTip::add(radiobz2,i18n("Only for patches or single file"));
      radiobz2->setText(".bz2");
      box->addWidget(radiobz2, 1, 1);

      radiorar= new QRadioButton(bgPreferedCompressor,"rbrar");
      radiorar->setText(".rar");
      box->addWidget(radiorar, 2, 1);

      radiolha= new QRadioButton(bgPreferedCompressor,"rblha");
      radiolha->setText(".lha");
      box->addWidget(radiolha, 3, 1);

      radioarj= new QRadioButton(bgPreferedCompressor,"rbarj");
      radioarj->setText(".arj");
      box->addWidget(radioarj, 0, 2);

      radio7z= new QRadioButton(bgPreferedCompressor,"rb7z");
      radio7z->setText(".7z");
      box->addWidget(radio7z, 1, 2);

      radiosit= new QRadioButton(bgPreferedCompressor,"rbsit");
      radiosit->setText(".sit");
      box->addWidget(radiosit, 2, 2);

      radiohqx= new QRadioButton(bgPreferedCompressor,"rbsit");
      radiohqx->setText(".hqx");
      box->addWidget(radiohqx, 3, 2);
}

/*Returns the extension of the prefered archive type*/
QString CPreferences::getPreferedArchiveType()
{
  if(radiotar->isChecked())
    return ".tar";
  else if(radiotarbz2->isChecked())
    return ".tar.bz2";
  else if(radiozip->isChecked())
    return ".zip";
  else if(radiorar->isChecked())
    return ".rar";
  else if(radiogz->isChecked())
    return ".gz";
  else if(radiobz2->isChecked())
    return ".bz2";
  else if(radiolha->isChecked())
    return ".lha";
  else if(radioarj->isChecked())
    return ".arj";
  else if(radio7z->isChecked())
    return ".7z";
  else if(radiosit->isChecked())
    return ".sit";
  else if(radiohqx->isChecked())
    return ".hqx";
  return ".tar.gz";
}

void CPreferences::slotDisplayWarningOverwrite()
{
  if(cbOGZEcrase->isChecked())
  {
    if(KMessageBox::warningContinueCancel(0,i18n("If you activate this option, you will never be prompted when some of the extracted files overwrite yours. Before extracting, KArchiver offers you a convenient way to select the files you wish to keep, and those you want to extract. It is adviced to leave this option off"),i18n("Are you sure ?"))==KMessageBox::Cancel)
      cbOGZEcrase->setChecked(false);
  }
}

void CPreferences::processMyURL(const QString& adr)
{
  KProcess proc;
  proc << "konqueror" << adr;
  proc.start(KProcess::DontCare);
}

#include "cpreferences.moc"
