/***************************************************************************
                          karchiveurpart.h  -  karchiveur component extension
                             -------------------
    begin                : Tue Aug 15 2000
    copyright            : (C) 2001 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __KARCHIVEURPART_H__
#define __KARCHIVEURPART_H__

#include <kparts/part.h>
#include <kparts/browserextension.h>
#include <kparts/statusbarextension.h>
#include <kparts/factory.h>
#include <krun.h>
#include <qprogressbar.h>
#include <qwidget.h>
#include <klistview.h>
#include <kopenwith.h>
#include <kprocess.h>
#include <kstatusbar.h>

#include "karchiveur.h"
#include "carchive.h"
#include "cled.h"

class KarchiverPartListView;

class KarchiverBrowserExtension;

class KArchiverStatusBarExtension;

class KarchiverFactory : public KLibFactory
{
    Q_OBJECT
public:
    KarchiverFactory();
    virtual ~KarchiverFactory();

    virtual QObject* createObject(QObject* parent = 0, const char* name = 0, const char* classname = "QObject", const QStringList &args = QStringList());
    static KInstance *instance();
    static KAboutData *aboutData();

private:
    static KInstance *s_instance;
};



class KarchiverPart: public KParts::ReadOnlyPart
{
    Q_OBJECT
public:
    KarchiverPart(QWidget *parent = 0, const char *name = 0);
    virtual ~KarchiverPart();

private:
  virtual bool openFile();
  /** Prepare to display archive content */
  bool openArchive(const QString & archivename);
  /**enable/disable the toolbar entries */
  void enableMenus(bool);

private slots:
  void slotEnableView( bool enable );
  /** This slot will extract the archive content */
  void slotExtractArchive();
  /** This slot will extract selected file and view it with its associated software */
  void slotDisplayFiles();
  void slotMessageArchiveOperation(int message, QString messagetext);
  void slotMouseClick ( QListViewItem * );
  void slotComboDirectoriesActivated(int);

private:
signals:
  void displayStatusBarText(QString, QColor);
  

private:
  KarchiverPartListView *archivecontent;
  KarchiverBrowserExtension *m_extension;

  KAction *archiveExtract;
  KAction *archiveView;
  CArchive *archiveobj;
  CArchiveOperation* archiveoperation;
  QString tmpdir;
  bool viewbydirectories;
  KArchiverStatusBarExtension* m_statusbar;
};



class KarchiverBrowserExtension : public KParts::BrowserExtension
{
    Q_OBJECT
    friend class KarchiverPart;
public:
    KarchiverBrowserExtension(KarchiverPart *parent);
    virtual ~KarchiverBrowserExtension();
};



class KarchiverPartListView : public KListView
{
  Q_OBJECT
public:
  KarchiverPartListView( QWidget *parent=0, const char *name=0 );
  virtual ~KarchiverPartListView();
  void prepareDisplayOfArchive(QString& );
  
signals:
  void activatedisplayfiles( bool );

protected:
virtual  void resizeEvent ( QResizeEvent * );

private slots:
  /* The selection changed. Check if at least one item is selected, to
  * enable/disable the view action */
  void slotSelectionChanged();
  
private:
  void newCaption(const QString& filename);
  void createFileListView();
  
private:
  bool m_bViewInProgress;

  QString m_strFileToView;
  int nbselitems;
  
};





class KArchiverStatusBarExtension: public KParts::StatusBarExtension
{
    Q_OBJECT
public:
    KArchiverStatusBarExtension( KParts::ReadOnlyPart * parent );
    ~KArchiverStatusBarExtension();

private slots:
  void slotDisplayDefaultStatusBarMessage();
  void slotDisplayMessages(QString, QColor );
  
protected:
  CLed *led;
  QProgressBar *progress;
  KComboBox *cbdirectories;
  QLabel* statustext;
  QTimer* timer;
friend class KarchiverPart;
};

#endif
