from Cheetah.Template import Template

from blogdb import BlogDB

def _auth():
    session = Session()
    if hasattr(session, 'username') and session.username:
        return session.username
    else:
        return None
        
def _error(message):
    showPage('error', {'message': message})

def _message(message):
    showPage('message', {'message': message})

def index(entryid=None):
    """Main page"""
    body = 'Main'
    rightmenu = 'Menu'

    if not entryid:
        entries = BlogDB().getlastposts(10)
    else:
        entries = BlogDB().getentry(entryid)
    showPage('posts', locals())

def showPage(page, vars={}):
    """Actual page showing"""
    vars['pagename'] = page + '.tmpl'
    vars['username'] = _auth()
    vars['message'] = vars.get('message', None)
    print Template(file='index.tmpl', searchList=[vars])

def login(username, password, login):
    """Log in as username with the given password
    (login comes from the submit button)"""
    if username == 'Andy' and password == 'password':
        session = Session()
        session.username = username
        session.password = password
        index()
    else:
        _error('Wrong username and password!')

def logout():
    """Forget the session, logout"""
    session = Session()
    session.username = None
    session.close()
    index()

def newentry():
    """Add a new entry"""
    showPage('editpost',
        {'entryid': 'new', 'body': 'Enter Post Here!', 'subject': 'Subject'})
    
def editentry(entryid):
    """Edit an existing id"""
    entry = BlogDB().getentry(entryid)
    if not entry:
        _error('No entry with id "%s"' % entryid)
        return
    showPage('editpost', entry[0])

def saveentry(entryid=None, subject=None, body=None, addpost=None):
    """Save post, existing or new"""
    db = BlogDB()
    username = _auth()
    if not username:
        _error('You must be logged in to post!')
        return
    entry = db.getentry(entryid)
    if entry and entry[0]['username'] != username:
        _error('You can only edit your own entries!')
        return
    db.saveentry(username, entryid, subject, body)
    index()

def archive():
    showPage('archive', {'entries': BlogDB().getheaders()})

def deleteentry(entryid):
    """Delete the entry <entryid>"""
    username = _auth()
    if not username:
        _error('You must be logged in to delete entries!')
        return
    db = BlogDB()
    entry = db.getentry(entryid)
    if not entry:
        _error('No entry with id "%s"' % entryid)
        return
    if entry[0].get('username') != username:
        _error('You can only delete your own entries!')
        return          
    db.deleteentry(entryid)
    _message('Deleted the entry "%s"' % entry[0]['subject'])