"""A script to generate the code to handle a database from
a configuration script

This script is a Python script which must define at least 2 variables :
- name   : the name of the database
- fields : a list of strings of the form "name:type" where name is the
           name of the field and type, its type
           Example : fields = ['name:str','author:str','issued:datetime.date']

Additional variables can be defined :
- dbmodule       : a string with the database module name. Defaults to 
                   'gadfly'. Must be one of 'gadfly','kirbybase','sqlite'
- security       : the security level. 3 possible values :
                   'low' : anyone can edit and remove records
                   'standard' : only logged in users can manage the base, only
                   the administrator can manage the users' base
                   'high' : only the administrator can manage the base
                   Default is 'low'
"""

import os
import cStringIO
import datetime
import sys
import md5

class Field:

    def __init__(self,name,Type,input_format=None):
        self.name = name
        self.Type = Type
        self.type_name = self.Type.__name__
        if self.type_name in ['date','datetime']:
            self.type_name = 'datetime.'+self.type_name
        if input_format is not None:
            self.input_format = input_format
        else:
            self.input_format = 'input'

class BaseDescription:

    def __init__(self,args):
        for k in args.keys():
            setattr(self,k,args[k])

formats = {str:('input','textarea'),
    int:('input',),
    float:('input',),
    datetime.date:('input','calendar'),
    datetime.datetime:('input','calendar')}

types = {'int':int,'str':str,'date':datetime.date,
    'datetime':datetime.datetime,'float':float }

def save_admin_info(admin_file,login,password):
    # save md5 digest of the login and password
    out = open(admin_file,'wb')
    out.write(md5.new(login).digest())
    out.write(md5.new(password).digest())
    out.close()

def get_security(configFile):
    # initialize the variables
    conf_vars = {}
    execfile(configFile,conf_vars)
    return conf_vars.get('security','low')

def get_vars(configFile):
    # initialize the variables
    conf_vars = {'filename':configFile}
    execfile(configFile,conf_vars)
    name = os.path.splitext(os.path.basename(configFile))[0]
    conf_vars['name'] = name
    # defaults
    conf_vars.setdefault('dbmodule','buzhug')
    conf_vars.setdefault('security','low')
    conf_vars.setdefault('base_name','test')
    conf_vars.setdefault('host','localhost')
    conf_vars.setdefault('user','root')
    conf_vars.setdefault('passwd','passwd')
    
    return BaseDescription(conf_vars)

def generate_script(base,login=None,password=None):
    # initialize the variables
    name = base.name
    configFile = os.path.join(name + '.py')
    conf = get_vars(configFile)
    
    # check if 'fields' is defined in the config file

    if not hasattr(conf,'fields'):
        print "Error - configuration script must specify a variable 'fields'"
    else:
        fields = conf.fields

    # default for database module if undefined
    if not hasattr(conf,'dbmodule'):
        try:
            import buzhug
            dbmod_name = 'buzhug'
        except:
            print "Error - no database module specified in configuration " \
                "script and buzhug not installed"
    else:
        dbmod_name = conf.dbmodule

    if dbmod_name == 'buzhug':
        from db_buzhug import *
    elif dbmod_name == 'kirbybase':
        from db_kirbybase import *
    elif dbmod_name == 'gadfly':
        from db_gadfly import *
    elif dbmod_name == 'sqlite':
        from db_sqlite import *
    elif dbmod_name == 'mysql':
        from db_mysql import *

    field_names = [ field.name for field in conf.fields ]
    conf.field_names = field_names

    template = open('rs_%s.tpl' %conf.security).read()
    params = open(conf.filename).read()
    exec(params)

    # open the generated ks script
    out = open(os.path.join('applications','%s.ks' %conf.name),'w')

    out.write(template %locals())
    out.close()
    return name