import os

# equivalences in types
Integer = ['int','integer']
String = ['str','string','varchar','text']
Date = ['datetime.date']
DateTime = ['datetime.date']
Float = ['float','real']

Types = {}
Types['kirbybase'] = {
    'int' : 'int',
    'integer':'int',
    'str' : 'str',
    'string' : 'str',
    'varchar' : 'str',
    'text':'str',
    'float' : 'float',
    'real':'float',
    'bool' : 'bool',
    'boolean' : 'bool',
    'datetime.datetime' : 'datetime.datetime',
    'datetime.date' : 'datetime.date'
    }

id_name = 'recno'
modulesToImport = {}
createCode = {}
selectAllAsDict = {}
selectByUserId = {}
selectByRecordId = {}
insert = {}
remove = {}
selectUserByLogin = {}

field_list = []
field_names = ""
field_types = ""
field_string = ""
base_name = ""
table = ""
table_base = ""
table_dir = ""
users_base = ""
users_dir = ""

def fieldDefs(data_directory,name,fields,users_name):
    global field_names, field_types, field_string, field_list
    global table_name, table_base, table_dir, users_base, users_table
    global users_dir, base_name, table
    base_name = name
    abspath = os.path.join(os.path.normpath(data_directory),name)
    users_abspath = os.path.join(os.path.normpath(data_directory),users_name)
    field_list = [ '%s:%s' %(f.name,f.type_name) for f in fields ]
    field_names = [ f.name for f in fields ]
    field_types = [ f.Type.__name__ for f in fields ]
    
    table = abspath
    table_name = abspath
    users_base = users_abspath
    table_name = table_name.replace('\\','\\\\')
    users_base = users_base.replace('\\','\\\\')

# -------------------------------------------
# code to import modules and create utilities
# -------------------------------------------

def modulesToImport():
    return "import kirbybase\nimport kb_utils\n"

def makeDict(dbmod_name):
    pass    

# -------------------------
# code to create a database
# -------------------------

def createCode():
    return \
    "table = r'%(table)s'\n" \
    "# create an instance of kirbybase\n" \
    "db=kirbybase.KirbyBase()\n\n" \
    "# create the database if it doesn't already exist\n" \
    "if not os.path.exists(table):\n" \
    "    db.create(table,%(fields)s)\n" \
        %{'table':table_name,'fields':str(field_list)}

# -------------------------------
# code to open the users database
# -------------------------------

def openUsersCode():
    return ""

# -----------------------------------------------------------
# code to return all elements of the database as a dictionary
# -----------------------------------------------------------

def selectAllAsDict(name):
    return \
    "    # select all the items and return a list of dictionaries, one\n" \
    "    # for each record, indexed by the field names\n" \
    "    records=db.select(table,['recno'],['*'],returnType='dict')\n"

# --------------------------------------
# code to select a user from his user id
# --------------------------------------

def selectByUserId():
    return """        user = db.select(users,['recno'],[user_id],returnType='dict')[0]"""

# -----------------------------------
# code to select a record from its id
# -----------------------------------

def selectByRecordId():
    return """        record=db.select(table,["recno"],[recordId],returnType='dict')[0]"""

# ---------------------------------------
# code to insert a record in the database
# ---------------------------------------

def insert():
    return """    try:
        typed_fields = kb_utils.conv_rec(field_names,field_types,**untyped_fields)
    except ValueError,msg:
        error(msg)
        raise SCRIPT_END
    recordId=int(recordId)
    if recordId==-1:
        db.insert(table,typed_fields)
    else:
        db.update(table,["recno"],[recordId],typed_fields)
    db.pack(table)"""

# -----------------------
# code to remove a record
# -----------------------

def remove():
    return """    db.delete(table,["recno"],[int(recordId)])
    db.pack(table)"""

# ---------------------------------------------
# code to select a user from his login/password
# ---------------------------------------------

def selectUserByLogin():
    return """    try:
        user_record = db.select(users,['login','password'],
            [user_data['login'],user_data['password']],
            returnType = 'dict')[0]
    except IndexError:
        print "Unknown user"
        print P(A("Back",href="index"))
        return
    except kirbybase.KBError,msg:
        print "An error occured when checking login info"
        print P(msg)
        print P(A("Back",href="index"))
        return"""
