types = { 'NULL':lambda x:None,
    'INTEGER':int,
    'TEXT':unicode,
    'REAL':float,
    'BLOB':buffer }
    
inits = """from pysqlite2 import dbapi2 as sqlite

def makeDict(res):
    # convert the result of a cursor.fetchall() to a list
    # of dictionaries
    records = []
    for item in res:
        records.append(dict([(fname,item[i])
            for (i,fname) in enumerate(['recno']+field_names)]))
    return records

__id__ = 'recno'

Types = {
    int : 'INTEGER',
    str : 'TEXT',
    float : 'REAL',
    datetime : 'TEXT',
    date : 'TEXT'
    }

"""

create_or_open = """# open connection
connection = sqlite.connect(base_name)
cursor = connection.cursor()
cursor.execute("SELECT name FROM sqlite_master WHERE type='table'")
if not len(cursor.fetchall()):
    field_def = ', '.join(['recno INTEGER PRIMARY KEY'] + \
        ['%s %s' %(n,t) for (n,t) in zip(field_names, field_types)])
    sql = 'CREATE TABLE %s (%s)' %(name,field_def)
    cursor.execute(sql)
"""

all_records = """cursor.execute('SELECT %s FROM %s' %(','.join(['recno']+field_names),name))
    records = makeDict(cursor.fetchall())
"""

select_by_id = """field_string = ','.join(field_names)
        sql = 'SELECT recno,%s FROM %s WHERE recno = %s' \
            %(field_string,name,record_id)
        cursor.execute(sql)
        record = makeDict(cursor.fetchall())[0]\n"""

insert_or_update = """
    field_string = ','.join(field_names)
    # replace single quotes by double quotes
    for (k,v) in untyped_fields.items():
        untyped_fields[k]=v.replace("'","''")
    if record_id == -1:
        vals = ','.join(["'%s'" %untyped_fields[f] for f in field_names])
        sql = 'INSERT INTO %s (%s) VALUES (%s)' \\
            %(name,field_string,vals)
    else:
        vals = ','.join(["%s = '%s'" %(k,v) for (k,v) in untyped_fields.iteritems()])
        sql = 'UPDATE %s SET %s WHERE recno = %s' %(name,vals,record_id)
    sql = unicode(sql,k_config.outputEncoding)
    cursor.execute(sql)
    connection.commit()
    connection.close()
    """ 

remove = """
    sql = 'DELETE FROM %s WHERE recno = %s' %(name,record_id)
    cursor.execute(sql)
    connection.commit()
    connection.close()
"""

