import os
from HTMLTags import *
import genScript

class ConfigError(Exception):
    pass

def _options(optlist,selected=None):
    """Return the options with one selected"""
    return Sum(OPTION(t,value=t,selected = (t == selected)) for t in optlist)

def _edit_field(objname,obj):
    """Return the form to show, remove and add the field names,
    types and input format for obj = fields or users_fields"""
    e_fields = TR(TD('Name')+TD('Type')+TD('Input format')+
        TD('Action',colspan="2"))
    
    for i,f in enumerate(getattr(Session().base,obj)):
        fname,fType,finput_format = f
        e_fields += TR(
                TD(INPUT(value=fname,name="field",rows=1))+
                TD(SELECT(_options(genScript.types,fType),
                    name="Type_%s_%s" %(obj,i),
                    id="Type_%s_%s" %(obj,i),
                    onChange="change('%s',%s)" %(obj,i)))+
                TD(SELECT(
                    _options(genScript.formats[fType],finput_format),
                    name="format_%s_%s" %(obj,i),
                    id="format_%s_%s" %(obj,i),
                    )) +
              TD(INPUT(Type="button",value="Remove",
                        onclick="move('%s',%s)" %(obj,i))
                      ))
    new_field = TR(TD(INPUT(name="field_%s_new" %obj,id="field_%s_new" %obj))+
                    TD(SELECT(_options(genScript.types),
                        name="Type_%s_new" %obj, id="Type_%s_new" %obj,
                        onChange="change('%s','new')" %obj))+
                    TD(SELECT(
                        _options(genScript.formats[str]),
                            name="format_%s_new" %obj,
                            id="format_%s_new" %obj) +
                    TD(INPUT(Type="button",value="Add",
                             onclick="add('%s')" %obj),
                             colspan="2"),
                    ))
    e_fields = TR(TD(TABLE(e_fields+new_field,border="1")))
    return e_fields

def _make_base_entry(dbmodule):
    if hasattr(Session(),'base'):
        base_name = Session().base.base_name
        host = Session().base.host
        user = Session().base.user
        passwd = Session().base.passwd
        table_name = Session().base.table_name
    if dbmodule in ['sqlite','mysql']:
        e_base = TR(TD('Database name')+
            TD(INPUT(name="base_name",value=base_name)))
    if dbmodule == 'mysql':
        e_base += TR(TD('Host')+
            TD(INPUT(name="host",value=host)))+\
            TR(TD('User')+
               TD(INPUT(name="user",value=user)))+\
            TR(TD('Password')+
               TD(INPUT(name="passwd",type="password",
                    value=passwd)))
    return e_base

def index():
    Session().base = genScript.BaseDescription() # clear base description
    print H1("Karrigell script generator")
    print "This program will generate a script to manage a table"
    
    print "<br>Edit an existing application"

    existing_apps = [ os.path.splitext(f)[0] for f in os.listdir('config') ]
    print FORM(SELECT(_options(existing_apps),name="appname")
        +INPUT(Type="submit",value="Ok"),
        action="edit")

    print FORM(INPUT(Type="submit",value="Create new application with new base/table"),
        action="new")

    print FORM(INPUT(Type="submit",value="Create new application with existing base/table"),
        action="new_app")

def new():
    print H2("New application")
    print '<form action="create_new" method="post"><table>'
    print TR(TD("Application name")+TD(INPUT(name="appname")))
    print TR(TD("Database engine",valign="top") +
             TD(TABLE(Sum([TR(TD(db)+
                           TD(INPUT(Type="radio",name="dbmodule",value=db)))
           for db in ['mysql','sqlite','gadfly','buzhug']]))))
    print '</table>'
    print INPUT(Type="submit",value="Ok")
    print '</form>'

def new_app():
    print H2("New application with existing base/table")
    print '<form action="create_existing_1" method="post"><table>'
    print TR(TD("Database engine",valign="top") +
             TD(TABLE(Sum([TR(TD(db)+
                           TD(INPUT(Type="radio",name="dbmodule",value=db)))
           for db in ['mysql','sqlite','gadfly','buzhug']]))))
    print '</table>'
    print INPUT(Type="submit",value="Ok")
    print '</form>'

def create_existing_1(dbmodule):
    print H2("New application with existing base/table")
    Session().base.dbmodule = dbmodule
    print TEXT('Database engine ')+B(dbmodule)+P()
    print '<form action="create_existing_2" method="post"><table>'
    print _make_base_entry(dbmodule)
    print '</table>'
    print INPUT(Type="submit",value="Ok")
    print '</form>'

def create_existing_2(**kw):
    for k,v in kw.iteritems():
        setattr(Session().base,k,v)
    tables = genScript.get_base_info(Session().base)

    sel_tb = Sum([INPUT(t,name="table_name",
        Type="radio",value=t) for t in tables])

    e_table = TR(TD('Table name') + TD(sel_tb))
    e_security = TR(TD("Security level")+
                    TD(SELECT(_options(['low','standard'],
                        Session().base.security),name="security",
                        onChange="change_sec(this)")))

    e_login = TR(TD(TEXT('Administrator')+BR()+TEXT('Login'))+
        TD(INPUT(name='login')))
    e_password = TR(TD('Password')+TD(INPUT(name="password",type="password")))

    print HEAD(SCRIPT(src='../genScriptExisting.js')+
               LINK(rel="stylesheet",Type="text/css",href="../genScript.css"))
    
    title = H2('Generating script for base %s' %Session().base.base_name)
    form = e_table + e_security
    if Session().base.security != 'low':
        form += e_login + e_password
    form += TR(TD(INPUT(Type="submit",value="Ok"),colspan="2"))
    print BODY(title+FORM(TABLE(form),action="create_existing_3"))

def create_existing_3(**kw):
    Session().base.security = kw['security']
    Session().base.table_name = kw['table_name']
    if kw['security'] != 'low':
        Session().base.login = kw['login']
        Session().base.password = kw['password']
    __id__,info = genScript.get_table_info(Session().base)
    if __id__ is None:
        print info
        raise SCRIPT_END
    Session().base.__id__ = __id__
    Session().base.fields = info
    #_save()
    genScript.generate_script(Session().base)
    print "Script <b>%s.ks</b> generated<br>" %Session().base.table_name
    print '<a href="../applications/%s.ks">Test it</a>' \
        %Session().base.table_name
    print '<br><a href="edit">Back to configuration</a>'

def create_new(appname,dbmodule):
    exec('import db_%s as dbmod' %dbmodule)
    genScript.types = dbmod.types
    print genScript.types
    Session().base = genScript.get_vars('_default.py')
    filename = appname + '.py'
    Session().base.filename = filename
    Session().base.name = appname
    Session().base.dbmodule = dbmodule
    _save()
    raise HTTP_REDIRECTION,"edit?appname=%s" %appname

def edit(appname=''):
    """Edit configuration file"""
    if not appname:
        if not hasattr(Session(),'base'):
            raise ConfigError,"You must provide an application name"
        else:
            appname = Session().base.name
            filename = Session().base.filename
    else:
        filename = os.path.join('config',appname+'.py')
        if os.path.exists(filename):
            Session().base = genScript.get_vars(filename)
        else:
            Session().base = genScript.get_vars('_default.py')
            Session().base.filename = filename
            Session().base.name = appname

    title = "<h2>Editing application %s</h2>" %appname

    e_base = _make_base_entry(Session().base.dbmodule)

    e_fields = _edit_field('Fields','fields')
    
    e_security = TR(TD("Security level")+
                    TD(SELECT(_options(['low','standard'],
                        Session().base.security),name="security",
                        onChange="change_sec(this)")))

    e_login = TR(TD(TEXT('Administrator')+BR()+TEXT('Login'))+
        TD(INPUT(name='login')))
    e_password = TR(TD('Password')+TD(INPUT(name="password",type="password")))

    print HEAD(SCRIPT(src='../genScript.js')+
               LINK(rel="stylesheet",Type="text/css",href="../genScript.css"))
    entries = e_base+e_security
    tb = TABLE(TR(TD(TABLE(entries),Class="block")+
                  TD(TABLE(e_fields),Class="block")))
    if Session().base.security != 'low':
        tb += TABLE(TR(TD(TABLE(e_login + e_password),Class="block")))
    tb += TR(TD(INPUT(Type="submit",colspan="2",value="Save changes and generate script")))
    print BODY(TEXT(title) + FORM(tb,method="post",action="makeScript"))
            
def remove(obj,ix):
    del getattr(Session().base,obj)[int(ix)]
    raise HTTP_REDIRECTION,"edit"
    
def add(obj,field,Type,format):
    s = Session().base
    if not field:
        raise SCRIPT_ERROR,'You must enter a field name'
    
    fields = getattr(s,obj)
    for f in fields:
        if f[0] == field:
            raise SCRIPT_ERROR,'Name %s already exists' %field

    getattr(s,obj).append([field,Type,format])
    raise HTTP_REDIRECTION,"edit"

def update(**args):
    _update(**args)
    target = args.get('target','edit')
    raise HTTP_REDIRECTION,target

def _update(**args):
    s = Session().base
    for k,v in args.iteritems():
        if k.startswith('field_'):
            elts = k.split('_')
            at,i = elts[0],elts[-1]
            obj = '_'.join(elts[1:-1])
            if i == 'new':
                fname = args['field_%s_new' %obj]
                if fname:
                    getattr(s,obj).append(
                        genScript.Field(fname,
                        genScript.types[args['Type_%s_new'%obj]],
                        args['format_%s_new' %obj]))
            else:
                setattr(getattr(s,obj)[int(i)],at,v)
        elif k.startswith('Type_') or k.startswith('format_'):
            elts = k.split('_')
            at,i = elts[0],elts[-1]
            obj = '_'.join(elts[1:-1])
            if at == 'Type':
                ix = 1
            elif at == 'format':
                ix = 2
            if i != 'new':
                try:
                    getattr(s,obj)[int(i)][ix] = v
                except:
                    print obj,getattr(s,obj)
                    raise SCRIPT_END
        else:
            setattr(s,k,v)

def makeScript(**args):
    _update(**args)
    try:
        _save()
    except ConfigError,msg:
        print msg
        print '<br><a href="edit">Back</a>'
        return
    except:
        raise
        
    genScript.generate_script(Session().base)
    print "Script <b>%s.ks</b> generated<br>" %Session().base.name
    print '<a href="../applications/%s.ks">Test it</a>' %Session().base.name
    print '<br><a href="edit">Back to configuration</a>'

def update_field(obj,field,Type,format,ix):
    Type = genScript.types[Type]
    getattr(Session().base,obj)[int(ix)] = genScript.Field(field,Type,format)
    raise HTTP_REDIRECTION,"edit"

def _save():
    s = Session().base
    if s.security != 'low':
        admin_file = os.path.join('applications',s.table_name+'.ini')
        if not s.login or not s.password:
            if not os.path.exists(admin_file):
                raise ConfigError,'Administrator login or password missing'
        else:
            genScript.save_admin_info(admin_file,s.login,s.password)

    out = open(os.path.join('config','%s.py' %s.table_name),'w')
    w = out.write
    w("from datetime import date,datetime\n\n")
    
    w("name = '%s'\n" %s.table_name)
    w("fields = [" + ",\n    ".join("['%s','%s','%s']" 
        %(f[0],f[1],'input')
        for f in s.fields)+']\n')
    for attr in ['dbmodule','security','__id__']:
        w("%s = '%s'\n" %(attr,getattr(s,attr)))
    for attr in ['base_name','host','user','passwd']:
        if hasattr(s,attr):
            w("%s = '%s'\n" %(attr,getattr(s,attr)))
            
    out.close()
