/***************************************************************************
 *   Copyright (C) 2005 by Montel Laurent <montel@kde.org>                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/


#include "dlgproperties.h"
#include <kdialogbase.h>
#include <katengine.h>
#include <qvbox.h>
#include <qlabel.h>
#include <klocale.h>
#include "dlgproperties.moc"


DlgProperties::DlgProperties( QWidget *parent, KatCatalog* cat )
    : KDialogBase( parent, "kat_properties", true, i18n( "Properties" ),
                   KDialogBase::Ok, KDialogBase::Ok, true )
{
    QVBox *page = makeVBoxMainWidget();
    QLabel *label = new QLabel( page, "name" );
    label->setText( i18n( "Catalog name: %1" ).arg( cat->name() ) );

    label = new QLabel( page, "base_folder" );
    label->setText( i18n( "Base folder: %1" ).arg( cat->path() ) );

    label = new QLabel( page, "description" );
    label->setText( i18n( "Description: %1" ).arg( cat->description() ) );

    label = new QLabel( page, "author" );
    label->setText( i18n( "Author: %1" ).arg( cat->author() ) );

    label = new QLabel( page, "Notes" );
    label->setText( i18n( "Author: %1" ).arg( cat->notes() ) );

    label = new QLabel( page, "auto-update" );
    label->setText( i18n( "Auto update: %1" ).arg( (cat->autoUpdate() == 2) ? i18n( "true" ) : i18n( "false" ) ) );

}
