/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#include <kapplication.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kconfig.h>
#include <kaboutdata.h>
#include <time.h>
#include <dirent.h>
#include <sys/stat.h>
#include <kglobal.h>
#include <kstandarddirs.h>
#include <kurl.h>
#include <kio/job.h>
#include <kio/jobclasses.h>
#include <kdebug.h>

#include <qtimer.h>
#include "katutils.h"
#include "dlgmainwindow.h"

static KCmdLineOptions options[] =
{
  { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
  { "nosplash", I18N_NOOP("Disable the splash screen"), 0 },
  { "searchmode", I18N_NOOP("Activate search mode"), 0 },
  { "wizard", I18N_NOOP("Launch wizard"), 0 },
  { "onlysystray", I18N_NOOP("Launch only systray"), 0 },
  { "import <filename>", I18N_NOOP("Allow to import kat filename"), 0 },
    KCmdLineLastOption
};

int main( int argc, char** argv )
{
    KAboutData about( katAboutData() );
    KCmdLineArgs::init( argc, argv, &about );

    KCmdLineArgs::addCmdLineOptions( options );


    if( KatApplication::start() ) {
        KatApplication app;
        return app.exec();
    }
    return 0;
}
