/***************************************************************************
 *   Copyright (C) 2005 by Roberto Cappuccio and the Kat team              *
 *   Roberto Cappuccio : roberto.cappuccio@gmail.com                       *
 *   Praveen Kandikuppa : praveen9@gmail.com                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           *
 ***************************************************************************/

#ifndef _KATSCHEDULER_H_
#define _KATSCHEDULER_H_

#include <qobject.h>
#include <qmutex.h>

#include "kat_export.h"

class KatSchedulerPrivate;
class KatIndexer;

class KAT_EXPORT KatScheduler : public QObject
{
public:
    enum Priority
    {
        Idle,
        Normal,
        Immediate
    };

    KatScheduler( int, int maxWait = -1 );
    ~KatScheduler();

    void setLoad( int );
    int load() const;
    void setMaxWait( int _wait );
    int maxWait() const;


    void setMaximumWait( int );

    int requestLock( KatIndexer*, int, Priority );
    void releaseLock( int, int );

private:
    KatSchedulerPrivate* d;

    int m_lastTime;
    int m_nIndexers;
    bool m_lock;
    int m_lockedCatalog;

    QMutex m_schedMutex;

    int m_load;
    int m_maxWait;

    int getWaitTime();
};

#endif // KATSCHEDULER_H_
