/***************************************************************************
 *   Copyright (C) 2004 by Stefano Salvador                                *
 *   stefano@diamante                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "katalogservicedlg.h"

#include <katalog.h>

#include <kurl.h>
#include <kurlrequester.h>
#include <klineedit.h>
#include <kpassivepopup.h>
#include <kmessagebox.h>
#include <dcopclient.h>
#include <kdebug.h>
#include <klocale.h>
#include <kiconloader.h>

#include <qcheckbox.h>

KatalogServiceDlg::KatalogServiceDlg(QWidget* parent, const char* name, bool modal, WFlags fl) :
    KDialogServiceDlgBase(parent,name, modal,fl),
    DCOPObject("KatalogServicedlg")
{
  editFile->setFilter("*.katalog");
  this->setIcon( KGlobal::iconLoader()->loadIcon( "katalog", KIcon::Small ) );
}

KatalogServiceDlg::~KatalogServiceDlg()
{}

void KatalogServiceDlg::reject()
{
  QDialog::reject();
}

void KatalogServiceDlg::accept()
{
  QString eUrl = editFile->url();
  if( eUrl.isEmpty() )
  {
    KMessageBox::error(this, i18n("You have to enter the file"), "Error");
    return;
  }
  
  m_url_save = new KURL();
  
  m_url_save->setPath(editFile->url());
  
  if(!m_url_save->path().startsWith("/"))
  {
    editFile->setURL(editFile->lineEdit()->text().prepend("$HOME/"));
    m_url_save->setPath(editFile->url());
    m_url_save->setProtocol("file");
  }
   
  if( !m_url_save->isValid() )
  {
    KMessageBox::error(this, i18n("The file you have entered is not valid.\nPlease check it."), "Error");
    return;
  }
  
  if(m_url->isLocalFile())
    m_url->setProtocol("file");
    
  if( !initKatalog(*m_url_save) )
    return;
    
  QByteArray data, replyData;
  QCString replyType;
  QDataStream arg(data, IO_WriteOnly);
  arg << *m_url_save << *m_url << editName->text() << checkCompress->isChecked() << checkMeta->isChecked();
  
  bool a = client->connectDCOPSignal("katalogdcop", "katalogdcopInterface", "finished(QString)", "KatalogServicedlg", "finished(QString)", true);
  
  if (!client->call("katalogdcop", "katalogdcopInterface", "addItems(KURL, KURL, QString, bool, bool)",
            data, replyType, replyData))
  {
    KMessageBox::error(this, i18n("Katalog encountered un unknown error,\nprobably you have found a bug"), "Unknown error");
    return;
  }
  else {
    QDataStream reply(replyData, IO_ReadOnly);
    if (replyType == "int") {
      int result;
      reply >> result;
      if(result == Katalog::SUCCESS){
        hide();
        return;
      }
      else
        KMessageBox::error(this, i18n("Katalog encountered an error reading files,\ncheck to have the right permissions"), "Error");
    } else {
      KMessageBox::error(this, i18n("Katalog encountered un unknown error,\nprobably you have found a bug"), "Unknown error");
      return;
    }
  }
}

void KatalogServiceDlg::finished(QString url)
{
  if(url.compare(m_url->path()) == 0)
  {
    QByteArray data, replyData;
    QCString replyType;
    QDataStream arg(data, IO_WriteOnly);
    arg << *m_url_save << "";
    if (!client->call("katalogdcop", "katalogdcopInterface", "saveDocument(KURL, QString)",
              data, replyType, replyData))
    {
      KMessageBox::error(this, "Katalog encountered un unknown error,\nprobably you have found a bug", "Unknown error");
      QDialog::accept();  
      return;
    }
    else {
      QDataStream reply(replyData, IO_ReadOnly);
      if (replyType == "bool") {
        bool result;
        reply >> result;
        if(result)
        {
          KPassivePopup *popup = new KPassivePopup();
          popup->setTimeout(0);
          popup->setView("Katalog", QString(i18n("Catalog <I>%1</I> complete !")).arg(editName->text()));
          popup->show();
          connect(popup, SIGNAL(clicked()), this, SLOT(slotClose()));
        }
        else
        {
          KMessageBox::error(this, QString(i18n("Unable to write to file:\n%1,\ncheck to have the right permissions")).arg(m_url_save-> url()), "Error");
          QDialog::accept();  
          return;
        }
      } else {
        KMessageBox::error(this, i18n("Katalog encountered un unknown error,\nprobably you have found a bug"), "Unknown error");
        QDialog::accept();  
        return;
      }
    }
  }
}

void KatalogServiceDlg::slotClose()
{
  if(client->isApplicationRegistered("katalogdcop"))
  {
    QByteArray data;
    QDataStream arg(data, IO_WriteOnly);
    client->send("katalogdcop", "katalogdcopInterface", "exit()", data);
  }
  QDialog::accept();  
}

void KatalogServiceDlg::setURL(KURL* url)
{
  m_url = url;
}

void KatalogServiceDlg::wakeDCOP()
{
  if(client->isApplicationRegistered("katalogdcop"))
  {
    return; 
  }
  
  QString app("katalogdcop.desktop");
  
  QByteArray data, replyData;
  QCString replyType;
  QDataStream arg(data, IO_WriteOnly);
  QStringList URLs;
  arg << app << URLs;
  if ( !client->call( "klauncher", "klauncher", "start_service_by_desktop_path(QString,QStringList)",  
        data, replyType, replyData) ) {
  } else {
    QDataStream reply(replyData, IO_ReadOnly);

    int result;
    QCString dcopName;
    QString error;
    reply >> result >> dcopName >> error;
  }
}

bool KatalogServiceDlg::initKatalog( const KURL & url )
{
  wakeDCOP();
  
  if(url.isLocalFile() && QFile::exists(url.path()))
  {
    int i = KMessageBox::warningContinueCancel(this, QString(i18n("The file %1 already exist in this directory,\nif you continue the new items are appended")).arg(url.fileName()), "File exists");
    if(i == KMessageBox::Cancel)
      return false;
  }
  
  QByteArray data, replyData;
  QCString replyType;
  QDataStream arg(data, IO_WriteOnly);
  arg << url;
  if (!client->call("katalogdcop", "katalogdcopInterface", "initDocument(KURL)",
            data, replyType, replyData))
  {
    KMessageBox::error(this, i18n("Katalog encountered un unknown error,\nprobably you have found a bug"), "Unknown error");
    return false;
  }
  else {
    QDataStream reply(replyData, IO_ReadOnly);
    if (replyType == "int") {
      int result;
      reply >> result;
      if(result == Katalog::SUCCESS)
        return true;
      else {
        KMessageBox::error(this, QString(i18n("%1 does not seems a valid katalog file")).arg(url.fileName()), "Invalid file");
        return false;
      }
    } else {
      KMessageBox::error(this, QString(i18n("%1 does not seems a valid katalog file")).arg(url.fileName()), "Invalid file");
      return false;
    }
  }
  
  return false;
}

#include "katalogservicedlg.moc"
