/* This file is part of the KDE desktop environment

   Copyright (C) 2001, 2002 Michael Brade <brade@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include <qlayout.h>
#include <qpushbutton.h>
#include <qfile.h>

#include <kapplication.h>
#include <dcopclient.h>
#include <kdebug.h>
#include <kpassivepopup.h>
#include <kprotocolinfo.h>

#include <kataloguds.h>
#include "katalog.h"
#include "main.h"

QCString appId;
DCOPClient *client;

KatalogTest::KatalogTest( QWidget *parent, const char *name )
  : QWidget( parent, name )
{
    QStringList fonts;
    fonts.append( "Times" );
    fonts += "Courier";
    fonts += "Courier";
    fonts << "Helvetica [Cronyx]" << "Helvetica [Adobe]";
    
    for ( QStringList::Iterator it = fonts.begin(); it != fonts.end(); ++it ) {
        kdDebug() << *it << endl;
    }
  
  k = new Katalog();
  k->initDocument( KURL("/home/stefano/test2.katalog"));
  
  QPushButton* start1 = new QPushButton( "Create !!!", this );
  QPushButton* start2= new QPushButton( "List ...", this );
  QPushButton* start3= new QPushButton( "Direct ...", this );
  QPushButton* test = new QPushButton( "Quit", this );

  QVBoxLayout* layout = new QVBoxLayout( this );
  
  layout->addWidget( start1 );
  layout->addWidget( start2 );
  layout->addWidget( start3 );
  layout->addWidget( test );
  resize( layout->sizeHint() );
  connect( start1, SIGNAL( clicked() ), SLOT( start1() ) );
  connect( start2, SIGNAL( clicked() ), SLOT( start2() ) );
  connect( start3, SIGNAL( clicked() ), SLOT( start3() ) );
  connect( test, SIGNAL( clicked() ), SLOT( test() ) );

  if(client->isApplicationRegistered("katalogdcop"))
  {
    kdDebug() << "already registered !!! " << endl;
    return; 
  }
  
  QString app("katalogdcop.desktop");
  
  QByteArray data, replyData;
  QCString replyType;
  QDataStream arg(data, IO_WriteOnly);
  QStringList URLs;
  arg << app << URLs;
  if ( !client->call( "klauncher", "klauncher", "start_service_by_desktop_path(QString,QStringList)",  
        data, replyType, replyData) ) {
    kdDebug() << "call failed" << endl;
  } else {
    QDataStream reply(replyData, IO_ReadOnly);

    if ( replyType != "serviceResult" )
    {
      kdDebug() << "unexpected result " << replyType.data() << endl;
    }
    int result;
    QCString dcopName;
    QString error;
    reply >> result >> dcopName >> error;
    if (result != 0)
    {
      kdDebug() << "Error: " << error.local8Bit().data() << endl;
    }
    if (!dcopName.isEmpty())
      kdDebug() << dcopName << endl;
  }
}

KatalogTest::~KatalogTest()
{
  delete k;
}

void KatalogTest::start3()
{
  k->initDocument( KURL("file:/home/stefano/bug4.xml.gz") );
  k->addItems( KURL("file:/home/stefano/Katalog Test"), "Bug 4", false, false);
  connect( k, SIGNAL( finished() ), SLOT( slotFinished() ) );
}

void KatalogTest::start1()
{
//  k->addItems( KURL("file:/home/stefano/img"), "Immagini", true, true);
//  connect( k, SIGNAL( finished() ), SLOT( slotFinished() ) );
  // <DCOP>
  QByteArray data, replyData;
  QCString replyType;
  QDataStream arg(data, IO_WriteOnly);
  KURL openUrl;
  openUrl.setPath("/home/stefano/test1.katalog");
  openUrl.setProtocol("file");
  arg << openUrl;
  
  if (!client->call("katalogdcop", "katalogdcopInterface", "initDocument(KURL)",
            data, replyType, replyData))
    kdDebug() << "there was some error using DCOP." << endl;
  else {
    QDataStream reply(replyData, IO_ReadOnly);
    if (replyType == "int") {
      int result;
      reply >> result;
      kdDebug() << "the result is: " << result << endl;
    } else
      kdDebug() << "doIt returned an unexpected type of reply!" << endl;;
  }
  // </DCOP>
}

void KatalogTest::start2()
{
  QByteArray data, replyData;
  QCString replyType;
  QDataStream arg(data, IO_WriteOnly);
  KURL katalogUrl;
  katalogUrl.setPath("/home/stefano/test1.katalog");
  katalogUrl.setProtocol("katalog");
  QString string("Immagini");
  arg << katalogUrl << string;
  
  if (!client->call("katalogdcop", "katalogdcopInterface", "getNodeContent(KURL, QString )",
            data, replyType, replyData))
    kdDebug() << "there was some error using DCOP." << endl;
  else {
    QDataStream reply(replyData, IO_ReadOnly);
    if (replyType == "KatalogUDSEntryList") {
      KatalogUDSEntryList result;
      reply >> result;
      kdDebug() << result.count() << endl;
      KatalogUDSEntryListConstIterator it = result.begin();
      KatalogUDSEntryListConstIterator end = result.end();
      for ( ; it != end; ++it )
      {
        QString name;

        KatalogUDSEntry::ConstIterator entit = (*it).begin();
        for( ; entit != (*it).end(); ++entit )
          if ( (*entit).m_uds == UDS_NAME )
          {
            name = (*entit).m_str;
            break;
          }
          kdDebug() << name  << endl;
      }
    } else
      kdDebug() << "doIt returned an unexpected type of reply!" << endl;;
  }
}

void KatalogTest::test()
{
  close();
}

void KatalogTest::slotFinished()
{
  kdDebug() << "SAVING\n";
  KPassivePopup::message("Finished !!!", this);
  k->saveDocument( KURL("/home/stefano/test1.katalog"));
}

int main ( int argc, char *argv[] )
{
  KApplication app( argc, argv, "kdirlistertest" );
  client = app.dcopClient();
  client->attach();
  appId = client->registerAs(app.name());

  KatalogTest *test = new KatalogTest( 0 );
  test->show();
  app.setMainWidget( test );
  return app.exec();
}

#include "main.moc"
