/*
 * katoob.cc
 * This file is part of katoob
 *
 * Copyright (C) 2006 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <iostream>
#include "katoob.hh"

Katoob::Katoob(int argc, char *argv[]) : Gtk::Main(argc, argv), conf(encodings)
{
  parse(argc, argv);
#ifdef ENABLE_DBUS
  if (ping())
    {
      if (open_files(files))
	exit(0);
    }
  else {
    start();
  }
#endif
}

void Katoob::parse(int argc, char *argv[])
{
  for (int x = 1; x < argc; x++)
    {
      if ((!strcmp(argv[x], "-u")) || (!strcmp(argv[x], "--usage")))
	{
	  usage();
	  exit(0);
	}
      if ((!strcmp(argv[x], "-h")) || (!strcmp(argv[x], "--help")))
	{
	  help();
	  exit(0);
	}
      if ((!strcmp(argv[x], "-v")) || (!strcmp(argv[x], "--version")))
	{
	  version();
	  exit(0);
	}
      files.push_back(argv[x]);
    }
}

int Katoob::run()
{
  Gtk::Main::run();
  return 0;
}

void Katoob::window()
{
  // TODO: Use open_files() instead of passing them to the constructor ??
  Window *win = new Window(conf, encodings, files);
  win->signal_quit.connect(sigc::mem_fun(*this, &Katoob::quit_cb));
  children.push_back(win);
#ifdef ENABLE_DBUS
  signal_open_files.connect(sigc::mem_fun(win, &Window::open_files));
#endif
}

void Katoob::usage()
{
  std::cout << "usage: katoob [--help] [--version] [--usage] [file1 file2 file3... ]" << std::endl;
}

void Katoob::version()
{
  std::cout << "katoob " << VERSION << std::endl;
}

void Katoob::help()
{
  std::cout << "usage: katoob  [OPTIONS] [FILES_TO_OPEN]" << std::endl
	    << "  -h, --help       Show this help message" << std::endl
	    << "  -v, --version    Display version information" << std::endl
	    << "  -u, --usage      Display brief usage message" << std::endl;
}

void Katoob::quit_cb()
{
  Gtk::Main::quit();
}
