/*
 * searchdialog.hh
 * This file is part of katoob
 *
 * Copyright (C) 2006 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __SEARCHDIALOG_HH__
#define __SEARCHDIALOG_HH__

#include <gtkmm/dialog.h>
#include <gtkmm/entry.h>
#include <gtkmm/checkbutton.h>
#include <gtkmm/box.h>

class SearchDialog {
public:
  SearchDialog();
  ~SearchDialog();
  bool run();

  bool whole_word() { return _whole_word.get_active(); }
  bool match_case() { return _match_case.get_active(); }
  bool wrap() { return _wrap.get_active(); }
  bool backwards() { return _backwards.get_active(); }
  bool beginning() { return _beginning.get_active(); }
  std::string get_text() { return what.get_text(); }

  void whole_word(bool st) { _whole_word.set_active(st); }
  void match_case(bool st) { _match_case.set_active(st); }
  void wrap(bool st) { _wrap.set_active(st); }
  void backwards(bool st) { _backwards.set_active(st); }
  void beginning(bool st) { _beginning.set_active(st); }
  void set_text(std::string& text) { what.set_text(text); }
private:
  //  void insert_at_cursor_cb(const Glib::ustring&);

  Gtk::Dialog dialog;
  // TODO: Use a drop down combo or something.
  Gtk::Entry what;
  /*  Gtk::Entry with; */
  Gtk::Label label;
  Gtk::CheckButton _whole_word;
  Gtk::CheckButton _match_case;
  //  Gtk::CheckButton regex;
  Gtk::CheckButton _wrap;
  Gtk::CheckButton _cursor;
  Gtk::CheckButton _backwards;
  Gtk::CheckButton _beginning;
  Gtk::HBox hbox;
  Gtk::VBox vbox;
  Gtk::Button *find;
};

#endif /* __SEARCHDIALOG_HH__ */
