/*
 * textbuffer.cc
 * This file is part of katoob
 *
 * Copyright (C) 2006 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include "textbuffer.hh"
#include "utils.hh"

TextBuffer::TextBuffer()
{
  _insert = create_mark(begin());
  _erase = 0;
}

TextBuffer::~TextBuffer()
{
  // Don't delete!
  //  delete_mark(_insert);
}

void TextBuffer::on_insert (const Gtk::TextBuffer::iterator& pos, const Glib::ustring& text, int bytes)
{
  move_mark(_insert, pos);
  Glib::ustring utf8;
  if (Utils::is_lam_alef(text, utf8))
    Gtk::TextBuffer::on_insert(pos, utf8, utf8.bytes());
  else
    Gtk::TextBuffer::on_insert(pos, text, bytes);
}

void TextBuffer::on_erase(const Gtk::TextBuffer::iterator& start, const Gtk::TextBuffer::iterator& end)
{
  _erase = end.get_line();
  _deleted = get_text(start, end, false);
  Gtk::TextBuffer::on_erase(start, end);
}
