/*
 * multipress.hh
 * This file is part of katoob
 *
 * Copyright (C) 2007 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __MULTIPRESS_HH__
#define __MULTIPRESS_HH__

#include <string>
#include <map>
#include <vector>
#include "multipresswindow.hh"

class Multipress {
public:
  Multipress();
  ~Multipress();
  bool ok(std::string&);
  std::vector<std::string>& list_layouts();
  bool parse_file(std::string&, std::map<std::string, std::vector<std::string> >&);
  void activate(int);
  bool get_active();
  bool get(gunichar, int);

  std::map<std::string, std::vector<std::string> >& get_layout();

  sigc::signal<void, std::string&> signal_insert_key;
  sigc::signal<void, GdkEventKey *> signal_invalid_key;
private:
  void signal_insert_key_cb(std::string&);
  void signal_invalid_key_cb(GdkEventKey *);
  bool signal_change_key_cb(gunichar);

  bool get_values(gunichar&, std::vector<std::string>&);
  MultipressWindow window;
  bool _ok;
  std::string _err;
  std::vector<std::string> names;
  std::vector<std::map<std::string, std::vector<std::string> > > layouts;
  int layout;
};

#endif /* __MULTIPRESS_HH__ */
