/*
 * textbuffer.hh
 * This file is part of katoob
 *
 * Copyright (C) 2006 Mohammed Sameer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __TEXTBUFFER_HH__
#define __TEXTBUFFER_HH__

#include <gtkmm/textbuffer.h>
#ifdef ENABLE_HIGHLIGHT
#include <gtksourceview/gtksourcebuffer.h>
#include "sourcemanager.hh"
#endif

class TextBuffer : public Gtk::TextBuffer {
public:
  TextBuffer();
  ~TextBuffer();
  static Glib::RefPtr<TextBuffer> create() { return Glib::RefPtr<TextBuffer>( new TextBuffer() ); }

  int get_mark_insert_position() { return _insert->get_iter().get_offset(); }
  int get_mark_insert_line() { return _insert->get_iter().get_line(); }
  int get_erase_line() { return _erase; }
  std::string& get_deleted() { return _deleted; }
  void clear_deleted() { _deleted.clear(); }
#ifdef ENABLE_HIGHLIGHT
  void set_highlight(bool);
  void set_language(SourceLanguage*&);
#endif
protected:
  void on_insert (const Gtk::TextBuffer::iterator&, const Glib::ustring&, int);
  Glib::RefPtr<Mark> _insert;
  void on_erase(const Gtk::TextBuffer::iterator&, const Gtk::TextBuffer::iterator&);
private:
  std::string _deleted;
  int _erase;
};

#endif /* __TEXTBUFFER_HH__ */
