{-
    Kaya - My favourite toy language.
    Copyright (C) 2004, 2005 Edwin Brady

    This file is distributed under the terms of the GNU General
    Public Licence. See COPYING for licence.
-}

module Options where

import System
import Lib

data Option = NoPrelude | DumpTAC | DumpTree | DumpRaw | KeepC | ShowGCC
	    | DumpEqns | Libdir String | XMLDocs | HTMLDocs
	    | SeedKey String | ForceBuild | NoChase | Quiet
	    | DynLink String | NoOpts | Profile
  deriving (Show, Eq)

type Options = [Option]

nolink opts = False
doprelude opts = not $ elem NoPrelude opts
dumptac opts = elem DumpTAC opts
dumptree opts = elem DumpTree opts
dumpraw opts = elem DumpRaw opts
dumpeqns opts = elem DumpEqns opts
keepc opts = elem KeepC opts
showgcc opts = elem ShowGCC opts
xmldocs opts = elem XMLDocs opts
htmldocs opts = elem HTMLDocs opts
forcebuild opts = elem ForceBuild opts
nochase opts = elem NoChase opts
quiet opts = elem Quiet opts
noopts opts = elem NoOpts opts
profile opts = elem Profile opts

getlibdir [] acc = acc
getlibdir (Libdir d:xs) acc = getlibdir xs (d:acc)
getlibdir (_:xs) acc = getlibdir xs acc

getdynlinks [] acc = ("kayastd":"kayaweb":"kayare":acc) -- Standard library
getdynlinks (DynLink d:xs) acc = getdynlinks xs (d:acc)
getdynlinks (_:xs) acc = getdynlinks xs acc

getseed [] = Nothing
getseed ((SeedKey x):xs) = Just x
getseed (x:xs) = getseed xs

usage :: [String] -> IO (String,[String],[Option])
usage xs = do (f,ext, opts) <- parseargs xs
	      return (f, ext, opts)

parseargs [] = do putStrLn $ "Kaya version " ++ Lib.version
		  putStrLn "Usage: \n\t kayac <filename> [options]"
		  exitWith (ExitFailure 1)
parseargs xs = do (opts,x:rest) <- getopts xs
		  return (x,rest,opts)

getopts [] = return ([],[])
getopts ("-v":[]) = do putStrLn $ "Kaya version " ++ Lib.version
		       exitWith (ExitSuccess)
getopts ("-installdir":[]) = do putStrLn $ libdir
				exitWith (ExitSuccess)
getopts ("-noprelude":xs) = do (opts,rest) <- getopts xs
			       return (NoPrelude:opts,rest)
getopts ("-dumptac":xs) = do (opts,rest) <- getopts xs
			     return (DumpTAC:opts,rest)
getopts ("-dumptree":xs) = do (opts,rest) <- getopts xs
			      return (DumpTree:opts,rest)
getopts ("-dumpraw":xs) = do (opts,rest) <- getopts xs
			     return (DumpRaw:opts,rest)
getopts ("-dumpeqns":xs) = do (opts,rest) <- getopts xs
			      return (DumpEqns:opts,rest)
getopts ("-keepc":xs) = do (opts,rest) <- getopts xs
			   return (KeepC:opts,rest)
getopts ("-showgcc":xs) = do (opts,rest) <- getopts xs
			     return (ShowGCC:opts,rest)
getopts ("-L":dir:xs) = do (opts,rest) <- getopts xs
			   return (Libdir (dir++"/"):opts,rest)
getopts ("-d":dyn:xs) = do (opts,rest) <- getopts xs
			   return (DynLink dyn:opts,rest)
getopts ("-libdir":dir:xs) = do (opts,rest) <- getopts xs
				return (Libdir (dir++"/"):opts,rest)
getopts ("-seedkey":val:xs) = do (opts,rest) <- getopts xs
				 return(SeedKey val:opts,rest)
getopts ("-xmldocs":xs) = do (opts,rest) <- getopts xs
			     return (XMLDocs:opts,rest)
getopts ("-htmldocs":xs) = do (opts,rest) <- getopts xs
			      return (HTMLDocs:opts,rest)
getopts ("-force":xs) = do (opts,rest) <- getopts xs
			   return (ForceBuild:opts,rest)
getopts ("-nochase":xs) = do (opts,rest) <- getopts xs
			     return (NoChase:opts,rest)
getopts ("-q":xs) = do (opts,rest) <- getopts xs
		       return (Quiet:opts,rest)
getopts ("-noopts":xs) = do (opts,rest) <- getopts xs
			    return (NoOpts:opts,rest)
getopts ("-profile":xs) = do (opts,rest) <- getopts xs
			     return (Profile:opts,rest)
getopts (x:xs) = do (opts,rest) <- getopts xs
		    return (opts,x:rest)
