/**
    Kaya run-time system
    Copyright (C) 2004, 2005 Edwin Brady

    This file is distributed under the terms of the GNU Lesser General
    Public Licence. See COPYING for licence.
*/

using namespace std;

#include <iostream>

#include "Closure.h"
#include "VMState.h"
#include "stdfuns.h"

Closure::Closure(VMState* vm, func fn, int args, bool stack):m_fn(fn)
{
//    cout << "Making closure " << (void*)(m_fn) << endl;
    m_args=(Value**)GC_MALLOC_UNCOLLECTABLE(sizeof(Value*)*args);
    m_numargs=args;
    if (stack) {
	for(int i=0;i<args;i++) {
//	cout << "Arg" << endl;
/// Create a *new* reference, or things break in confusing ways.
	    Value* top = vm->topItem();
	    m_args[i]=new Value(top->getRaw(),
			    top->getFunTable());
	    vm->doPop();
//	m_args[i]=vm->doPop();
	}
    }
}

Closure::~Closure()
{
    GC_FREE(m_args);
}

void Closure::run(VMState* vm)
{
//    cout << "Running closure " << (void*)(m_fn) << " args " << m_numargs << endl;
    for(int i=m_numargs;i>0;i--) {
	vm->push(m_args[i-1]);
    }
    m_fn(vm);
}

bool Closure::eq(Closure* c)
{
    if (getFnID()!=c->getFnID()) { return false; }
    if (m_numargs!=c->m_numargs) { return false; }

    for(int i=0;i<m_numargs;i++)
    {
	if (!funtable_eq(m_args[i],c->m_args[i])) { return false; }
    }
    return true;

}

Closure* Closure::copy()
{
    // FIXME: This ought to clone the arguments to be a proper copy
    return this;
}
