#ifndef _STDFUNS_H
#define _STDFUNS_H

/**
    Kaya run-time system
    Copyright (C) 2004, 2005 Edwin Brady

    This file is distributed under the terms of the GNU Lesser General
    Public Licence. See COPYING for licence.
*/

// Standard functions for linking into the standard library

#include <stdio.h>
#include "Heap.h"
#include "KayaAPI.h"
#include "unpickler.h"
#include <map>

typedef map<char*,char*> ArgMap;

extern KayaArray args;

char* inttostr(int s, int base);
int strtoint(char* str, int base);

char* getsubstr(char* x,int i,int len);
char* getstrend(char* x,int i);
char* readstr();

unsigned char getIndex(char* str,int i);

char* getLine(FILE* file);
void putLine(FILE* f, char* c);

FILE* getstdin();
FILE* getstdout();
FILE* getstderr();
void setStdErr(FILE* f);

bool validFile(FILE* f);

void printArray(KayaArray foo);
KayaArray reverseArray(KayaArray foo);
void shortenArray(KayaArray foo);
KayaValue shiftArray(KayaArray foo);
KayaArray createArray(int size);
void resizeArray(KayaArray foo, int size);
int arraySize(KayaArray foo);

void storeArgs(int argc,char* argv[]);
KayaArray getArgs();

int gettime();
int getclock();
KayaValue dogmtime(int secs);
KayaValue dolocaltime(int secs);
int domktime(KayaValue time);

int runProgram(char* prog, KayaArray args);
int dofork();
int dowait();
int dowaitpid(int pid);
void reap();


char* b64enc(char* block, int len);
char* b64dec(char* block, KayaValue len);

char* mkString(KayaValue x);

void quicksort(KayaArray xs, KayaValue sortfn);

#define funtable_compare(x,y) x->getFunTable()->cmp(x,y)->getInt()

//int funtable_compare(KayaValuex, KayaValue y);
bool funtable_eq(KayaValue x, KayaValue y);
int funtable_hash(KayaValue x);
char* funtable_marshal(void* vmptr,KayaValue x,int id);
char* funtable_marshal_aux(void* vmptr,vector<KayaValue>& done,KayaValue x, int i);
KayaValue funtable_copy(KayaValue x);

KayaValue unsafe_id(KayaValue x);

char* getAddr(KayaValue x);

char* except_msg(KayaValue x);
int except_code(KayaValue x);

int doGetFnID(KayaValue fn);
void callFnID(void* vmptr, int id, KayaValue arg);

int memusage();

int isNull(void* p);

// Added by Chris Morris, 18/6/05
int do_access(char* pathname, KayaValue mode);

int do_setrlimit(KayaValue lim, int soft, int hard);

#endif
