#ifndef _BINARY_H // -*-C++-*-
#define _BINARY_H

#include <Heap.h>
#include <stdio.h>
#include <KayaAPI.h>

typedef unsigned char BYTE;

extern "C" {
    void* newBlock(int size);
    void poke(void* block,int offset,int val);
    int peek(void* block,int offset);

    void pokestring(void* block, int offset, char* str);
    char* peekstring(void* block, int offset);

    void* copyBlock(void* block,int size);
    void* copyChunk(void* block,int offset,int size);

    KayaArray getBlockData(void* block, int offset,int size);
    void setBlockData(void* block, int offset, int size, KayaArray data);

    int writeBlock(FILE* f,void* block, int size);
    void* readBlock(FILE* f, KayaValue size);

    char* b64binary(void* block, int len);
    void* b64binarydec(char* block, KayaValue len);
}

#endif
